/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.BgKinRunner;
import chiropraxis.kingtools.ModelManager2;
import driftwood.data.UberMap;
import driftwood.gui.AttentiveComboBox;
import driftwood.gui.AttentiveTextField;
import driftwood.gui.ExpSlider;
import driftwood.gui.TablePane;
import driftwood.util.SoftLog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import king.KingMain;
import king.core.Kinemage;

public class NoePanel
extends TablePane
implements ActionListener,
ChangeListener {
    static DecimalFormat df = new DecimalFormat("0.0###");
    KingMain kMain;
    ModelManager2 modelman;
    BgKinRunner noePlotter = null;
    AttentiveComboBox cmDisplaySel;
    JTextField tfRescaleSel;
    ExpSlider slRescale;
    JComboBox coColorBy;
    JComboBox coDistCalc;
    JComboBox coDistCorr;
    JCheckBox cbEnumAmbig;
    JTextField tfMoreFlags;
    Map mapColorBy;
    Map mapDistCalc;
    Map mapDistCorr;

    public NoePanel(KingMain kingMain, ModelManager2 modelManager2) {
        this.kMain = kingMain;
        this.modelman = modelManager2;
        this.buildMaps();
        this.buildGUI();
    }

    private void buildMaps() {
        this.mapColorBy = new UberMap();
        this.mapColorBy.put("ratio (model dist/target dist)", "-cr");
        this.mapColorBy.put("NOE target distance", "-cd");
        this.mapColorBy.put("violations (model - target >= 0.5)", "-cv");
        this.mapDistCalc = new UberMap();
        this.mapDistCalc.put("geometric center", "-dc");
        this.mapDistCalc.put("r^-6 summation", "-ds");
        this.mapDistCorr = new UberMap();
        this.mapDistCorr.put("none", "");
        this.mapDistCorr.put("add", "+");
        this.mapDistCorr.put("remove", "-");
    }

    private void buildGUI() {
        NoePanel noePanel = this;
        this.slRescale = new ExpSlider(0.5, 2.0, 50);
        this.slRescale.setDouble(1.0);
        this.slRescale.setLabels(5, new DecimalFormat("0.#"));
        this.slRescale.addChangeListener(this);
        this.tfRescaleSel = new AttentiveTextField("*");
        this.tfRescaleSel.addActionListener(this);
        this.cmDisplaySel = new AttentiveComboBox(new Object[]{"{molten}", "within 5 of {viewcenter}", "all", "viol"});
        this.cmDisplaySel.addActionListener(this);
        this.coColorBy = new JComboBox<Object>(this.mapColorBy.keySet().toArray());
        this.coColorBy.addActionListener(this);
        this.coDistCalc = new JComboBox<Object>(this.mapDistCalc.keySet().toArray());
        this.coDistCalc.addActionListener(this);
        this.coDistCorr = new JComboBox<Object>(this.mapDistCorr.keySet().toArray());
        this.coDistCorr.addActionListener(this);
        this.cbEnumAmbig = new JCheckBox("Enumerate ambiguous NOEs");
        this.cbEnumAmbig.addActionListener(this);
        this.tfMoreFlags = new AttentiveTextField("");
        this.tfMoreFlags.addActionListener(this);
        noePanel.save().insets(0).hfill(true).vfill(true).startSubtable(2, 1);
        noePanel.save().weights(0.0, 1.0).addCell(new JLabel("Color by:")).restore();
        noePanel.save().right().addCell(this.coColorBy).restore();
        noePanel.endSubtable().restore();
        noePanel.newRow();
        noePanel.save().weights(0.0, 1.0).addCell(new JLabel("display:")).restore();
        noePanel.save().hfill(true).addCell(this.cmDisplaySel).restore();
        noePanel.newRow();
        noePanel.addCell(this.cbEnumAmbig, 2, 1);
        noePanel.newRow();
        noePanel.save().weights(0.0, 1.0).addCell(new JLabel("rescale:")).restore();
        noePanel.save().hfill(true).addCell(this.tfRescaleSel).restore();
        noePanel.newRow();
        noePanel.save().hfill(true).addCell(this.slRescale, 2, 1).restore();
        noePanel.newRow();
        noePanel.addCell(TablePane.strut(0, 4));
        noePanel.newRow();
        noePanel.save().insets(0).hfill(true).vfill(true).startSubtable(2, 1);
        noePanel.addCell(new JLabel("Pseudoatom distance calc:"));
        noePanel.addCell(new JLabel("Corrections:"));
        noePanel.newRow();
        noePanel.save().hfill(true);
        noePanel.addCell(this.coDistCalc);
        noePanel.addCell(this.coDistCorr);
        noePanel.restore();
        noePanel.endSubtable().restore();
        noePanel.newRow();
        noePanel.save().insets(0).hfill(true).vfill(true).startSubtable(2, 1);
        noePanel.save().weights(0.0, 1.0).addCell(new JLabel("More flags:")).restore();
        noePanel.save().hfill(true).addCell(this.tfMoreFlags).restore();
        noePanel.endSubtable().restore();
    }

    BgKinRunner getNoePlotter() {
        Kinemage kinemage = this.kMain.getKinemage();
        if (!(kinemage == null || this.noePlotter != null && this.noePlotter.getKinemage().equals(kinemage))) {
            if (this.noePlotter != null) {
                this.noePlotter.terminate();
            }
            this.noePlotter = new BgKinRunner(this.kMain, kinemage, "");
        }
        return this.noePlotter;
    }

    public void visualizeNOEs(Collection collection, File file, String string) {
        try {
            BgKinRunner bgKinRunner = this.getNoePlotter();
            String string2 = this.mapColorBy.get(this.coColorBy.getSelectedItem()).toString();
            String string3 = this.mapDistCalc.get(this.coDistCalc.getSelectedItem()).toString();
            String string4 = this.mapDistCorr.get(this.coDistCorr.getSelectedItem()).toString();
            String string5 = this.cbEnumAmbig.isSelected() ? "-a" : "";
            String string6 = this.tfMoreFlags.getText();
            String string7 = " -t -g 'Dynamic NOEs' -f  " + string2 + " " + string3 + string4 + " -n " + string + " -s '" + this.getDisplaySelection() + "'" + " -r " + df.format(this.slRescale.getDouble()) + " '" + this.getRescaleSelection() + "'" + " " + string5 + " " + string6 + " '{pdbfile}' '" + file.getCanonicalPath() + "'";
            String string8 = this.noePlotter.findProgram("noe-display");
            this.noePlotter.setCommand(string8 + string7);
            bgKinRunner.requestRun(collection, this.modelman.getMoltenState(), this.modelman.getFrozenPDB());
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
    }

    String getDisplaySelection() {
        return this.cmDisplaySel.getText();
    }

    String getRescaleSelection() {
        return this.tfRescaleSel.getText();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.modelman.requestStateRefresh();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.modelman.requestStateRefresh();
    }
}

