/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.forcefield;

import chiropraxis.forcefield.EnergyTerm;

public class BondTerm
implements EnergyTerm {
    static final double MIN_R = 1.0E-6;
    int a;
    int b;
    double k;
    double r0;

    public BondTerm(int n, int n2, double d, double d2) {
        this.a = n * 3;
        this.b = n2 * 3;
        this.r0 = d;
        this.k = d2;
    }

    public double eval(double[] dArray, double[] dArray2) {
        double d = dArray[this.a] - dArray[this.b];
        double d2 = dArray[this.a + 1] - dArray[this.b + 1];
        double d3 = dArray[this.a + 2] - dArray[this.b + 2];
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d4 < 1.0E-6) {
            d4 = 1.0E-6;
        }
        double d5 = d4 - this.r0;
        double d6 = this.k * (d5 * d5);
        double d7 = 2.0 * this.k * d5 / d4;
        double d8 = d7 * d;
        double d9 = d7 * d2;
        double d10 = d7 * d3;
        int n = this.a;
        dArray2[n] = dArray2[n] + d8;
        int n2 = this.a + 1;
        dArray2[n2] = dArray2[n2] + d9;
        int n3 = this.a + 2;
        dArray2[n3] = dArray2[n3] + d10;
        int n4 = this.b;
        dArray2[n4] = dArray2[n4] - d8;
        int n5 = this.b + 1;
        dArray2[n5] = dArray2[n5] - d9;
        int n6 = this.b + 2;
        dArray2[n6] = dArray2[n6] - d10;
        return d6;
    }

    public double eval(double[] dArray) {
        double d = dArray[this.a] - dArray[this.b];
        double d2 = dArray[this.a + 1] - dArray[this.b + 1];
        double d3 = dArray[this.a + 2] - dArray[this.b + 2];
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d4 < 1.0E-6) {
            d4 = 1.0E-6;
        }
        double d5 = d4 - this.r0;
        return this.k * (d5 * d5);
    }
}

