/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.dezymer;

import chiropraxis.forcefield.BondTerm;
import chiropraxis.forcefield.GradientMinimizer;
import chiropraxis.forcefield.NonbondedTerm;
import chiropraxis.forcefield.StateManager;
import driftwood.data.UberMap;
import driftwood.r3.MutableTuple3;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PageSpacer {
    static DecimalFormat df = new DecimalFormat("0.0####");
    List inputFiles = new ArrayList();
    int numTries = 5;
    double repulsion = 1.0;
    double pow = 1.0;
    Page[] pages;
    Collection links;

    void loadLinks(InputStream[] inputStreamArray) throws IOException {
        int n;
        this.links = new ArrayList();
        UberMap uberMap = new UberMap();
        for (n = 0; n < inputStreamArray.length; ++n) {
            String string;
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStreamArray[n]));
            while ((string = lineNumberReader.readLine()) != null) {
                Page page;
                String[] stringArray = Strings.explode(string, ':');
                if (string.length() <= 0 || string.startsWith("#") || stringArray.length < 5) continue;
                Page page2 = (Page)uberMap.get(stringArray[0]);
                if (page2 == null) {
                    page2 = new Page(stringArray[0], uberMap.size());
                    uberMap.put(stringArray[0], page2);
                }
                if ((page = (Page)uberMap.get(stringArray[1])) == null) {
                    page = new Page(stringArray[1], uberMap.size());
                    uberMap.put(stringArray[1], page);
                }
                try {
                    Link link = new Link();
                    link.from = page2;
                    link.to = page;
                    link.total_hits = Integer.parseInt(stringArray[2]);
                    link.frac_sess = Double.parseDouble(stringArray[3]);
                    link.avg_time = Double.parseDouble(stringArray[4]);
                    this.links.add(link);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException.getMessage());
                }
            }
        }
        this.pages = uberMap.values().toArray(new Page[uberMap.size()]);
        for (n = 0; n < this.pages.length; ++n) {
            if (this.pages[n].index == n) continue;
            System.err.println("Page indexes are wrong!");
        }
    }

    StateManager createRestraints() {
        Object object2;
        StateManager stateManager = new StateManager(this.pages, this.pages.length);
        ArrayList<BondTerm> arrayList = new ArrayList<BondTerm>();
        for (Object object2 : this.links) {
            arrayList.add(new BondTerm(((Link)object2).from.index, ((Link)object2).to.index, this.scaleTime(((Link)object2).avg_time), 1.0));
        }
        stateManager.setBondTerms(arrayList);
        Object object3 = new int[this.pages.length];
        object2 = new NonbondedTerm((int[])object3, 600.0, this.pages.length);
        ((NonbondedTerm)object2).setQ(0, 0, this.repulsion);
        stateManager.setNbTerms(Collections.singleton(object2));
        return stateManager;
    }

    double scaleTime(double d) {
        return Math.log(Math.max(1.0, d));
    }

    double findLowestEnergy(StateManager stateManager) {
        int n;
        DecimalFormat decimalFormat = new DecimalFormat("0.0000E0");
        double d = Double.POSITIVE_INFINITY;
        MutableTuple3[] mutableTuple3Array = new Triple[this.pages.length];
        for (n = 0; n < mutableTuple3Array.length; ++n) {
            mutableTuple3Array[n] = new Triple();
        }
        for (n = 0; n < this.numTries; ++n) {
            this.randomizePositions(this.pages, 10.0);
            stateManager.setState();
            GradientMinimizer gradientMinimizer = new GradientMinimizer(stateManager);
            long l = System.currentTimeMillis();
            for (int i = 1; i <= 100 && gradientMinimizer.step() && !(gradientMinimizer.getFracDeltaEnergy() > -1.0E-4); ++i) {
            }
            l = System.currentTimeMillis() - l;
            System.err.println(l + " ms; E = " + decimalFormat.format(gradientMinimizer.getEnergy()));
            if (!(gradientMinimizer.getEnergy() < d)) continue;
            d = gradientMinimizer.getEnergy();
            stateManager.getState(mutableTuple3Array);
        }
        stateManager.setState(mutableTuple3Array);
        stateManager.getState();
        System.err.println();
        System.err.println("Best energy:  " + decimalFormat.format(d));
        return d;
    }

    void randomizePositions(Page[] pageArray, double d) {
        for (int i = 0; i < pageArray.length; ++i) {
            pageArray[i].setX(Math.random() * d);
            pageArray[i].setY(Math.random() * d);
            pageArray[i].setZ(Math.random() * d);
        }
    }

    void plotPages(Page[] pageArray, PrintStream printStream) {
        int n;
        printStream.println("@subgroup {pages}");
        printStream.println("@balllist {balls} radius= 1.0 color= sea off");
        for (n = 0; n < pageArray.length; ++n) {
            printStream.println("{" + pageArray[n] + "} " + pageArray[n].format(df));
        }
        printStream.println("@labellist {labels} color= sea");
        for (n = 0; n < pageArray.length; ++n) {
            printStream.println("{" + pageArray[n] + "} " + pageArray[n].format(df));
        }
    }

    void plotLinks(Collection collection, PrintStream printStream) {
        Object object2;
        double d = 0.0;
        for (Object object2 : collection) {
            d = Math.max(d, (double)((Link)object2).total_hits);
        }
        String[] stringArray = new String[]{"blue", "sky", "bluetint", "white", "peachtint", "peach", "orange"};
        object2 = new Triple();
        Triple triple = new Triple();
        Triple triple2 = new Triple();
        printStream.println("@subgroup {links}");
        printStream.println("@arrowlist {arrows}");
        for (Link link : collection) {
            int n;
            if (link.from == link.to) continue;
            int n2 = (int)Math.ceil(7.0 * (double)link.total_hits / d);
            if (n2 > 7) {
                n2 = 7;
            }
            if ((n = (int)Math.floor((double)stringArray.length * link.frac_sess)) == stringArray.length) {
                --n;
            }
            ((Triple)object2).likeVector(link.from, link.to);
            triple.likeOrthogonal((Tuple3)object2);
            triple.mult(0.03 * ((Triple)object2).mag());
            if (link.from.toString().compareTo(link.to.toString()) < 0) {
                triple.neg();
            }
            triple2.likeMidpoint(link.from, link.to);
            triple2.add(triple);
            printStream.print("{" + link.from + "}P " + link.from.format(df));
            printStream.println(" {x}L width" + n2 + " " + stringArray[n] + " " + triple2.format(df));
            printStream.println(" {" + link.to + "}L width" + n2 + " " + stringArray[n] + " " + link.to.format(df));
        }
        printStream.println("@labellist {hits} color= greentint off");
        for (Link link : collection) {
            if (link.from == link.to) continue;
            ((Triple)object2).likeVector(link.from, link.to);
            triple.likeOrthogonal((Tuple3)object2);
            triple.mult(0.06 * ((Triple)object2).mag());
            if (link.from.toString().compareTo(link.to.toString()) < 0) {
                triple.neg();
            }
            triple2.likeMidpoint(link.from, link.to);
            triple2.add(triple);
            printStream.println("{" + link.total_hits + "} " + triple2.format(df));
        }
        printStream.println("@labellist {% users} color= greentint off");
        for (Link link : collection) {
            if (link.from == link.to) continue;
            ((Triple)object2).likeVector(link.from, link.to);
            triple.likeOrthogonal((Tuple3)object2);
            triple.mult(0.06 * ((Triple)object2).mag());
            if (link.from.toString().compareTo(link.to.toString()) < 0) {
                triple.neg();
            }
            triple2.likeMidpoint(link.from, link.to);
            triple2.add(triple);
            printStream.println("{" + df.format(100.0 * link.frac_sess) + "%} " + triple2.format(df));
        }
        printStream.println("@labellist {avg. time} color= greentint off");
        for (Link link : collection) {
            if (link.from == link.to) continue;
            ((Triple)object2).likeVector(link.from, link.to);
            triple.likeOrthogonal((Tuple3)object2);
            triple.mult(0.06 * ((Triple)object2).mag());
            if (link.from.toString().compareTo(link.to.toString()) < 0) {
                triple.neg();
            }
            triple2.likeMidpoint(link.from, link.to);
            triple2.add(triple);
            printStream.println("{" + df.format(link.avg_time) + " sec} " + triple2.format(df));
        }
    }

    public void Main() throws IOException {
        InputStream[] inputStreamArray;
        if (this.inputFiles.isEmpty()) {
            this.loadLinks(new InputStream[]{System.in});
        } else {
            inputStreamArray = new InputStream[this.inputFiles.size()];
            for (int i = 0; i < inputStreamArray.length; ++i) {
                inputStreamArray[i] = new FileInputStream((File)this.inputFiles.get(i));
            }
            this.loadLinks(inputStreamArray);
        }
        inputStreamArray = this.createRestraints();
        double d = this.findLowestEnergy((StateManager)inputStreamArray);
        System.out.println("@kinemage");
        System.out.println("@perspective");
        System.out.println("@onewidth");
        this.plotPages(this.pages, System.out);
        this.plotLinks(this.links, System.out);
    }

    public static void main(String[] stringArray) {
        PageSpacer pageSpacer = new PageSpacer();
        try {
            pageSpacer.parseArguments(stringArray);
            pageSpacer.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            pageSpacer.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println();
            System.err.println("*** I/O error: " + iOException.getMessage());
            System.exit(2);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("PageSpacer.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'PageSpacer.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.minimize.PageSpacer");
        System.err.println("Copyright (C) 2003 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        this.inputFiles.add(new File(string));
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-tries")) {
            try {
                this.numTries = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equals("-power")) {
            try {
                this.pow = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equals("-repulsion")) {
            try {
                this.repulsion = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }

    static class Link {
        Page from;
        Page to;
        int total_hits;
        double frac_sess;
        double avg_time;
    }

    static class Page
    extends Triple {
        final String name;
        final int index;

        public Page(String string, int n) {
            this.name = string;
            this.index = n;
        }

        public String toString() {
            return this.name;
        }
    }
}

