/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.ClassUsageMarker;

public class InnerUsageMarker
implements AttributeVisitor,
InnerClassesInfoVisitor,
ConstantVisitor,
ClassVisitor {
    private final ClassUsageMarker classUsageMarker;
    private boolean attributeUsed;
    private boolean classUsed;

    public InnerUsageMarker(ClassUsageMarker classUsageMarker) {
        this.classUsageMarker = classUsageMarker;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        this.attributeUsed = false;
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
        if (this.attributeUsed) {
            this.classUsageMarker.markAsUsed(innerClassesAttribute);
            this.markConstant(clazz, innerClassesAttribute.u2attributeNameIndex);
        }
    }

    @Override
    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        boolean innerClassesInfoUsed = this.classUsageMarker.isUsed(innerClassesInfo);
        if (!innerClassesInfoUsed) {
            this.classUsed = true;
            innerClassesInfo.innerClassConstantAccept(clazz, this);
            innerClassesInfoUsed = this.classUsed;
            this.classUsed = true;
            innerClassesInfo.outerClassConstantAccept(clazz, this);
            if (innerClassesInfoUsed &= this.classUsed) {
                this.classUsageMarker.markAsUsed(innerClassesInfo);
                innerClassesInfo.innerNameConstantAccept(clazz, this);
            }
        }
        this.attributeUsed |= innerClassesInfoUsed;
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.classUsed = this.classUsageMarker.isUsed(classConstant);
        if (!this.classUsed) {
            this.classUsed = true;
            classConstant.referencedClassAccept(this);
            if (this.classUsed) {
                this.classUsageMarker.markAsUsed(classConstant);
                this.markConstant(clazz, classConstant.u2nameIndex);
            }
        }
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.classUsageMarker.markAsUsed(utf8Constant);
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.classUsed = this.classUsageMarker.isUsed(programClass);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        this.classUsed = true;
    }

    private void markConstant(Clazz clazz, int index) {
        clazz.constantPoolEntryAccept(index, this);
    }
}

