/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.optimize.gson._OptimizedTypeAdapter;

public final class _GsonUtil {
    private static final Logger logger = LogManager.getLogger(_GsonUtil.class);

    public static TypeAdapter getTypeAdapter(Gson gson, Class declaredType, Object value) {
        TypeAdapter declaredTypeAdapter;
        Type runtimeType = _GsonUtil.getRuntimeTypeIfMoreSpecific(declaredType, value);
        TypeAdapter<?> runtimeTypeAdapter = gson.getAdapter(TypeToken.get(runtimeType));
        if (declaredType != runtimeType && !_GsonUtil.isCustomTypeAdapter(runtimeTypeAdapter) && _GsonUtil.isCustomTypeAdapter(declaredTypeAdapter = gson.getAdapter(declaredType))) {
            return declaredTypeAdapter;
        }
        return runtimeTypeAdapter;
    }

    public static TypeAdapter getTypeAdapter(Gson gson, TypeToken declaredTypeToken, Object value) {
        TypeAdapter declaredTypeAdapter;
        Type declaredType = declaredTypeToken.getType();
        Type runtimeType = _GsonUtil.getRuntimeTypeIfMoreSpecific(declaredType, value);
        TypeAdapter<?> runtimeTypeAdapter = gson.getAdapter(TypeToken.get(runtimeType));
        if (declaredType != runtimeType && !_GsonUtil.isCustomTypeAdapter(runtimeTypeAdapter) && _GsonUtil.isCustomTypeAdapter(declaredTypeAdapter = gson.getAdapter(declaredTypeToken))) {
            return declaredTypeAdapter;
        }
        return runtimeTypeAdapter;
    }

    private static Type getRuntimeTypeIfMoreSpecific(Type type, Object value) {
        if (value != null && (type == Object.class || type instanceof TypeVariable || type instanceof Class)) {
            type = value.getClass();
        }
        return type;
    }

    private static boolean isCustomTypeAdapter(TypeAdapter declaredTypeAdapter) {
        return !(declaredTypeAdapter instanceof _OptimizedTypeAdapter) && !(declaredTypeAdapter instanceof ReflectiveTypeAdapterFactory.Adapter);
    }

    public static void dumpTypeTokenCache(String message, Map<TypeToken<?>, TypeAdapter<?>> typeTokenCache) {
        logger.info(message);
        for (Map.Entry<TypeToken<?>, TypeAdapter<?>> typeTokenCacheEntry : typeTokenCache.entrySet()) {
            logger.info("    {} -> {}", (Object)typeTokenCacheEntry.getKey(), (Object)typeTokenCacheEntry.getValue());
        }
    }
}

