/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.MemberToClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.classfile.visitor.ReferencedMemberVisitor;

public class CalledMemberVisitor
implements InstructionVisitor {
    private final MemberVisitor memberVisitor;
    private final MemberToClassVisitor staticClassInitializer;

    public CalledMemberVisitor(MemberVisitor memberVisitor) {
        this.memberVisitor = memberVisitor;
        this.staticClassInitializer = new MemberToClassVisitor(new NamedMethodVisitor("<clinit>", null, memberVisitor));
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -74: 
            case -73: 
            case -72: 
            case -71: 
            case -70: {
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, new ReferencedMemberVisitor(new MultiMemberVisitor(this.memberVisitor, this.staticClassInitializer)));
                break;
            }
            case -78: 
            case -77: {
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, new ReferencedMemberVisitor(this.staticClassInitializer));
            }
        }
    }
}

