/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.ConstructorMethodFilter;
import proguard.classfile.visitor.InitializerMethodFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberProcessingFlagFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.ProgramClassFilter;
import proguard.configuration.InitialStateInfo;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryWriter;

public class ClassMapDataEntryReplacer
implements DataEntryReader {
    private final ClassPool programClassPool;
    private final InitialStateInfo initialStateInfo;
    private final DataEntryWriter dataEntryWriter;
    private DataOutputStream dataOutputStream;

    public ClassMapDataEntryReplacer(ClassPool programClassPool, InitialStateInfo initialStateInfo, DataEntryWriter dataEntryWriter) {
        this.programClassPool = programClassPool;
        this.initialStateInfo = initialStateInfo;
        this.dataEntryWriter = dataEntryWriter;
    }

    @Override
    public void read(DataEntry dataEntry) throws IOException {
        OutputStream outputStream = this.dataEntryWriter.createOutputStream(dataEntry);
        if (outputStream != null) {
            this.dataOutputStream = new DataOutputStream(outputStream);
            try {
                this.dataOutputStream.writeInt(this.initialStateInfo.size());
                this.writeClassMap();
            }
            finally {
                this.dataOutputStream.close();
            }
        }
    }

    private void writeClassMap() throws IOException {
        for (String className : this.initialStateInfo.classNames()) {
            ProgramClass clazz = (ProgramClass)this.programClassPool.getClass(className);
            this.dataOutputStream.writeUTF(ClassUtil.externalClassName(className));
            if (clazz == null) {
                this.dataOutputStream.writeUTF(ClassUtil.externalClassName(className));
                this.dataOutputStream.writeUTF(ClassUtil.externalClassName(this.initialStateInfo.getSuperClassName(className)));
                this.dataOutputStream.writeShort(128);
                this.writeMembers(this.initialStateInfo.getFieldHashMap(className), Collections.emptyList());
                this.writeMembers(this.initialStateInfo.getMethodHashMap(className), Collections.emptyList());
                continue;
            }
            this.dataOutputStream.writeUTF(ClassUtil.externalClassName(clazz.getName()));
            this.dataOutputStream.writeUTF(ClassUtil.externalClassName(clazz.getSuperName()));
            this.dataOutputStream.writeShort((ClassMapDataEntryReplacer.isKept(clazz.processingFlags) ? 1 : 0) | (ClassMapDataEntryReplacer.allDeclaredFieldsKept(clazz) ? 8 : 0) | (ClassMapDataEntryReplacer.allPublicFieldsKept(clazz) ? 16 : 0) | (ClassMapDataEntryReplacer.allDeclaredConstructorsKept(clazz) ? 2 : 0) | (ClassMapDataEntryReplacer.allPublicConstructorsKept(clazz) ? 4 : 0) | (ClassMapDataEntryReplacer.allDeclaredMethodsKept(clazz) ? 32 : 0) | (ClassMapDataEntryReplacer.allPublicMethodsKept(clazz) ? 64 : 0));
            this.writeMembers(this.initialStateInfo.getFieldHashMap(className), Arrays.asList(clazz.fields));
            this.writeMembers(this.initialStateInfo.getMethodHashMap(className), Arrays.asList(clazz.methods));
        }
    }

    private <T extends Member> void writeMembers(Map<T, Integer> originalMemberHashes, Collection<T> currentMembers) throws IOException {
        this.dataOutputStream.writeShort(originalMemberHashes.size());
        for (Map.Entry<T, Integer> entry : originalMemberHashes.entrySet()) {
            this.dataOutputStream.writeInt(entry.getValue());
            this.dataOutputStream.writeByte((currentMembers.contains(entry.getKey()) ? 0 : 2) | (ClassMapDataEntryReplacer.isKept(((Member)entry.getKey()).getProcessingFlags()) ? 1 : 0));
        }
    }

    static boolean isKept(int processingFlags) {
        return (processingFlags & 0x400000) != 0 && (processingFlags & 0x100000) != 0;
    }

    private static boolean allDeclaredFieldsKept(Clazz clazz) {
        if ((clazz.getProcessingFlags() & 4) != 0) {
            return false;
        }
        MemberCounter unkeptCounter = new MemberCounter();
        clazz.fieldsAccept(new MemberProcessingFlagFilter(0, 512, new MemberProcessingFlagFilter(0x500000, 0, null, unkeptCounter)));
        return unkeptCounter.getCount() == 0;
    }

    private static boolean allPublicFieldsKept(Clazz clazz) {
        ClassCounter removedCounter = new ClassCounter();
        MemberCounter unkeptCounter = new MemberCounter();
        clazz.hierarchyAccept(true, true, false, false, new ProgramClassFilter(new MultiClassVisitor(new ClassProcessingFlagFilter(8, 0, removedCounter), new AllFieldVisitor(new MemberAccessFilter(1, 0, new MemberProcessingFlagFilter(0, 512, new MemberProcessingFlagFilter(0x500000, 0, null, unkeptCounter)))))));
        return removedCounter.getCount() == 0 && unkeptCounter.getCount() == 0;
    }

    private static boolean allDeclaredConstructorsKept(Clazz clazz) {
        if ((clazz.getProcessingFlags() & 0x10) != 0) {
            return false;
        }
        MemberCounter unkeptCounter = new MemberCounter();
        clazz.methodsAccept(new ConstructorMethodFilter(new MemberProcessingFlagFilter(0, 512, new MemberProcessingFlagFilter(0x500000, 0, null, unkeptCounter))));
        return unkeptCounter.getCount() == 0;
    }

    private static boolean allPublicConstructorsKept(Clazz clazz) {
        if ((clazz.getProcessingFlags() & 0x20) != 0) {
            return false;
        }
        MemberCounter unkeptCounter = new MemberCounter();
        clazz.hierarchyAccept(true, true, false, false, new ProgramClassFilter(new AllMethodVisitor(new ConstructorMethodFilter(new MemberAccessFilter(1, 0, new MemberProcessingFlagFilter(0, 512, new MemberProcessingFlagFilter(0x500000, 0, null, unkeptCounter)))))));
        return unkeptCounter.getCount() == 0;
    }

    private static boolean allDeclaredMethodsKept(Clazz clazz) {
        if ((clazz.getProcessingFlags() & 0x40) != 0) {
            return false;
        }
        MemberCounter unkeptCounter = new MemberCounter();
        clazz.methodsAccept(new InitializerMethodFilter(null, new MemberProcessingFlagFilter(0, 512, new MemberProcessingFlagFilter(0x500000, 0, null, unkeptCounter))));
        return unkeptCounter.getCount() == 0;
    }

    private static boolean allPublicMethodsKept(Clazz clazz) {
        ClassCounter removedCounter = new ClassCounter();
        MemberCounter unkeptCounter = new MemberCounter();
        clazz.hierarchyAccept(true, true, false, false, new ProgramClassFilter(new MultiClassVisitor(new ClassProcessingFlagFilter(128, 0, removedCounter), new AllMethodVisitor(new InitializerMethodFilter(null, new MemberAccessFilter(1, 0, new MemberProcessingFlagFilter(0, 512, new MemberProcessingFlagFilter(0x500000, 0, null, unkeptCounter))))))));
        return removedCounter.getCount() == 0 && unkeptCounter.getCount() == 0;
    }
}

