/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.ComparableConstant;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.visitor.ClassVisitor;

public class ConstantPoolSorter
implements ClassVisitor {
    private int[] constantIndexMap = new int[256];
    private ComparableConstant[] comparableConstantPool = new ComparableConstant[256];
    private Constant[] newConstantPool = new Constant[256];
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        int constantPoolCount = programClass.u2constantPoolCount;
        if (this.constantIndexMap.length < constantPoolCount) {
            this.constantIndexMap = new int[constantPoolCount];
            this.comparableConstantPool = new ComparableConstant[constantPoolCount];
            this.newConstantPool = new Constant[constantPoolCount];
        }
        int sortLength = 0;
        for (int oldIndex = 1; oldIndex < constantPoolCount; ++oldIndex) {
            Constant constant = programClass.constantPool[oldIndex];
            if (constant == null) continue;
            this.comparableConstantPool[sortLength++] = new ComparableConstant(programClass, oldIndex, constant);
        }
        Arrays.sort(this.comparableConstantPool, 0, sortLength);
        int newLength = 1;
        int newIndex = 1;
        ComparableConstant previousComparableConstant = null;
        for (int sortIndex = 0; sortIndex < sortLength; ++sortIndex) {
            ComparableConstant comparableConstant = this.comparableConstantPool[sortIndex];
            if (!comparableConstant.equals(previousComparableConstant)) {
                newIndex = newLength;
                Constant constant = comparableConstant.getConstant();
                this.newConstantPool[newLength++] = constant;
                int tag = constant.getTag();
                if (tag == 5 || tag == 6) {
                    this.newConstantPool[newLength++] = null;
                }
                previousComparableConstant = comparableConstant;
            }
            this.constantIndexMap[comparableConstant.getIndex()] = newIndex;
        }
        System.arraycopy(this.newConstantPool, 0, programClass.constantPool, 0, newLength);
        Arrays.fill(programClass.constantPool, newLength, constantPoolCount, null);
        programClass.u2constantPoolCount = newLength;
        this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
        this.constantPoolRemapper.visitProgramClass(programClass);
    }
}

