/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.subsonic.booter.agent;

import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import net.sourceforge.subsonic.booter.agent.SubsonicAgent;
import net.sourceforge.subsonic.booter.agent.SubsonicListener;
import net.sourceforge.subsonic.booter.deployer.DeploymentStatus;

public class TrayController
implements SubsonicListener {
    private final SubsonicAgent subsonicAgent;
    private TrayIcon trayIcon;
    private Action openAction;
    private Action controlPanelAction;
    private Action hideAction;
    private Image startedImage;
    private Image stoppedImage;

    public TrayController(SubsonicAgent subsonicAgent) {
        this.subsonicAgent = subsonicAgent;
        try {
            this.createActions();
            this.createComponents();
            this.addBehaviour();
            this.installComponents();
            subsonicAgent.addListener(this);
        }
        catch (Throwable x) {
            System.err.println("Disabling tray support.");
        }
    }

    public void showMessage() {
        this.trayIcon.displayMessage("Subsonic", "Subsonic is now running. Click this balloon to get started.", TrayIcon.MessageType.INFO);
    }

    private void createActions() {
        this.openAction = new AbstractAction("Open Subsonic in Browser"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayController.this.subsonicAgent.openBrowser();
            }
        };
        this.controlPanelAction = new AbstractAction("Subsonic Control Panel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayController.this.subsonicAgent.showStatusPanel();
            }
        };
        this.hideAction = new AbstractAction("Hide Tray Icon"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayController.this.subsonicAgent.exit();
            }
        };
    }

    private void createComponents() {
        this.startedImage = this.createImage("/images/subsonic-started-16.png");
        this.stoppedImage = this.createImage("/images/subsonic-stopped-16.png");
        PopupMenu menu = new PopupMenu();
        menu.add(this.createMenuItem(this.openAction));
        menu.add(this.createMenuItem(this.controlPanelAction));
        menu.addSeparator();
        menu.add(this.createMenuItem(this.hideAction));
        this.trayIcon = new TrayIcon(this.stoppedImage, "Subsonic Music Streamer", menu);
    }

    private Image createImage(String resourceName) {
        URL url = this.getClass().getResource(resourceName);
        return Toolkit.getDefaultToolkit().createImage(url);
    }

    private MenuItem createMenuItem(Action action) {
        MenuItem menuItem = new MenuItem((String)action.getValue("Name"));
        menuItem.addActionListener(action);
        return menuItem;
    }

    private void addBehaviour() {
        this.trayIcon.addActionListener(this.controlPanelAction);
    }

    private void installComponents() throws Throwable {
        SystemTray.getSystemTray().add(this.trayIcon);
    }

    public void uninstallComponents() {
        try {
            SystemTray.getSystemTray().remove(this.trayIcon);
        }
        catch (Throwable x) {
            System.err.println("Disabling tray support.");
        }
    }

    private void setTrayImage(Image image) {
        if (this.trayIcon.getImage() != image) {
            this.trayIcon.setImage(image);
        }
    }

    @Override
    public void notifyDeploymentStatus(DeploymentStatus deploymentStatus) {
        this.setTrayImage(deploymentStatus == null ? this.stoppedImage : this.startedImage);
    }

    @Override
    public void notifyServiceStatus(String serviceStatus) {
    }
}

