## RabbitMQ 3.7.20

RabbitMQ `3.7.20` is a maintenance release that focuses on bug fixes.
RabbitMQ `3.7.x` series is supported [through March 2020](https://www.rabbitmq.com/versions.html).

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**no longer supports Erlang/OTP 20.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Bug Fixes

 * Rolling cluster upgrade could fail if new versions were deployed to all cluster nodes at once instead
   of a rolling upgrade-then-restart for each node individually.

   GitHub issue: [rabbitmq/rabbitmq-server#2132](https://github.com/rabbitmq/rabbitmq-server/issues/2132)

 * Improved error handling in a module that continuously registers the node with [epmd](https://www.rabbitmq.com/clustering.html) avoids
   log noise.

   GitHub issue: [rabbitmq/rabbitmq-server#2130](https://github.com/rabbitmq/rabbitmq-server/issues/2130)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl await_startup` failed with an exception when effective timeout was set to `infinity`.

   GitHub issue: [rabbitmq/rabbitmq-server#2144](https://github.com/rabbitmq/rabbitmq-server/pull/2144)

 * `rabbitmq-diagnostics check_port_connectivity` produced a false positive in an IPv6-only environment.

   Contributed by Gabriele Santomaggio.

   GitHub issue: [rabbitmq/rabbitmq-cli#385](https://github.com/rabbitmq/rabbitmq-cli/pull/385)

 * `rabbitmq-diagnostics status`, `rabbitmq-diagnostics cluster_status`, `rabbitmq-diagnostics listeners` now support
   `--formatter=erlang` (raw Erlang data structure output)

   GitHub issue: [rabbitmq/rabbitmq-cli#383](https://github.com/rabbitmq/rabbitmq-cli/issues/383)


### Kubernetes Peer Discovery Plugin

#### Bug Fixes

 * Requests to Kubernetes API endpoints failed with an `nxdomain` (domain name resolution failure)
   in an IPv6-only environment. Now the plugin will configure its HTTP[S] client to use IPv6 if
   the [inetrc file](http://erlang.org/doc/apps/erts/inet_cfg.html) tells it to.
   See [Using IPv6 for Inter-node Communication (and CLI Tools)](https://www.rabbitmq.com/networking.html#distribution-ipv6) to learn more.

   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-k8s#55](https://github.com/rabbitmq/rabbitmq-peer-discovery-k8s/issues/55)

### AWS Peer Discovery Plugin

#### Bug Fixes

 * The plugin will now configure its HTTP[S] client to use IPv6 if
   the [inetrc file](http://erlang.org/doc/apps/erts/inet_cfg.html) tells it to.
   See [Using IPv6 for Inter-node Communication (and CLI Tools)](https://www.rabbitmq.com/networking.html#distribution-ipv6) to learn more.

   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-aws#32](https://github.com/rabbitmq/rabbitmq-peer-discovery-aws/pull/32)


### Consul Peer Discovery Plugin

#### Enhancements

 * It is now possible to specify service metadata values:

   ``` ini
   cluster_formation.consul.svc_meta.key1 = value1
   cluster_formation.consul.svc_meta.key2 = value2
   ```

   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-consul#34](https://github.com/rabbitmq/rabbitmq-peer-discovery-consul/issues/34)

#### Bug Fixes

 * The plugin will now configure its HTTP[S] client to use IPv6 if
   the [inetrc file](http://erlang.org/doc/apps/erts/inet_cfg.html) tells it to.
   See [Using IPv6 for Inter-node Communication (and CLI Tools)](https://www.rabbitmq.com/networking.html#distribution-ipv6) to learn more.

   GitHub issue: [rabbitmq-peer-discovery-consul#36](https://github.com/rabbitmq/rabbitmq-peer-discovery-consul/pull/36)



### etcd Peer Discovery Plugin

#### Bug Fixes

 * The plugin will now configure its HTTP[S] client to use IPv6 if
   the [inetrc file](http://erlang.org/doc/apps/erts/inet_cfg.html) tells it to.
   See [Using IPv6 for Inter-node Communication (and CLI Tools)](https://www.rabbitmq.com/networking.html#distribution-ipv6) to learn more.

   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-etcd#19](https://github.com/rabbitmq/rabbitmq-peer-discovery-etcd/pull/19)



### Erlang Client

#### Bug Fixes

 * Connection could not be restarted after a heartbeat timeout due to strict pattern matching.

   Contributed by Giuseppe D'Anna (@larrywax).

   GitHub issue: [rabbitmq/rabbitmq-erlang-client#126](https://github.com/rabbitmq/rabbitmq-erlang-client/pull/126)


### LDAP Plugin

#### Enhancements

 * The plugin will no log a warning when DN lookup settings are incomplete.

   GitHub issue: [rabbitmq/rabbitmq-auth-backend-ldap#114](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/pull/114)


### Tracing Plugin

#### Bug Fixes

 * On Windows, deleting the file used by an active (running) trace resulted in an `EACCES` exception.

   GitHub issue: [rabbitmq/rabbitmq-tracing#31](https://github.com/rabbitmq/rabbitmq-tracing/issues/31)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.20.tar.xz`.
