// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudIamOrganizationInvitation OrganizationInvitation represents an organization invitation
//
// swagger:model hashicorp.cloud.iam.OrganizationInvitation
type HashicorpCloudIamOrganizationInvitation struct {

	// AcceptedAt is when the invitation was accepted, resulting in the invitee
	// being added to the organization. This value can be null, which marks
	// an invitation record as being still pending.
	// Format: date-time
	AcceptedAt strfmt.DateTime `json:"accepted_at,omitempty"`

	// CreatedAt is when the record was inserted, that is when the invitation was
	// created and sent.
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// Id is the ID of the current invitation
	ID string `json:"id,omitempty"`

	// InviteeEmail is the email address that is used as target of the invitation.
	InviteeEmail string `json:"invitee_email,omitempty"`

	// InviterUserPrincipalId the UUID of the user principal who is inviting
	// another person into the organization.
	InviterUserPrincipalID string `json:"inviter_user_principal_id,omitempty"`

	// OrganizationId is a reference to the organization that this invitation is for.
	OrganizationID string `json:"organization_id,omitempty"`

	// role is the globally unique identifier that corresponds to the "id" column
	// in cloud-resource-manager roles table.
	// For now, this field can only have the values "roles/admin", "roles/viewer",
	// "roles/contributor".
	Role string `json:"role,omitempty"`

	// state is the current state of the organization invitation. For information on what each
	// state means, see the state enum.
	State *HashicorpCloudIamOrganizationInvitationState `json:"state,omitempty"`
}

// Validate validates this hashicorp cloud iam organization invitation
func (m *HashicorpCloudIamOrganizationInvitation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAcceptedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamOrganizationInvitation) validateAcceptedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.AcceptedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("accepted_at", "body", "date-time", m.AcceptedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudIamOrganizationInvitation) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudIamOrganizationInvitation) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud iam organization invitation based on the context it is used
func (m *HashicorpCloudIamOrganizationInvitation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamOrganizationInvitation) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {

		if swag.IsZero(m.State) { // not required
			return nil
		}

		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudIamOrganizationInvitation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudIamOrganizationInvitation) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudIamOrganizationInvitation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
