/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import React, { type ElementType, type ReactNode } from 'react';
import { type Space } from '../xcss/style-maps.partial';
import type { AlignBlock, AlignInline, BasePrimitiveProps, Grow, Spread } from './types';
export type InlineProps<T extends ElementType = 'div'> = {
    /**
     * The DOM element to render as the Inline. Defaults to `div`.
     */
    as?: 'div' | 'span' | 'ul' | 'ol' | 'li' | 'dl';
    /**
     * Used to align children along the block axis (typically vertical).
     */
    alignBlock?: AlignBlock;
    /**
     * Used to align children along the inline axis (typically horizontal).
     */
    alignInline?: AlignInline;
    /**
     * Used to set whether children are forced onto one line or will wrap onto multiple lines.
     */
    shouldWrap?: boolean;
    /**
     * Used to distribute the children along the main axis.
     */
    spread?: Spread;
    /**
     * Used to set whether the container should grow to fill the available space.
     */
    grow?: Grow;
    /**
     * Represents the space between each child.
     */
    space?: Space;
    /**
     * Represents the space between rows when content wraps.
     * Used to override the `space` value in between rows.
     */
    rowSpace?: Space;
    /**
     * Renders a separator string between each child. Avoid using `separator="•"` when `as="ul" | "ol" | "dl"` to preserve proper list semantics.
     */
    separator?: React.ReactNode;
    /**
     * Elements to be rendered inside the Inline.
     */
    children: ReactNode;
    /**
     * Forwarded ref element.
     */
    ref?: React.ComponentPropsWithRef<T>['ref'];
} & BasePrimitiveProps;
/**
 * __Inline__
 *
 * Inline is a primitive component based on CSS Flexbox that manages the horizontal layout of direct children.
 *
 * @example
 * ```tsx
 *  <Inline>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Inline>
 * ```
 *
 */
declare const Inline: React.MemoExoticComponent<React.ForwardRefExoticComponent<Omit<InlineProps<React.ElementType>, "ref"> & React.RefAttributes<any>>>;
export default Inline;
