/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { type ComponentPropsWithoutRef, type ComponentPropsWithRef, type ReactElement, type ReactNode } from 'react';
import { type SVGElements } from '../utils/types';
import { type BackgroundColor, type Space } from '../xcss/style-maps.partial';
import type { BasePrimitiveProps, StyleProp } from './types';
type AllowedElements = Exclude<keyof JSX.IntrinsicElements, SVGElements | 'button' | 'a'>;
type CustomElementType<P = any> = {
    [K in AllowedElements]: P extends JSX.IntrinsicElements[K] ? K : never;
}[AllowedElements];
export type BoxProps<T extends CustomElementType> = Omit<ComponentPropsWithoutRef<T>, 'as' | 'className'> & BasePrimitiveProps & StyleProp & BaseBoxProps<T>;
type BaseBoxProps<T extends CustomElementType> = {
    /**
     * The DOM element to render as the Box.
     * - This cannot be any SVG-related element such as `'svg'`, `'animate', `'circle'`, and many more
     * - This cannot be a `'a'` (use the `Anchor` primitive instead)
     * - This cannot be a `'button'` (use the `Anchor` primitive instead)
     * @default 'div'
     */
    as?: T;
    /**
     * Elements to be rendered inside the Box.
     */
    children?: ReactNode;
    /**
     * Token representing background color with a built-in fallback value.
     */
    backgroundColor?: BackgroundColor;
    /**
     * Tokens representing CSS shorthand for `paddingBlock` and `paddingInline` together.
     *
     * @see paddingBlock
     * @see paddingInline
     */
    padding?: Space;
    /**
     * Tokens representing CSS shorthand `paddingBlock`.
     *
     * @see paddingBlockStart
     * @see paddingBlockEnd
     */
    paddingBlock?: Space;
    /**
     * Tokens representing CSS `paddingBlockStart`.
     */
    paddingBlockStart?: Space;
    /**
     * Tokens representing CSS `paddingBlockEnd`.
     */
    paddingBlockEnd?: Space;
    /**
     * Tokens representing CSS shorthand `paddingInline`.
     *
     * @see paddingInlineStart
     * @see paddingInlineEnd
     */
    paddingInline?: Space;
    /**
     * Tokens representing CSS `paddingInlineStart`.
     */
    paddingInlineStart?: Space;
    /**
     * Tokens representing CSS `paddingInlineEnd`.
     */
    paddingInlineEnd?: Space;
    /**
     * Forwarded ref.
     */
    ref?: ComponentPropsWithRef<T>['ref'];
};
type BoxComponent = <T extends CustomElementType>(props: BoxProps<T>) => ReactElement | null;
/**
 * __Box__
 *
 * A Box is a primitive component that has the design decisions of the Atlassian Design System baked in.
 * Renders a `div` by default.
 *
 * - [Examples](https://atlassian.design/components/primitives/box/examples)
 * - [Code](https://atlassian.design/components/primitives/box/code)
 * - [Usage](https://atlassian.design/components/primitives/box/usage)
 */
export declare const Box: BoxComponent;
export default Box;
