"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useCloseOnEscapePress;
var _react = require("react");
var _bindEventListener = require("bind-event-listener");
var _platformFeatureFlags = require("@atlaskit/platform-feature-flags");
var _keycodes = require("../utils/keycodes");
/**
 * @deprecated Please use useCloseOnEscapePress from '@atlaskit/layering' instead.
 * Calls back when the escape key is pressed.
 * To be used exclusively for closing layered components.
 * Use the `isDisabled` argument to ignore closing events.
 *
 * ```js
 * useCloseOnEscapePress({
 *   onClose: () => {},
 *   isDisabled: false,
 * });
 * ```
 */
function useCloseOnEscapePress(_ref) {
  var onClose = _ref.onClose,
    isDisabled = _ref.isDisabled;
  var escapePressed = (0, _react.useRef)(false);
  var onKeyDown = (0, _react.useCallback)(function (e) {
    if (isDisabled || escapePressed.current || e.key !== _keycodes.ESCAPE) {
      // We're either already handling the key down event or it's not escape.
      // Bail early!
      return;
    }
    escapePressed.current = true;
    onClose(e);
  }, [onClose, isDisabled]);
  var onKeyUp = (0, _react.useCallback)(function () {
    escapePressed.current = false;
  }, []);
  (0, _react.useEffect)(function () {
    // Don't attach document event listeners if the hook is disabled
    if (isDisabled && (0, _platformFeatureFlags.fg)('platform_only_attach_escape_handler_on_view')) {
      return;
    }
    return (0, _bindEventListener.bindAll)(document, [{
      type: 'keydown',
      listener: onKeyDown
    }, {
      type: 'keyup',
      listener: onKeyUp
    }], {
      capture: false
    });
  }, [onKeyDown, onKeyUp, isDisabled]);
}