/* Exceptions */
DEF_HELPER_2(raise_exception, noreturn, env, i32)

/* Floating Point - rounding mode */
DEF_HELPER_FLAGS_2(set_rounding_mode, TCG_CALL_NO_WG, void, env, i32)
DEF_HELPER_FLAGS_2(set_rounding_mode_chkfrm, TCG_CALL_NO_WG, void, env, i32)

/* Floating Point - fused */
DEF_HELPER_FLAGS_4(fmadd_s, TCG_CALL_NO_RWG, i64, env, i64, i64, i64)
DEF_HELPER_FLAGS_4(fmadd_d, TCG_CALL_NO_RWG, i64, env, i64, i64, i64)
DEF_HELPER_FLAGS_4(fmadd_h, TCG_CALL_NO_RWG, i64, env, i64, i64, i64)
DEF_HELPER_FLAGS_4(fmsub_s, TCG_CALL_NO_RWG, i64, env, i64, i64, i64)
DEF_HELPER_FLAGS_4(fmsub_d, TCG_CALL_NO_RWG, i64, env, i64, i64, i64)
DEF_HELPER_FLAGS_4(fmsub_h, TCG_CALL_NO_RWG, i64, env, i64, i64, i64)
DEF_HELPER_FLAGS_4(fnmsub_s, TCG_CALL_NO_RWG, i64, env, i64, i64, i64)
DEF_HELPER_FLAGS_4(fnmsub_d, TCG_CALL_NO_RWG, i64, env, i64, i64, i64)
DEF_HELPER_FLAGS_4(fnmsub_h, TCG_CALL_NO_RWG, i64, env, i64, i64, i64)
DEF_HELPER_FLAGS_4(fnmadd_s, TCG_CALL_NO_RWG, i64, env, i64, i64, i64)
DEF_HELPER_FLAGS_4(fnmadd_d, TCG_CALL_NO_RWG, i64, env, i64, i64, i64)
DEF_HELPER_FLAGS_4(fnmadd_h, TCG_CALL_NO_RWG, i64, env, i64, i64, i64)

/* Floating Point - Single Precision */
DEF_HELPER_FLAGS_3(fadd_s, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fsub_s, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fmul_s, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fdiv_s, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fmin_s, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fmax_s, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_2(fsqrt_s, TCG_CALL_NO_RWG, i64, env, i64)
DEF_HELPER_FLAGS_3(fle_s, TCG_CALL_NO_RWG, tl, env, i64, i64)
DEF_HELPER_FLAGS_3(flt_s, TCG_CALL_NO_RWG, tl, env, i64, i64)
DEF_HELPER_FLAGS_3(feq_s, TCG_CALL_NO_RWG, tl, env, i64, i64)
DEF_HELPER_FLAGS_2(fcvt_w_s, TCG_CALL_NO_RWG, tl, env, i64)
DEF_HELPER_FLAGS_2(fcvt_wu_s, TCG_CALL_NO_RWG, tl, env, i64)
DEF_HELPER_FLAGS_2(fcvt_l_s, TCG_CALL_NO_RWG, tl, env, i64)
DEF_HELPER_FLAGS_2(fcvt_lu_s, TCG_CALL_NO_RWG, tl, env, i64)
DEF_HELPER_FLAGS_2(fcvt_s_w, TCG_CALL_NO_RWG, i64, env, tl)
DEF_HELPER_FLAGS_2(fcvt_s_wu, TCG_CALL_NO_RWG, i64, env, tl)
DEF_HELPER_FLAGS_2(fcvt_s_l, TCG_CALL_NO_RWG, i64, env, tl)
DEF_HELPER_FLAGS_2(fcvt_s_lu, TCG_CALL_NO_RWG, i64, env, tl)
DEF_HELPER_FLAGS_2(fclass_s, TCG_CALL_NO_RWG_SE, tl, env, i64)

/* Floating Point - Double Precision */
DEF_HELPER_FLAGS_3(fadd_d, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fsub_d, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fmul_d, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fdiv_d, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fmin_d, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fmax_d, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_2(fcvt_s_d, TCG_CALL_NO_RWG, i64, env, i64)
DEF_HELPER_FLAGS_2(fcvt_d_s, TCG_CALL_NO_RWG, i64, env, i64)
DEF_HELPER_FLAGS_2(fsqrt_d, TCG_CALL_NO_RWG, i64, env, i64)
DEF_HELPER_FLAGS_3(fle_d, TCG_CALL_NO_RWG, tl, env, i64, i64)
DEF_HELPER_FLAGS_3(flt_d, TCG_CALL_NO_RWG, tl, env, i64, i64)
DEF_HELPER_FLAGS_3(feq_d, TCG_CALL_NO_RWG, tl, env, i64, i64)
DEF_HELPER_FLAGS_2(fcvt_w_d, TCG_CALL_NO_RWG, tl, env, i64)
DEF_HELPER_FLAGS_2(fcvt_wu_d, TCG_CALL_NO_RWG, tl, env, i64)
DEF_HELPER_FLAGS_2(fcvt_l_d, TCG_CALL_NO_RWG, tl, env, i64)
DEF_HELPER_FLAGS_2(fcvt_lu_d, TCG_CALL_NO_RWG, tl, env, i64)
DEF_HELPER_FLAGS_2(fcvt_d_w, TCG_CALL_NO_RWG, i64, env, tl)
DEF_HELPER_FLAGS_2(fcvt_d_wu, TCG_CALL_NO_RWG, i64, env, tl)
DEF_HELPER_FLAGS_2(fcvt_d_l, TCG_CALL_NO_RWG, i64, env, tl)
DEF_HELPER_FLAGS_2(fcvt_d_lu, TCG_CALL_NO_RWG, i64, env, tl)
DEF_HELPER_FLAGS_1(fclass_d, TCG_CALL_NO_RWG_SE, tl, i64)

/* Bitmanip */
DEF_HELPER_FLAGS_2(clmul, TCG_CALL_NO_RWG_SE, tl, tl, tl)
DEF_HELPER_FLAGS_2(clmulr, TCG_CALL_NO_RWG_SE, tl, tl, tl)
DEF_HELPER_FLAGS_1(brev8, TCG_CALL_NO_RWG_SE, tl, tl)
DEF_HELPER_FLAGS_1(unzip, TCG_CALL_NO_RWG_SE, tl, tl)
DEF_HELPER_FLAGS_1(zip, TCG_CALL_NO_RWG_SE, tl, tl)
DEF_HELPER_FLAGS_2(xperm4, TCG_CALL_NO_RWG_SE, tl, tl, tl)
DEF_HELPER_FLAGS_2(xperm8, TCG_CALL_NO_RWG_SE, tl, tl, tl)

/* Floating Point - Half Precision */
DEF_HELPER_FLAGS_3(fadd_h, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fsub_h, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fmul_h, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fdiv_h, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fmin_h, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_3(fmax_h, TCG_CALL_NO_RWG, i64, env, i64, i64)
DEF_HELPER_FLAGS_2(fsqrt_h, TCG_CALL_NO_RWG, i64, env, i64)
DEF_HELPER_FLAGS_3(fle_h, TCG_CALL_NO_RWG, tl, env, i64, i64)
DEF_HELPER_FLAGS_3(flt_h, TCG_CALL_NO_RWG, tl, env, i64, i64)
DEF_HELPER_FLAGS_3(feq_h, TCG_CALL_NO_RWG, tl, env, i64, i64)
DEF_HELPER_FLAGS_2(fcvt_s_h, TCG_CALL_NO_RWG, i64, env, i64)
DEF_HELPER_FLAGS_2(fcvt_h_s, TCG_CALL_NO_RWG, i64, env, i64)
DEF_HELPER_FLAGS_2(fcvt_d_h, TCG_CALL_NO_RWG, i64, env, i64)
DEF_HELPER_FLAGS_2(fcvt_h_d, TCG_CALL_NO_RWG, i64, env, i64)
DEF_HELPER_FLAGS_2(fcvt_w_h, TCG_CALL_NO_RWG, tl, env, i64)
DEF_HELPER_FLAGS_2(fcvt_wu_h, TCG_CALL_NO_RWG, tl, env, i64)
DEF_HELPER_FLAGS_2(fcvt_l_h, TCG_CALL_NO_RWG, tl, env, i64)
DEF_HELPER_FLAGS_2(fcvt_lu_h, TCG_CALL_NO_RWG, tl, env, i64)
DEF_HELPER_FLAGS_2(fcvt_h_w, TCG_CALL_NO_RWG, i64, env, tl)
DEF_HELPER_FLAGS_2(fcvt_h_wu, TCG_CALL_NO_RWG, i64, env, tl)
DEF_HELPER_FLAGS_2(fcvt_h_l, TCG_CALL_NO_RWG, i64, env, tl)
DEF_HELPER_FLAGS_2(fcvt_h_lu, TCG_CALL_NO_RWG, i64, env, tl)
DEF_HELPER_FLAGS_2(fclass_h, TCG_CALL_NO_RWG_SE, tl, env, i64)

/* Cache-block operations */
DEF_HELPER_2(cbo_clean_flush, void, env, tl)
DEF_HELPER_2(cbo_inval, void, env, tl)
DEF_HELPER_2(cbo_zero, void, env, tl)

/* Special functions */
DEF_HELPER_2(csrr, tl, env, int)
DEF_HELPER_3(csrw, void, env, int, tl)
DEF_HELPER_4(csrrw, tl, env, int, tl, tl)
DEF_HELPER_2(csrr_i128, tl, env, int)
DEF_HELPER_4(csrw_i128, void, env, int, tl, tl)
DEF_HELPER_6(csrrw_i128, tl, env, int, tl, tl, tl, tl)
#ifndef CONFIG_USER_ONLY
DEF_HELPER_1(sret, tl, env)
DEF_HELPER_1(mret, tl, env)
DEF_HELPER_1(wfi, void, env)
DEF_HELPER_1(tlb_flush, void, env)
DEF_HELPER_1(tlb_flush_all, void, env)
/* Native Debug */
DEF_HELPER_1(itrigger_match, void, env)
#endif

/* Hypervisor functions */
#ifndef CONFIG_USER_ONLY
DEF_HELPER_1(hyp_tlb_flush, void, env)
DEF_HELPER_1(hyp_gvma_tlb_flush, void, env)
DEF_HELPER_2(hyp_hlvx_hu, tl, env, tl)
DEF_HELPER_2(hyp_hlvx_wu, tl, env, tl)
#endif

/* Vector functions */
DEF_HELPER_3(vsetvl, tl, env, tl, tl)
DEF_HELPER_5(vle8_v, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vle16_v, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vle32_v, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vle64_v, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vle8_v_mask, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vle16_v_mask, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vle32_v_mask, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vle64_v_mask, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vse8_v, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vse16_v, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vse32_v, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vse64_v, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vse8_v_mask, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vse16_v_mask, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vse32_v_mask, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vse64_v_mask, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vlm_v, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vsm_v, void, ptr, ptr, tl, env, i32)
DEF_HELPER_6(vlse8_v, void, ptr, ptr, tl, tl, env, i32)
DEF_HELPER_6(vlse16_v, void, ptr, ptr, tl, tl, env, i32)
DEF_HELPER_6(vlse32_v, void, ptr, ptr, tl, tl, env, i32)
DEF_HELPER_6(vlse64_v, void, ptr, ptr, tl, tl, env, i32)
DEF_HELPER_6(vsse8_v, void, ptr, ptr, tl, tl, env, i32)
DEF_HELPER_6(vsse16_v, void, ptr, ptr, tl, tl, env, i32)
DEF_HELPER_6(vsse32_v, void, ptr, ptr, tl, tl, env, i32)
DEF_HELPER_6(vsse64_v, void, ptr, ptr, tl, tl, env, i32)
DEF_HELPER_6(vlxei8_8_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei8_16_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei8_32_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei8_64_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei16_8_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei16_16_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei16_32_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei16_64_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei32_8_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei32_16_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei32_32_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei32_64_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei64_8_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei64_16_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei64_32_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vlxei64_64_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei8_8_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei8_16_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei8_32_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei8_64_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei16_8_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei16_16_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei16_32_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei16_64_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei32_8_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei32_16_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei32_32_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei32_64_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei64_8_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei64_16_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei64_32_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsxei64_64_v, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_5(vle8ff_v, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vle16ff_v, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vle32ff_v, void, ptr, ptr, tl, env, i32)
DEF_HELPER_5(vle64ff_v, void, ptr, ptr, tl, env, i32)

DEF_HELPER_4(vl1re8_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl1re16_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl1re32_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl1re64_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl2re8_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl2re16_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl2re32_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl2re64_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl4re8_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl4re16_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl4re32_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl4re64_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl8re8_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl8re16_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl8re32_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vl8re64_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vs1r_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vs2r_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vs4r_v, void, ptr, tl, env, i32)
DEF_HELPER_4(vs8r_v, void, ptr, tl, env, i32)

DEF_HELPER_6(vadd_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vadd_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vadd_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vadd_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsub_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsub_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsub_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsub_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vadd_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vadd_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vadd_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vadd_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsub_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsub_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsub_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsub_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vrsub_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vrsub_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vrsub_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vrsub_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_FLAGS_4(vec_rsubs8, TCG_CALL_NO_RWG, void, ptr, ptr, i64, i32)
DEF_HELPER_FLAGS_4(vec_rsubs16, TCG_CALL_NO_RWG, void, ptr, ptr, i64, i32)
DEF_HELPER_FLAGS_4(vec_rsubs32, TCG_CALL_NO_RWG, void, ptr, ptr, i64, i32)
DEF_HELPER_FLAGS_4(vec_rsubs64, TCG_CALL_NO_RWG, void, ptr, ptr, i64, i32)

DEF_HELPER_6(vwaddu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwaddu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwaddu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwsubu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwsubu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwsubu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwadd_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwadd_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwadd_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwsub_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwsub_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwsub_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwaddu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwaddu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwaddu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwsubu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwsubu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwsubu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwadd_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwadd_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwadd_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwsub_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwsub_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwsub_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwaddu_wv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwaddu_wv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwaddu_wv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwsubu_wv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwsubu_wv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwsubu_wv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwadd_wv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwadd_wv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwadd_wv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwsub_wv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwsub_wv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwsub_wv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwaddu_wx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwaddu_wx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwaddu_wx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwsubu_wx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwsubu_wx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwsubu_wx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwadd_wx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwadd_wx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwadd_wx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwsub_wx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwsub_wx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwsub_wx_w, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vadc_vvm_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vadc_vvm_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vadc_vvm_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vadc_vvm_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsbc_vvm_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsbc_vvm_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsbc_vvm_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsbc_vvm_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmadc_vvm_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmadc_vvm_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmadc_vvm_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmadc_vvm_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsbc_vvm_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsbc_vvm_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsbc_vvm_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsbc_vvm_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vadc_vxm_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vadc_vxm_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vadc_vxm_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vadc_vxm_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsbc_vxm_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsbc_vxm_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsbc_vxm_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsbc_vxm_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmadc_vxm_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmadc_vxm_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmadc_vxm_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmadc_vxm_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsbc_vxm_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsbc_vxm_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsbc_vxm_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsbc_vxm_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vand_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vand_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vand_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vand_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vor_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vor_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vor_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vor_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vxor_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vxor_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vxor_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vxor_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vand_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vand_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vand_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vand_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vor_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vor_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vor_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vor_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vxor_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vxor_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vxor_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vxor_vx_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vsll_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsll_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsll_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsll_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsrl_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsrl_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsrl_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsrl_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsra_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsra_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsra_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsra_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsll_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsll_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsll_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsll_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsrl_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsrl_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsrl_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsrl_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsra_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsra_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsra_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsra_vx_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vnsrl_wv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnsrl_wv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnsrl_wv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnsra_wv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnsra_wv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnsra_wv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnsrl_wx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnsrl_wx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnsrl_wx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnsra_wx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnsra_wx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnsra_wx_w, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vmseq_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmseq_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmseq_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmseq_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsne_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsne_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsne_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsne_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsltu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsltu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsltu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsltu_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmslt_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmslt_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmslt_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmslt_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsleu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsleu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsleu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsleu_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsle_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsle_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsle_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmsle_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmseq_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmseq_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmseq_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmseq_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsne_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsne_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsne_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsne_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsltu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsltu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsltu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsltu_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmslt_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmslt_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmslt_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmslt_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsleu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsleu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsleu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsleu_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsle_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsle_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsle_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsle_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsgtu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsgtu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsgtu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsgtu_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsgt_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsgt_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsgt_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmsgt_vx_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vminu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vminu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vminu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vminu_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmin_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmin_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmin_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmin_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmaxu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmaxu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmaxu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmaxu_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmax_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmax_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmax_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmax_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vminu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vminu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vminu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vminu_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmin_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmin_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmin_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmin_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmaxu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmaxu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmaxu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmaxu_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmax_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmax_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmax_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmax_vx_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vmul_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmul_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmul_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmul_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmulh_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmulh_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmulh_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmulh_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmulhu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmulhu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmulhu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmulhu_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmulhsu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmulhsu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmulhsu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmulhsu_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmul_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmul_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmul_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmul_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmulh_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmulh_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmulh_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmulh_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmulhu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmulhu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmulhu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmulhu_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmulhsu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmulhsu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmulhsu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmulhsu_vx_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vdivu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vdivu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vdivu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vdivu_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vdiv_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vdiv_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vdiv_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vdiv_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vremu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vremu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vremu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vremu_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vrem_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vrem_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vrem_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vrem_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vdivu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vdivu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vdivu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vdivu_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vdiv_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vdiv_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vdiv_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vdiv_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vremu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vremu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vremu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vremu_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vrem_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vrem_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vrem_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vrem_vx_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vwmul_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmul_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmul_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmulu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmulu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmulu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmulsu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmulsu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmulsu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmul_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmul_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmul_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmulu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmulu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmulu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmulsu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmulsu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmulsu_vx_w, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vmacc_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmacc_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmacc_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmacc_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnmsac_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnmsac_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnmsac_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnmsac_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmadd_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmadd_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmadd_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmadd_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnmsub_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnmsub_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnmsub_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnmsub_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmacc_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmacc_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmacc_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmacc_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnmsac_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnmsac_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnmsac_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnmsac_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmadd_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmadd_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmadd_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmadd_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnmsub_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnmsub_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnmsub_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnmsub_vx_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vwmaccu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmaccu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmaccu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmacc_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmacc_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmacc_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmaccsu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmaccsu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmaccsu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwmaccu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmaccu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmaccu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmacc_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmacc_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmacc_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmaccsu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmaccsu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmaccsu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmaccus_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmaccus_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vwmaccus_vx_w, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vmerge_vvm_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmerge_vvm_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmerge_vvm_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmerge_vvm_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmerge_vxm_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmerge_vxm_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmerge_vxm_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vmerge_vxm_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_4(vmv_v_v_b, void, ptr, ptr, env, i32)
DEF_HELPER_4(vmv_v_v_h, void, ptr, ptr, env, i32)
DEF_HELPER_4(vmv_v_v_w, void, ptr, ptr, env, i32)
DEF_HELPER_4(vmv_v_v_d, void, ptr, ptr, env, i32)
DEF_HELPER_4(vmv_v_x_b, void, ptr, i64, env, i32)
DEF_HELPER_4(vmv_v_x_h, void, ptr, i64, env, i32)
DEF_HELPER_4(vmv_v_x_w, void, ptr, i64, env, i32)
DEF_HELPER_4(vmv_v_x_d, void, ptr, i64, env, i32)

DEF_HELPER_6(vsaddu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsaddu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsaddu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsaddu_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsadd_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsadd_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsadd_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsadd_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssubu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssubu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssubu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssubu_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssub_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssub_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssub_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssub_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsaddu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsaddu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsaddu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsaddu_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsadd_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsadd_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsadd_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsadd_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssubu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssubu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssubu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssubu_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssub_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssub_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssub_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssub_vx_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vaadd_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vaadd_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vaadd_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vaadd_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vaaddu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vaaddu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vaaddu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vaaddu_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vasub_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vasub_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vasub_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vasub_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vasubu_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vasubu_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vasubu_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vasubu_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vaadd_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vaadd_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vaadd_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vaadd_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vaaddu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vaaddu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vaaddu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vaaddu_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vasub_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vasub_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vasub_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vasub_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vasubu_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vasubu_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vasubu_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vasubu_vx_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vsmul_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsmul_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsmul_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsmul_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vsmul_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsmul_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsmul_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vsmul_vx_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vssrl_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssrl_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssrl_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssrl_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssra_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssra_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssra_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssra_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vssrl_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssrl_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssrl_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssrl_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssra_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssra_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssra_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vssra_vx_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vnclip_wv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnclip_wv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnclip_wv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnclipu_wv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnclipu_wv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnclipu_wv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vnclipu_wx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnclipu_wx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnclipu_wx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnclip_wx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnclip_wx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vnclip_wx_w, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vfadd_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfadd_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfadd_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfsub_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfsub_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfsub_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfadd_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfadd_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfadd_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfsub_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfsub_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfsub_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfrsub_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfrsub_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfrsub_vf_d, void, ptr, ptr, i64, ptr, env, i32)

DEF_HELPER_6(vfwadd_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwadd_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwsub_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwsub_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwadd_wv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwadd_wv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwsub_wv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwsub_wv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwadd_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwadd_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwsub_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwsub_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwadd_wf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwadd_wf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwsub_wf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwsub_wf_w, void, ptr, ptr, i64, ptr, env, i32)

DEF_HELPER_6(vfmul_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmul_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmul_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfdiv_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfdiv_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfdiv_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmul_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmul_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmul_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfdiv_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfdiv_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfdiv_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfrdiv_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfrdiv_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfrdiv_vf_d, void, ptr, ptr, i64, ptr, env, i32)

DEF_HELPER_6(vfwmul_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwmul_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwmul_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwmul_vf_w, void, ptr, ptr, i64, ptr, env, i32)

DEF_HELPER_6(vfmacc_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmacc_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmacc_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfnmacc_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfnmacc_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfnmacc_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmsac_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmsac_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmsac_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfnmsac_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfnmsac_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfnmsac_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmadd_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmadd_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmadd_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfnmadd_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfnmadd_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfnmadd_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmsub_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmsub_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmsub_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfnmsub_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfnmsub_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfnmsub_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmacc_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmacc_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmacc_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfnmacc_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfnmacc_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfnmacc_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmsac_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmsac_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmsac_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfnmsac_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfnmsac_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfnmsac_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmadd_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmadd_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmadd_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfnmadd_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfnmadd_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfnmadd_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmsub_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmsub_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmsub_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfnmsub_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfnmsub_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfnmsub_vf_d, void, ptr, ptr, i64, ptr, env, i32)

DEF_HELPER_6(vfwmacc_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwmacc_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwnmacc_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwnmacc_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwmsac_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwmsac_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwnmsac_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwnmsac_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwmacc_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwmacc_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwnmacc_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwnmacc_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwmsac_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwmsac_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwnmsac_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfwnmsac_vf_w, void, ptr, ptr, i64, ptr, env, i32)

DEF_HELPER_5(vfsqrt_v_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfsqrt_v_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfsqrt_v_d, void, ptr, ptr, ptr, env, i32)

DEF_HELPER_5(vfrsqrt7_v_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfrsqrt7_v_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfrsqrt7_v_d, void, ptr, ptr, ptr, env, i32)

DEF_HELPER_5(vfrec7_v_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfrec7_v_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfrec7_v_d, void, ptr, ptr, ptr, env, i32)

DEF_HELPER_6(vfmin_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmin_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmin_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmax_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmax_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmax_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfmin_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmin_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmin_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmax_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmax_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmax_vf_d, void, ptr, ptr, i64, ptr, env, i32)

DEF_HELPER_6(vfsgnj_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfsgnj_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfsgnj_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfsgnjn_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfsgnjn_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfsgnjn_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfsgnjx_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfsgnjx_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfsgnjx_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfsgnj_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfsgnj_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfsgnj_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfsgnjn_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfsgnjn_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfsgnjn_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfsgnjx_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfsgnjx_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfsgnjx_vf_d, void, ptr, ptr, i64, ptr, env, i32)

DEF_HELPER_6(vmfeq_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmfeq_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmfeq_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmfne_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmfne_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmfne_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmflt_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmflt_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmflt_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmfle_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmfle_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmfle_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmfeq_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfeq_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfeq_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfne_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfne_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfne_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmflt_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmflt_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmflt_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfle_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfle_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfle_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfgt_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfgt_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfgt_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfge_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfge_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vmfge_vf_d, void, ptr, ptr, i64, ptr, env, i32)

DEF_HELPER_5(vfclass_v_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfclass_v_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfclass_v_d, void, ptr, ptr, ptr, env, i32)

DEF_HELPER_6(vfmerge_vfm_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmerge_vfm_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfmerge_vfm_d, void, ptr, ptr, i64, ptr, env, i32)

DEF_HELPER_5(vfcvt_xu_f_v_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfcvt_xu_f_v_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfcvt_xu_f_v_d, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfcvt_x_f_v_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfcvt_x_f_v_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfcvt_x_f_v_d, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfcvt_f_xu_v_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfcvt_f_xu_v_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfcvt_f_xu_v_d, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfcvt_f_x_v_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfcvt_f_x_v_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfcvt_f_x_v_d, void, ptr, ptr, ptr, env, i32)

DEF_HELPER_5(vfwcvt_xu_f_v_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfwcvt_xu_f_v_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfwcvt_x_f_v_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfwcvt_x_f_v_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfwcvt_f_xu_v_b, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfwcvt_f_xu_v_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfwcvt_f_xu_v_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfwcvt_f_x_v_b, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfwcvt_f_x_v_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfwcvt_f_x_v_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfwcvt_f_f_v_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfwcvt_f_f_v_w, void, ptr, ptr, ptr, env, i32)

DEF_HELPER_5(vfncvt_xu_f_w_b, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfncvt_xu_f_w_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfncvt_xu_f_w_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfncvt_x_f_w_b, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfncvt_x_f_w_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfncvt_x_f_w_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfncvt_f_xu_w_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfncvt_f_xu_w_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfncvt_f_x_w_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfncvt_f_x_w_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfncvt_f_f_w_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vfncvt_f_f_w_w, void, ptr, ptr, ptr, env, i32)

DEF_HELPER_6(vredsum_vs_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredsum_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredsum_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredsum_vs_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredmaxu_vs_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredmaxu_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredmaxu_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredmaxu_vs_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredmax_vs_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredmax_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredmax_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredmax_vs_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredminu_vs_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredminu_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredminu_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredminu_vs_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredmin_vs_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredmin_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredmin_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredmin_vs_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredand_vs_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredand_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredand_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredand_vs_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredor_vs_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredor_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredor_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredor_vs_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredxor_vs_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredxor_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredxor_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vredxor_vs_d, void, ptr, ptr, ptr, ptr, env, i32)

DEF_HELPER_6(vwredsumu_vs_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwredsumu_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwredsumu_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwredsum_vs_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwredsum_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vwredsum_vs_w, void, ptr, ptr, ptr, ptr, env, i32)

DEF_HELPER_6(vfredusum_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfredusum_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfredusum_vs_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfredosum_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfredosum_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfredosum_vs_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfredmax_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfredmax_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfredmax_vs_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfredmin_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfredmin_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfredmin_vs_d, void, ptr, ptr, ptr, ptr, env, i32)

DEF_HELPER_6(vfwredusum_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwredusum_vs_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwredosum_vs_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vfwredosum_vs_w, void, ptr, ptr, ptr, ptr, env, i32)

DEF_HELPER_6(vmand_mm, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmnand_mm, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmandn_mm, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmxor_mm, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmor_mm, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmnor_mm, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmorn_mm, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vmxnor_mm, void, ptr, ptr, ptr, ptr, env, i32)

DEF_HELPER_4(vcpop_m, tl, ptr, ptr, env, i32)

DEF_HELPER_4(vfirst_m, tl, ptr, ptr, env, i32)

DEF_HELPER_5(vmsbf_m, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vmsif_m, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vmsof_m, void, ptr, ptr, ptr, env, i32)

DEF_HELPER_5(viota_m_b, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(viota_m_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(viota_m_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(viota_m_d, void, ptr, ptr, ptr, env, i32)

DEF_HELPER_4(vid_v_b, void, ptr, ptr, env, i32)
DEF_HELPER_4(vid_v_h, void, ptr, ptr, env, i32)
DEF_HELPER_4(vid_v_w, void, ptr, ptr, env, i32)
DEF_HELPER_4(vid_v_d, void, ptr, ptr, env, i32)

DEF_HELPER_6(vslideup_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslideup_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslideup_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslideup_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslidedown_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslidedown_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslidedown_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslidedown_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslide1up_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslide1up_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslide1up_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslide1up_vx_d, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslide1down_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslide1down_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslide1down_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vslide1down_vx_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vfslide1up_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfslide1up_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfslide1up_vf_d, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfslide1down_vf_h, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfslide1down_vf_w, void, ptr, ptr, i64, ptr, env, i32)
DEF_HELPER_6(vfslide1down_vf_d, void, ptr, ptr, i64, ptr, env, i32)

DEF_HELPER_6(vrgather_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vrgather_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vrgather_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vrgather_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vrgatherei16_vv_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vrgatherei16_vv_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vrgatherei16_vv_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vrgatherei16_vv_d, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vrgather_vx_b, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vrgather_vx_h, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vrgather_vx_w, void, ptr, ptr, tl, ptr, env, i32)
DEF_HELPER_6(vrgather_vx_d, void, ptr, ptr, tl, ptr, env, i32)

DEF_HELPER_6(vcompress_vm_b, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vcompress_vm_h, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vcompress_vm_w, void, ptr, ptr, ptr, ptr, env, i32)
DEF_HELPER_6(vcompress_vm_d, void, ptr, ptr, ptr, ptr, env, i32)

DEF_HELPER_4(vmvr_v, void, ptr, ptr, env, i32)

DEF_HELPER_5(vzext_vf2_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vzext_vf2_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vzext_vf2_d, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vzext_vf4_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vzext_vf4_d, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vzext_vf8_d, void, ptr, ptr, ptr, env, i32)

DEF_HELPER_5(vsext_vf2_h, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vsext_vf2_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vsext_vf2_d, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vsext_vf4_w, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vsext_vf4_d, void, ptr, ptr, ptr, env, i32)
DEF_HELPER_5(vsext_vf8_d, void, ptr, ptr, ptr, env, i32)

/* 128-bit integer multiplication and division */
DEF_HELPER_5(divu_i128, tl, env, tl, tl, tl, tl)
DEF_HELPER_5(divs_i128, tl, env, tl, tl, tl, tl)
DEF_HELPER_5(remu_i128, tl, env, tl, tl, tl, tl)
DEF_HELPER_5(rems_i128, tl, env, tl, tl, tl, tl)

/* Crypto functions */
DEF_HELPER_FLAGS_3(aes32esmi, TCG_CALL_NO_RWG_SE, tl, tl, tl, tl)
DEF_HELPER_FLAGS_3(aes32esi, TCG_CALL_NO_RWG_SE, tl, tl, tl, tl)
DEF_HELPER_FLAGS_3(aes32dsmi, TCG_CALL_NO_RWG_SE, tl, tl, tl, tl)
DEF_HELPER_FLAGS_3(aes32dsi, TCG_CALL_NO_RWG_SE, tl, tl, tl, tl)

DEF_HELPER_FLAGS_2(aes64esm, TCG_CALL_NO_RWG_SE, tl, tl, tl)
DEF_HELPER_FLAGS_2(aes64es, TCG_CALL_NO_RWG_SE, tl, tl, tl)
DEF_HELPER_FLAGS_2(aes64ds, TCG_CALL_NO_RWG_SE, tl, tl, tl)
DEF_HELPER_FLAGS_2(aes64dsm, TCG_CALL_NO_RWG_SE, tl, tl, tl)
DEF_HELPER_FLAGS_2(aes64ks2, TCG_CALL_NO_RWG_SE, tl, tl, tl)
DEF_HELPER_FLAGS_2(aes64ks1i, TCG_CALL_NO_RWG_SE, tl, tl, tl)
DEF_HELPER_FLAGS_1(aes64im, TCG_CALL_NO_RWG_SE, tl, tl)

DEF_HELPER_FLAGS_3(sm4ed, TCG_CALL_NO_RWG_SE, tl, tl, tl, tl)
DEF_HELPER_FLAGS_3(sm4ks, TCG_CALL_NO_RWG_SE, tl, tl, tl, tl)
