# Copyright (c) HashiCorp, Inc.
# SPDX-License-Identifier: BUSL-1.1

require_relative "../../../base"

require "vagrant/util/template_renderer"

describe "templates/guests/debian/network_static" do
  let(:template) { "guests/debian/network_static" }

  it "renders the template" do
    result = Vagrant::Util::TemplateRenderer.render(template, options: {
      device:  "eth1",
      ip:      "1.1.1.1",
      netmask: "255.255.0.0",
    })
    expect(result).to eq <<-EOH.gsub(/^ {6}/, "")
      #VAGRANT-BEGIN
      # The contents below are automatically generated by Vagrant. Do not modify.
      auto eth1
      iface eth1 inet static
            address 1.1.1.1
            netmask 255.255.0.0
      #VAGRANT-END
    EOH
  end

  it "includes the gateway" do
    result = Vagrant::Util::TemplateRenderer.render(template, options: {
      device:  "eth1",
      ip:      "1.1.1.1",
      netmask: "255.255.0.0",
      gateway: "1.2.3.4",
    })
    expect(result).to eq <<-EOH.gsub(/^ {6}/, "")
      #VAGRANT-BEGIN
      # The contents below are automatically generated by Vagrant. Do not modify.
      auto eth1
      iface eth1 inet static
            address 1.1.1.1
            netmask 255.255.0.0
            gateway 1.2.3.4
      #VAGRANT-END
    EOH
  end
end
