/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Copyright (c) 2018 Uber Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.21.12
// source: jaeger/api/v2/model.proto

package v2

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ValueType int32

const (
	ValueType_STRING  ValueType = 0
	ValueType_BOOL    ValueType = 1
	ValueType_INT64   ValueType = 2
	ValueType_FLOAT64 ValueType = 3
	ValueType_BINARY  ValueType = 4
)

// Enum value maps for ValueType.
var (
	ValueType_name = map[int32]string{
		0: "STRING",
		1: "BOOL",
		2: "INT64",
		3: "FLOAT64",
		4: "BINARY",
	}
	ValueType_value = map[string]int32{
		"STRING":  0,
		"BOOL":    1,
		"INT64":   2,
		"FLOAT64": 3,
		"BINARY":  4,
	}
)

func (x ValueType) Enum() *ValueType {
	p := new(ValueType)
	*p = x
	return p
}

func (x ValueType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ValueType) Descriptor() protoreflect.EnumDescriptor {
	return file_jaeger_api_v2_model_proto_enumTypes[0].Descriptor()
}

func (ValueType) Type() protoreflect.EnumType {
	return &file_jaeger_api_v2_model_proto_enumTypes[0]
}

func (x ValueType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ValueType.Descriptor instead.
func (ValueType) EnumDescriptor() ([]byte, []int) {
	return file_jaeger_api_v2_model_proto_rawDescGZIP(), []int{0}
}

type SpanRefType int32

const (
	SpanRefType_CHILD_OF     SpanRefType = 0
	SpanRefType_FOLLOWS_FROM SpanRefType = 1
)

// Enum value maps for SpanRefType.
var (
	SpanRefType_name = map[int32]string{
		0: "CHILD_OF",
		1: "FOLLOWS_FROM",
	}
	SpanRefType_value = map[string]int32{
		"CHILD_OF":     0,
		"FOLLOWS_FROM": 1,
	}
)

func (x SpanRefType) Enum() *SpanRefType {
	p := new(SpanRefType)
	*p = x
	return p
}

func (x SpanRefType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SpanRefType) Descriptor() protoreflect.EnumDescriptor {
	return file_jaeger_api_v2_model_proto_enumTypes[1].Descriptor()
}

func (SpanRefType) Type() protoreflect.EnumType {
	return &file_jaeger_api_v2_model_proto_enumTypes[1]
}

func (x SpanRefType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SpanRefType.Descriptor instead.
func (SpanRefType) EnumDescriptor() ([]byte, []int) {
	return file_jaeger_api_v2_model_proto_rawDescGZIP(), []int{1}
}

type KeyValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key      string    `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	VType    ValueType `protobuf:"varint,2,opt,name=v_type,json=vType,proto3,enum=jaeger.api_v2.ValueType" json:"v_type,omitempty"`
	VStr     string    `protobuf:"bytes,3,opt,name=v_str,json=vStr,proto3" json:"v_str,omitempty"`
	VBool    bool      `protobuf:"varint,4,opt,name=v_bool,json=vBool,proto3" json:"v_bool,omitempty"`
	VInt64   int64     `protobuf:"varint,5,opt,name=v_int64,json=vInt64,proto3" json:"v_int64,omitempty"`
	VFloat64 float64   `protobuf:"fixed64,6,opt,name=v_float64,json=vFloat64,proto3" json:"v_float64,omitempty"`
	VBinary  []byte    `protobuf:"bytes,7,opt,name=v_binary,json=vBinary,proto3" json:"v_binary,omitempty"`
}

func (x *KeyValue) Reset() {
	*x = KeyValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jaeger_api_v2_model_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyValue) ProtoMessage() {}

func (x *KeyValue) ProtoReflect() protoreflect.Message {
	mi := &file_jaeger_api_v2_model_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyValue.ProtoReflect.Descriptor instead.
func (*KeyValue) Descriptor() ([]byte, []int) {
	return file_jaeger_api_v2_model_proto_rawDescGZIP(), []int{0}
}

func (x *KeyValue) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *KeyValue) GetVType() ValueType {
	if x != nil {
		return x.VType
	}
	return ValueType_STRING
}

func (x *KeyValue) GetVStr() string {
	if x != nil {
		return x.VStr
	}
	return ""
}

func (x *KeyValue) GetVBool() bool {
	if x != nil {
		return x.VBool
	}
	return false
}

func (x *KeyValue) GetVInt64() int64 {
	if x != nil {
		return x.VInt64
	}
	return 0
}

func (x *KeyValue) GetVFloat64() float64 {
	if x != nil {
		return x.VFloat64
	}
	return 0
}

func (x *KeyValue) GetVBinary() []byte {
	if x != nil {
		return x.VBinary
	}
	return nil
}

type Log struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Timestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Fields    []*KeyValue            `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *Log) Reset() {
	*x = Log{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jaeger_api_v2_model_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Log) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Log) ProtoMessage() {}

func (x *Log) ProtoReflect() protoreflect.Message {
	mi := &file_jaeger_api_v2_model_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Log.ProtoReflect.Descriptor instead.
func (*Log) Descriptor() ([]byte, []int) {
	return file_jaeger_api_v2_model_proto_rawDescGZIP(), []int{1}
}

func (x *Log) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *Log) GetFields() []*KeyValue {
	if x != nil {
		return x.Fields
	}
	return nil
}

type SpanRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TraceId []byte      `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	SpanId  []byte      `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	RefType SpanRefType `protobuf:"varint,3,opt,name=ref_type,json=refType,proto3,enum=jaeger.api_v2.SpanRefType" json:"ref_type,omitempty"`
}

func (x *SpanRef) Reset() {
	*x = SpanRef{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jaeger_api_v2_model_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpanRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpanRef) ProtoMessage() {}

func (x *SpanRef) ProtoReflect() protoreflect.Message {
	mi := &file_jaeger_api_v2_model_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpanRef.ProtoReflect.Descriptor instead.
func (*SpanRef) Descriptor() ([]byte, []int) {
	return file_jaeger_api_v2_model_proto_rawDescGZIP(), []int{2}
}

func (x *SpanRef) GetTraceId() []byte {
	if x != nil {
		return x.TraceId
	}
	return nil
}

func (x *SpanRef) GetSpanId() []byte {
	if x != nil {
		return x.SpanId
	}
	return nil
}

func (x *SpanRef) GetRefType() SpanRefType {
	if x != nil {
		return x.RefType
	}
	return SpanRefType_CHILD_OF
}

type Process struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ServiceName string      `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	Tags        []*KeyValue `protobuf:"bytes,2,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (x *Process) Reset() {
	*x = Process{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jaeger_api_v2_model_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Process) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Process) ProtoMessage() {}

func (x *Process) ProtoReflect() protoreflect.Message {
	mi := &file_jaeger_api_v2_model_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Process.ProtoReflect.Descriptor instead.
func (*Process) Descriptor() ([]byte, []int) {
	return file_jaeger_api_v2_model_proto_rawDescGZIP(), []int{3}
}

func (x *Process) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *Process) GetTags() []*KeyValue {
	if x != nil {
		return x.Tags
	}
	return nil
}

type Span struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TraceId       []byte                 `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	SpanId        []byte                 `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	OperationName string                 `protobuf:"bytes,3,opt,name=operation_name,json=operationName,proto3" json:"operation_name,omitempty"`
	References    []*SpanRef             `protobuf:"bytes,4,rep,name=references,proto3" json:"references,omitempty"`
	Flags         uint32                 `protobuf:"varint,5,opt,name=flags,proto3" json:"flags,omitempty"`
	StartTime     *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	Duration      *durationpb.Duration   `protobuf:"bytes,7,opt,name=duration,proto3" json:"duration,omitempty"`
	Tags          []*KeyValue            `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
	Logs          []*Log                 `protobuf:"bytes,9,rep,name=logs,proto3" json:"logs,omitempty"`
	Process       *Process               `protobuf:"bytes,10,opt,name=process,proto3" json:"process,omitempty"`
	ProcessId     string                 `protobuf:"bytes,11,opt,name=process_id,json=processId,proto3" json:"process_id,omitempty"`
	Warnings      []string               `protobuf:"bytes,12,rep,name=warnings,proto3" json:"warnings,omitempty"`
}

func (x *Span) Reset() {
	*x = Span{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jaeger_api_v2_model_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span) ProtoMessage() {}

func (x *Span) ProtoReflect() protoreflect.Message {
	mi := &file_jaeger_api_v2_model_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span.ProtoReflect.Descriptor instead.
func (*Span) Descriptor() ([]byte, []int) {
	return file_jaeger_api_v2_model_proto_rawDescGZIP(), []int{4}
}

func (x *Span) GetTraceId() []byte {
	if x != nil {
		return x.TraceId
	}
	return nil
}

func (x *Span) GetSpanId() []byte {
	if x != nil {
		return x.SpanId
	}
	return nil
}

func (x *Span) GetOperationName() string {
	if x != nil {
		return x.OperationName
	}
	return ""
}

func (x *Span) GetReferences() []*SpanRef {
	if x != nil {
		return x.References
	}
	return nil
}

func (x *Span) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *Span) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Span) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *Span) GetTags() []*KeyValue {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *Span) GetLogs() []*Log {
	if x != nil {
		return x.Logs
	}
	return nil
}

func (x *Span) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *Span) GetProcessId() string {
	if x != nil {
		return x.ProcessId
	}
	return ""
}

func (x *Span) GetWarnings() []string {
	if x != nil {
		return x.Warnings
	}
	return nil
}

type Trace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Spans      []*Span                 `protobuf:"bytes,1,rep,name=spans,proto3" json:"spans,omitempty"`
	ProcessMap []*Trace_ProcessMapping `protobuf:"bytes,2,rep,name=process_map,json=processMap,proto3" json:"process_map,omitempty"`
	Warnings   []string                `protobuf:"bytes,3,rep,name=warnings,proto3" json:"warnings,omitempty"`
}

func (x *Trace) Reset() {
	*x = Trace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jaeger_api_v2_model_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trace) ProtoMessage() {}

func (x *Trace) ProtoReflect() protoreflect.Message {
	mi := &file_jaeger_api_v2_model_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trace.ProtoReflect.Descriptor instead.
func (*Trace) Descriptor() ([]byte, []int) {
	return file_jaeger_api_v2_model_proto_rawDescGZIP(), []int{5}
}

func (x *Trace) GetSpans() []*Span {
	if x != nil {
		return x.Spans
	}
	return nil
}

func (x *Trace) GetProcessMap() []*Trace_ProcessMapping {
	if x != nil {
		return x.ProcessMap
	}
	return nil
}

func (x *Trace) GetWarnings() []string {
	if x != nil {
		return x.Warnings
	}
	return nil
}

// Note that both Span and Batch may contain a Process.
// This is different from the Thrift model which was only used
// for transport, because Proto model is also used by the backend
// as the domain model, where once a batch is received it is split
// into individual spans which are all processed independently,
// and therefore they all need a Process. As far as on-the-wire
// semantics, both Batch and Spans in the same message may contain
// their own instances of Process, with span.Process taking priority
// over batch.Process.
type Batch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Spans   []*Span  `protobuf:"bytes,1,rep,name=spans,proto3" json:"spans,omitempty"`
	Process *Process `protobuf:"bytes,2,opt,name=process,proto3" json:"process,omitempty"`
}

func (x *Batch) Reset() {
	*x = Batch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jaeger_api_v2_model_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Batch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Batch) ProtoMessage() {}

func (x *Batch) ProtoReflect() protoreflect.Message {
	mi := &file_jaeger_api_v2_model_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Batch.ProtoReflect.Descriptor instead.
func (*Batch) Descriptor() ([]byte, []int) {
	return file_jaeger_api_v2_model_proto_rawDescGZIP(), []int{6}
}

func (x *Batch) GetSpans() []*Span {
	if x != nil {
		return x.Spans
	}
	return nil
}

func (x *Batch) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

type DependencyLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Parent    string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	Child     string `protobuf:"bytes,2,opt,name=child,proto3" json:"child,omitempty"`
	CallCount uint64 `protobuf:"varint,3,opt,name=call_count,json=callCount,proto3" json:"call_count,omitempty"`
	Source    string `protobuf:"bytes,4,opt,name=source,proto3" json:"source,omitempty"`
}

func (x *DependencyLink) Reset() {
	*x = DependencyLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jaeger_api_v2_model_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DependencyLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DependencyLink) ProtoMessage() {}

func (x *DependencyLink) ProtoReflect() protoreflect.Message {
	mi := &file_jaeger_api_v2_model_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DependencyLink.ProtoReflect.Descriptor instead.
func (*DependencyLink) Descriptor() ([]byte, []int) {
	return file_jaeger_api_v2_model_proto_rawDescGZIP(), []int{7}
}

func (x *DependencyLink) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *DependencyLink) GetChild() string {
	if x != nil {
		return x.Child
	}
	return ""
}

func (x *DependencyLink) GetCallCount() uint64 {
	if x != nil {
		return x.CallCount
	}
	return 0
}

func (x *DependencyLink) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

type Trace_ProcessMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProcessId string   `protobuf:"bytes,1,opt,name=process_id,json=processId,proto3" json:"process_id,omitempty"`
	Process   *Process `protobuf:"bytes,2,opt,name=process,proto3" json:"process,omitempty"`
}

func (x *Trace_ProcessMapping) Reset() {
	*x = Trace_ProcessMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jaeger_api_v2_model_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trace_ProcessMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trace_ProcessMapping) ProtoMessage() {}

func (x *Trace_ProcessMapping) ProtoReflect() protoreflect.Message {
	mi := &file_jaeger_api_v2_model_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trace_ProcessMapping.ProtoReflect.Descriptor instead.
func (*Trace_ProcessMapping) Descriptor() ([]byte, []int) {
	return file_jaeger_api_v2_model_proto_rawDescGZIP(), []int{5, 0}
}

func (x *Trace_ProcessMapping) GetProcessId() string {
	if x != nil {
		return x.ProcessId
	}
	return ""
}

func (x *Trace_ProcessMapping) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

var File_jaeger_api_v2_model_proto protoreflect.FileDescriptor

var file_jaeger_api_v2_model_proto_rawDesc = []byte{
	0x0a, 0x19, 0x6a, 0x61, 0x65, 0x67, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x32, 0x2f,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0d, 0x6a, 0x61, 0x65,
	0x67, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xca, 0x01, 0x0a, 0x08,
	0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2f, 0x0a, 0x06, 0x76, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x6a, 0x61, 0x65,
	0x67, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x76, 0x54, 0x79, 0x70, 0x65, 0x12, 0x13, 0x0a, 0x05, 0x76,
	0x5f, 0x73, 0x74, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x76, 0x53, 0x74, 0x72,
	0x12, 0x15, 0x0a, 0x06, 0x76, 0x5f, 0x62, 0x6f, 0x6f, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x05, 0x76, 0x42, 0x6f, 0x6f, 0x6c, 0x12, 0x17, 0x0a, 0x07, 0x76, 0x5f, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x76, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x12, 0x1b, 0x0a, 0x09, 0x76, 0x5f, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x36, 0x34, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x08, 0x76, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x36, 0x34, 0x12, 0x19, 0x0a,
	0x08, 0x76, 0x5f, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x07, 0x76, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x22, 0x70, 0x0a, 0x03, 0x4c, 0x6f, 0x67, 0x12,
	0x38, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x2f, 0x0a, 0x06, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6a, 0x61, 0x65, 0x67,
	0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x32, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x22, 0x74, 0x0a, 0x07, 0x53, 0x70,
	0x61, 0x6e, 0x52, 0x65, 0x66, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64,
	0x12, 0x17, 0x0a, 0x07, 0x73, 0x70, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x06, 0x73, 0x70, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x35, 0x0a, 0x08, 0x72, 0x65, 0x66,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x6a, 0x61,
	0x65, 0x67, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e,
	0x52, 0x65, 0x66, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x72, 0x65, 0x66, 0x54, 0x79, 0x70, 0x65,
	0x22, 0x59, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2b,
	0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6a,
	0x61, 0x65, 0x67, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x32, 0x2e, 0x4b, 0x65, 0x79,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x22, 0xe3, 0x03, 0x0a, 0x04,
	0x53, 0x70, 0x61, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x17, 0x0a, 0x07, 0x73, 0x70, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x06, 0x73, 0x70, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x36, 0x0a, 0x0a, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6a, 0x61, 0x65, 0x67, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69,
	0x5f, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x52, 0x65, 0x66, 0x52, 0x0a, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x39, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x2b, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x6a, 0x61, 0x65, 0x67, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x32, 0x2e, 0x4b, 0x65,
	0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x04,
	0x6c, 0x6f, 0x67, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6a, 0x61, 0x65,
	0x67, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x67, 0x52, 0x04,
	0x6c, 0x6f, 0x67, 0x73, 0x12, 0x30, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6a, 0x61, 0x65, 0x67, 0x65, 0x72, 0x2e, 0x61,
	0x70, 0x69, 0x5f, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x07, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67,
	0x73, 0x22, 0xf7, 0x01, 0x0a, 0x05, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x05, 0x73,
	0x70, 0x61, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6a, 0x61, 0x65,
	0x67, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x52,
	0x05, 0x73, 0x70, 0x61, 0x6e, 0x73, 0x12, 0x44, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x6a, 0x61,
	0x65, 0x67, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x63,
	0x65, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x52, 0x0a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x61, 0x70, 0x12, 0x1a, 0x0a, 0x08,
	0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08,
	0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0x61, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6a, 0x61, 0x65,
	0x67, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x22, 0x64, 0x0a, 0x05, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x12, 0x29, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6a, 0x61, 0x65, 0x67, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69,
	0x5f, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x52, 0x05, 0x73, 0x70, 0x61, 0x6e, 0x73, 0x12,
	0x30, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x6a, 0x61, 0x65, 0x67, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x32,
	0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x22, 0x75, 0x0a, 0x0e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x63,
	0x68, 0x69, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x68, 0x69, 0x6c,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2a, 0x45, 0x0a, 0x09, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10,
	0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x4f, 0x4f, 0x4c, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x49,
	0x4e, 0x54, 0x36, 0x34, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x36,
	0x34, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x10, 0x04, 0x2a,
	0x2d, 0x0a, 0x0b, 0x53, 0x70, 0x61, 0x6e, 0x52, 0x65, 0x66, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x48, 0x49, 0x4c, 0x44, 0x5f, 0x4f, 0x46, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c,
	0x46, 0x4f, 0x4c, 0x4c, 0x4f, 0x57, 0x53, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x10, 0x01, 0x42, 0x4e,
	0x0a, 0x17, 0x69, 0x6f, 0x2e, 0x6a, 0x61, 0x65, 0x67, 0x65, 0x72, 0x74, 0x72, 0x61, 0x63, 0x69,
	0x6e, 0x67, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x32, 0x5a, 0x33, 0x6b, 0x38, 0x73, 0x2e, 0x69,
	0x6f, 0x2f, 0x6b, 0x6f, 0x70, 0x73, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x6f, 0x74, 0x65,
	0x6c, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2f, 0x70, 0x62,
	0x2f, 0x6a, 0x61, 0x65, 0x67, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x32, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_jaeger_api_v2_model_proto_rawDescOnce sync.Once
	file_jaeger_api_v2_model_proto_rawDescData = file_jaeger_api_v2_model_proto_rawDesc
)

func file_jaeger_api_v2_model_proto_rawDescGZIP() []byte {
	file_jaeger_api_v2_model_proto_rawDescOnce.Do(func() {
		file_jaeger_api_v2_model_proto_rawDescData = protoimpl.X.CompressGZIP(file_jaeger_api_v2_model_proto_rawDescData)
	})
	return file_jaeger_api_v2_model_proto_rawDescData
}

var file_jaeger_api_v2_model_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_jaeger_api_v2_model_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_jaeger_api_v2_model_proto_goTypes = []interface{}{
	(ValueType)(0),                // 0: jaeger.api_v2.ValueType
	(SpanRefType)(0),              // 1: jaeger.api_v2.SpanRefType
	(*KeyValue)(nil),              // 2: jaeger.api_v2.KeyValue
	(*Log)(nil),                   // 3: jaeger.api_v2.Log
	(*SpanRef)(nil),               // 4: jaeger.api_v2.SpanRef
	(*Process)(nil),               // 5: jaeger.api_v2.Process
	(*Span)(nil),                  // 6: jaeger.api_v2.Span
	(*Trace)(nil),                 // 7: jaeger.api_v2.Trace
	(*Batch)(nil),                 // 8: jaeger.api_v2.Batch
	(*DependencyLink)(nil),        // 9: jaeger.api_v2.DependencyLink
	(*Trace_ProcessMapping)(nil),  // 10: jaeger.api_v2.Trace.ProcessMapping
	(*timestamppb.Timestamp)(nil), // 11: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),   // 12: google.protobuf.Duration
}
var file_jaeger_api_v2_model_proto_depIdxs = []int32{
	0,  // 0: jaeger.api_v2.KeyValue.v_type:type_name -> jaeger.api_v2.ValueType
	11, // 1: jaeger.api_v2.Log.timestamp:type_name -> google.protobuf.Timestamp
	2,  // 2: jaeger.api_v2.Log.fields:type_name -> jaeger.api_v2.KeyValue
	1,  // 3: jaeger.api_v2.SpanRef.ref_type:type_name -> jaeger.api_v2.SpanRefType
	2,  // 4: jaeger.api_v2.Process.tags:type_name -> jaeger.api_v2.KeyValue
	4,  // 5: jaeger.api_v2.Span.references:type_name -> jaeger.api_v2.SpanRef
	11, // 6: jaeger.api_v2.Span.start_time:type_name -> google.protobuf.Timestamp
	12, // 7: jaeger.api_v2.Span.duration:type_name -> google.protobuf.Duration
	2,  // 8: jaeger.api_v2.Span.tags:type_name -> jaeger.api_v2.KeyValue
	3,  // 9: jaeger.api_v2.Span.logs:type_name -> jaeger.api_v2.Log
	5,  // 10: jaeger.api_v2.Span.process:type_name -> jaeger.api_v2.Process
	6,  // 11: jaeger.api_v2.Trace.spans:type_name -> jaeger.api_v2.Span
	10, // 12: jaeger.api_v2.Trace.process_map:type_name -> jaeger.api_v2.Trace.ProcessMapping
	6,  // 13: jaeger.api_v2.Batch.spans:type_name -> jaeger.api_v2.Span
	5,  // 14: jaeger.api_v2.Batch.process:type_name -> jaeger.api_v2.Process
	5,  // 15: jaeger.api_v2.Trace.ProcessMapping.process:type_name -> jaeger.api_v2.Process
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_jaeger_api_v2_model_proto_init() }
func file_jaeger_api_v2_model_proto_init() {
	if File_jaeger_api_v2_model_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_jaeger_api_v2_model_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jaeger_api_v2_model_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Log); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jaeger_api_v2_model_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpanRef); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jaeger_api_v2_model_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Process); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jaeger_api_v2_model_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jaeger_api_v2_model_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jaeger_api_v2_model_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Batch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jaeger_api_v2_model_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DependencyLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jaeger_api_v2_model_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trace_ProcessMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_jaeger_api_v2_model_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_jaeger_api_v2_model_proto_goTypes,
		DependencyIndexes: file_jaeger_api_v2_model_proto_depIdxs,
		EnumInfos:         file_jaeger_api_v2_model_proto_enumTypes,
		MessageInfos:      file_jaeger_api_v2_model_proto_msgTypes,
	}.Build()
	File_jaeger_api_v2_model_proto = out.File
	file_jaeger_api_v2_model_proto_rawDesc = nil
	file_jaeger_api_v2_model_proto_goTypes = nil
	file_jaeger_api_v2_model_proto_depIdxs = nil
}
