/* 
   crypt -- take a soon-to-be password from the command line, and output
	    it in it's crypted form.  This is probably not the best
	    implementation ever done. :)

   Copyright (C) 2000 A.L.Lambert.
   
   Version 1.1 by Joachim Fenkes <dojoe@gmx.net> - added MD5 support.
   Version 1.2 - fixes a bug introduced by A.L.Lambert in the argv[] handling.
   Version 1.2.2 by Joachim Fenkes - fixed an off-by-one error in cr_random()
   Version 1.2.2 by Joachim Fenkes - "-m -s salt" now really produces MD5 ;)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

#include "include.h"

/* shared amongst the functions in this file */
long int rand_file;

/* note: the use of /dev/[u]random to seed the random number generator in an 
 * applicatoin such as this is ridiculous overkill.  But, it's a good learning
 * experience for the author, and hey, overkill never hurt anything. :) */

/* open up a random file for entropy source if we can */
short int open_randfile() {
	/* someplace to store stat info */
	struct stat statbuf;
	
	if(debug) fprintf(stderr, "in open_randfile();\n");
	
	/* see if we can stat /dev/urandom or /dev/random and open them if we can */
	if(stat("/dev/urandom", &statbuf) == 0 && S_ISCHR(statbuf.st_mode)) {
		if(debug) fprintf(stderr, "\topening /dev/urandom\n");
		rand_file = open("/dev/urandom", O_RDONLY);
		/* if it opened successfully, return 0; */
		if(rand_file != -1) return 0;
		/* we don't return here if it failed, because we want to try /dev/random
		 * below as a last resort */
	}
	/* if we're here it's because either /dev/urandom doesn't exist, or can't be open()ed */
	if (stat("/dev/random", &statbuf) == 0 && S_ISCHR(statbuf.st_mode)) {
		if(debug) fprintf(stderr, "\topening /dev/random\n");
		rand_file = open("/dev/random", O_RDONLY);
		if(rand_file != -1) return 0;
	}
	/* if we made it this far, we obviously aren't going to get an open file - bummer */	
	if(debug) fprintf(stderr, "\tno random file available.\n");
	return -1; /* return error */
}

/* a function to seed the random number generator (hopefully) with some decent input */
unsigned long int seed_srand() {
	unsigned long int retval;	/* some randomness (if we can get any) */
	
	if(debug) fprintf(stderr, "\tin seed_srandom();\n");
	
	if(open_randfile() == 0) {
		/* read a long int worth of randomness from the file */
		read(rand_file, &retval, sizeof(long int));
		close(rand_file); /* close the file */
	} else {
		/* we got no random file and therefore no randomness - yuck!!! */
		/* we'll take our CPU usage &'d with seconds since epoch as random seed */
		retval = (unsigned long int) (time(NULL) ^ getpid());
	}
	return retval;	/* retval = our new random seed */
}

/* function to go get some randomness and return some random characters */
short int cr_random() {
	short int i;		/* a counter */
	long int len, ti;	/* lenght and temp-int */
	char tsalt[LSIZE];	/* a temp string in which we store random salt char's */
	
	if(debug) fprintf(stderr, "in cr_random();\n");
	
	if(do_salt == 1) {
		/* if md5 requested, prepend $1$ to given salt */
		if(md5 == 1) {
			strncpy(tsalt, salt, 8);
			tsalt[8] = '\0';
			strcpy(salt, "$1$");
			strcat(salt, tsalt);
		}
		return 0;
	}

	/* seed our random number generator */
	srand(seed_srand());
	/* set up the characters we might pull from to make a salt */
	strcpy(salt_src, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789./");
	/* set the length so we can stay inside it */
	len = strlen(salt_src);

	/* grab ouselves 8 bytes of random characters within our range  */
	for(i = 0 ; i < 8 ; ++i)  {
		/* see 'man rand' for why we get ti this way */
		/* note by JF: we want an int between 0 and (len-1),
		   not between 1 and len! Copying \0 is not good =) */
		ti = (int) ((float)len * rand() / (RAND_MAX+1.0));
		tsalt[i] = salt_src[ti];
	}
	tsalt[8] = '\0';
	
	/* zero the memory we're going to put the salt in */
	memset(salt, 0, 64);
	if(md5) { /* if it's a MD5, we want '$1$oursalt' - make it so */
		strcpy(salt, "$1$");
		strcat(salt, tsalt);
	} else { /* plain ole crypt call - seed it with 2 bytes (sad) */
		strncpy(salt, tsalt, 2);
		salt[3] = '\0';
	}
	return 0;
}
