all: factor factor.1

factor: factor.o
	$(LD) $(LDFLAGS) factor.o -lm $(LCOMMON) $(LWCHAR) $(LIBS) -o factor

factor.o: factor.c config.h
	$(CC) $(CFLAGS) $(CPPFLAGS) $(XO6FL) $(IWCHAR) $(ICOMMON) -c factor.c

factor.1: factor.1.in mansubst config.h
	sh mansubst <factor.1.in >factor.1

mansubst: mansubst.sh
	echo 'cc="$(CC) $(CFLAGS) $(CPPFLAGS) $(XO6FL) $(IWCHAR) $(ICOMMON)"' | \
		cat - mansubst.sh >mansubst
	chmod +x mansubst

config.h:
	-echo	'/*	Auto-generated by make. Do not edit!	*/' >config.h
	-echo '#include <math.h>' >___build$$$$.c ; \
	echo 'int main(void) { sqrtl(2); fmodl(2, 2); powl(2, 2); return 0; }'\
		>>___build$$$$.c ; \
	$(CC) ___build$$$$.c -lm -o ___build$$$$ >/dev/null 2>&1 ; \
	if test $$? = 0 && test -f ___build$$$$ ; \
	then	\
		echo '#if !defined (__dietlibc__) && !defined (_AIX)' >>config.h ; \
		echo '#define	USE_LONG_DOUBLE' >>config.h ; \
		echo '#endif' >>config.h ; \
	fi ; \
	rm -f ___build$$$$.c ___build$$$$ ___build$$$$.o

install: all
	$(UCBINST) -c factor $(ROOT)$(DEFBIN)/factor
	$(STRIP) $(ROOT)$(DEFBIN)/factor
	$(MANINST) -c -m 644 factor.1 $(ROOT)$(MANDIR)/man1/factor.1

clean:
	rm -f factor factor.o factor.1 mansubst config.h core log *~
