#ifndef __XHKEYS_PLUGIN_H__
#define __XHKEYS_PLUGIN_H__

#define XHKEYS_PLUGIN_VERSION 0x2020

#define XHKEYS_PLUGIN_OPNAME_LENGTH 16

typedef enum {
    XHKEYS_PLUGOPTYPE_PARMNONE,
    XHKEYS_PLUGOPTYPE_PARMOPTIONAL,
    XHKEYS_PLUGOPTYPE_PARMREQUIRED,
    // Flags
    XHKEYS_PLUGOPTYPE_PARMSPECCHARS = 0x80,	
    XHKEYS_PLUGOPTYPE_CANCONTINUE = 0x100,
    XHKEYS_PLUGOPTYPE_PERSISTENT = 0x300,  // no discontinue on repeated press
	                                 // assumes CONTINUOUS: (0x200 | 0x100)
//    XHKEYS_PLUGOPTYPE_DONT_ERASE = 0x400	 // Graphic draw (no need to clear contents)
} XHKEYS_PLUGIN_OPERTYPE;    

typedef enum 
{
    XHK_BEHAVIOUR_ONCE,
    XHK_BEHAVIOUR_CONTINUOUS,
    XHK_BEHAVIOUR_REPEATED=100,
    XHK_BEHAVIOUR_DISCONTINUE
} XHKEYS_PLUGIN_BEHAVIOUR;

typedef enum 
{
    XHK_PLUGIN_VERSION,		// Plugin version (from plugin)
    XHK_PLUGIN_DESCRIPTION,	// Plugin description (from plugin)
    XHK_PLUGIN_APPVERSION,	// xhkeys version (to plugin)
    XHK_PLUGIN_LOGMODE,		// (logConsole << 8) | logMode (to plugin)
    XHK_PLUGIN_OSDDATA		// pointer to XHKEYS_PLUGIN_OSD_DATA
} XHKEYS_PLUGIN_PROPERTY;

typedef struct
{
    // The order is convenient for date typa alignment,
    // while someone might find it illogical :)
    Display *dpy;		// Display	
    int	screenNo;		// Screen number
    unsigned long textColour;	// text colour
    unsigned long bkgrColour;	// background colour
    unsigned long frameColour;	// frame colour
    unsigned long bkgrMask;	// Background mask
    GC	 drawGC;		// Draw Graphic context
    GC	 maskGC;		// Mask Graphic context
    Pixmap drawPixmap;		// Draw pixmap
    Pixmap maskBitmap;		// Mask bitmap
    XRectangle	rect;		// OSD location and size
    XFontStruct *font;		// Font data used for drawing OSD text
    int textTop;		// Offset of text top
    char  alignment;		// OSD text alignment (0-left, 1-right, 2-centre)
    char  frameWidth;		// Frame width (0 to 4)
    Bool enabled;		// OSD enabled
} XHKEYS_PLUGIN_OSD_DATA;

/*
typedef enum
{
    XHKEYS_PLUGPROCRC_ERROR = -1,

    // OSDTEXT and OSDGRAPHICS flags that can be OR-ed
    XHKEYS_PLUGPROCRC_OSDTEXT = 1,
    XHKEYS_PLUGPROCRC_OSDGRAPHICS = 2
    

} XHKEYS_PLUGPROCESS_RETCODE;
*/

# if defined(__cplusplus) || defined(c_plusplus)
#   define __XHKEYS_PLUGIN_FUNCPROTOHDR__  extern "C"  
# else
#   define __XHKEYS_PLUGIN_FUNCPROTOHDR__
# endif

typedef __XHKEYS_PLUGIN_FUNCPROTOHDR__
         Bool (XHKEYS_PLUGIN_INIT)(void **bufferReturn, 
	 const char *initString, char *message, int msgLen);

	 
//  Before 2.2.0 returned XHKEYS_PLUGPROCESS_RETCODE
typedef __XHKEYS_PLUGIN_FUNCPROTOHDR__
         Bool (XHKEYS_PLUGIN_PROCESS)(void *buffer, int opcode,
	         const char *argument, int behaviour,
		 char *message, int msgLen);

typedef __XHKEYS_PLUGIN_FUNCPROTOHDR__
         Bool (XHKEYS_PLUGIN_PROPERTYEXCHANGER)(void *buffer,
	         XHKEYS_PLUGIN_PROPERTY code, ...);

typedef __XHKEYS_PLUGIN_FUNCPROTOHDR__
	 void (XHKEYS_PLUGIN_TERM)(void *buffer);

typedef __XHKEYS_PLUGIN_FUNCPROTOHDR__
         int (XHKEYS_PLUGIN_GETOPCOUNT)(void);

typedef __XHKEYS_PLUGIN_FUNCPROTOHDR__
         Bool (XHKEYS_PLUGIN_GETOPDATA)(int opCode,
	  char opName[XHKEYS_PLUGIN_OPNAME_LENGTH], int *opFlags);


# ifdef XHKEYS_PLUGIN_CODE

XHKEYS_PLUGIN_INIT init;
XHKEYS_PLUGIN_PROCESS process;
XHKEYS_PLUGIN_GETOPCOUNT getopcount;
XHKEYS_PLUGIN_GETOPDATA getopdata;
XHKEYS_PLUGIN_PROPERTYEXCHANGER property;
XHKEYS_PLUGIN_TERM term;

# endif

#endif
