/*
*         OpenPBS (Portable Batch System) v2.3 Software License
*
* Copyright (c) 1999-2000 Veridian Information Solutions, Inc.
* All rights reserved.
*
* ---------------------------------------------------------------------------
* For a license to use or redistribute the OpenPBS software under conditions
* other than those described below, or to purchase support for this software,
* please contact Veridian Systems, PBS Products Department ("Licensor") at:
*
*    www.OpenPBS.org  +1 650 967-4675                  sales@OpenPBS.org
*                        877 902-4PBS (US toll-free)
* ---------------------------------------------------------------------------
*
* This license covers use of the OpenPBS v2.3 software (the "Software") at
* your site or location, and, for certain users, redistribution of the
* Software to other sites and locations.  Use and redistribution of
* OpenPBS v2.3 in source and binary forms, with or without modification,
* are permitted provided that all of the following conditions are met.
* After December 31, 2001, only conditions 3-6 must be met:
*
* 1. Commercial and/or non-commercial use of the Software is permitted
*    provided a current software registration is on file at www.OpenPBS.org.
*    If use of this software contributes to a publication, product, or
*    service, proper attribution must be given; see www.OpenPBS.org/credit.html
*
* 2. Redistribution in any form is only permitted for non-commercial,
*    non-profit purposes.  There can be no charge for the Software or any
*    software incorporating the Software.  Further, there can be no
*    expectation of revenue generated as a consequence of redistributing
*    the Software.
*
* 3. Any Redistribution of source code must retain the above copyright notice
*    and the acknowledgment contained in paragraph 6, this list of conditions
*    and the disclaimer contained in paragraph 7.
*
* 4. Any Redistribution in binary form must reproduce the above copyright
*    notice and the acknowledgment contained in paragraph 6, this list of
*    conditions and the disclaimer contained in paragraph 7 in the
*    documentation and/or other materials provided with the distribution.
*
* 5. Redistributions in any form must be accompanied by information on how to
*    obtain complete source code for the OpenPBS software and any
*    modifications and/or additions to the OpenPBS software.  The source code
*    must either be included in the distribution or be available for no more
*    than the cost of distribution plus a nominal fee, and all modifications
*    and additions to the Software must be freely redistributable by any party
*    (including Licensor) without restriction.
*
* 6. All advertising materials mentioning features or use of the Software must
*    display the following acknowledgment:
*
*     "This product includes software developed by NASA Ames Research Center,
*     Lawrence Livermore National Laboratory, and Veridian Information
*     Solutions, Inc.
*     Visit www.OpenPBS.org for OpenPBS software support,
*     products, and information."
*
* 7. DISCLAIMER OF WARRANTY
*
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND. ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT
* ARE EXPRESSLY DISCLAIMED.
*
* IN NO EVENT SHALL VERIDIAN CORPORATION, ITS AFFILIATED COMPANIES, OR THE
* U.S. GOVERNMENT OR ANY OF ITS AGENCIES BE LIABLE FOR ANY DIRECT OR INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "pbs_ifl.h"
#include "cmds.h"

static char *deptypes[] =
  {
  (char *)"on",  /* "on" and "synccount" must be first two */
  (char *)"synccount",
  (char *)"after",
  (char *)"afterok",
  (char *)"afternotok",
  (char *)"afterany",
  (char *)"before",
  (char *)"beforeok",
  (char *)"beforenotok",
  (char *)"beforeany",
  (char *)"syncwith",
  (char *)0
  };

static char *arraydeptypes[] =
  {
  (char *)"afterstartarray",
  (char *)"afterokarray",
  (char *)"afternotokarray",
  (char *)"afteranyarray",
  (char *)"beforestartarray",
  (char *)"beforeokarray",
  (char *)"beforenotokarray",
  (char *)"beforeanyarray",
  (char *)0
  };

/*
 *
 * parse_depend_item
 *
 * syntax:
 *
 * jobid[:jobid...]
 *
 * return 0 on okay, 1 if error, 2 if length will be too long
 *
 */

int parse_depend_item(

  char                     *depend_list,
  std::vector<std::string> &dependency_list)

  {
  char        *at;
  int          i = 0;
  int          first = 1;
  int          array = 0;
  char        *s = NULL;
  char        *c;
  std::string  dep_string;

  /* Begin the parse */
  c = depend_list;

  /* Loop on strings between colons */

  while (*c != '\0')
    {
    s = c;

    while (((*c != ':') || (*(c - 1) == '\\'))  && *c) c++;

    if (s == c) return 1;

    if (*c == ':')
      {
      *c++ = '\0';
      }

    if (first)
      {
      first = 0;

      for (i = 0; deptypes[i]; ++i)
        {
        if (strcmp(s, deptypes[i]) == 0)
          break;
        }

      if (deptypes[i] == (char *)0)
        {
        for (i = 0; arraydeptypes[i]; ++i)
          {
          if (!strcmp(s,arraydeptypes[i]))
            {
            break;
            }
          }

        if (arraydeptypes[i] == (char *)0)
          {
          return 1;
          }
        else
          {
          array = 1;
          }

        if (dependency_list.size() == 0)
          {
          dep_string += arraydeptypes[i];
          dependency_list.push_back(dep_string);
          }
        else
          {
          for (size_t j = 0; j < dependency_list.size(); j++)
            dependency_list[j] += arraydeptypes[i];
          }
        }
      else
        {
        if (dependency_list.size() == 0)
          {
          dep_string += deptypes[i];
          dependency_list.push_back(dep_string);
          }
        else
          {
          for (size_t j = 0; j < dependency_list.size(); j++)
            dependency_list[j] += deptypes[i];
          }
        }

      }
    else
      {
      std::vector<std::string> id_list;
      std::string              server_name;

      /* for "on" and "synccount", number */
      if ((i < 2) ||
          (array))
        {
        for (size_t j = 0; j < dependency_list.size(); j++)
          dependency_list[j] += s;

        if (array)
          {
          /* append '.server_name' for arrays */
          char *open_square_bracket;

          /* only do this if the server isn't already there */
          if (dependency_list[0].find('.') == std::string::npos)
            {
            /* fix open_square_bracket for server search */
            open_square_bracket = strchr(s,'[');
            if (open_square_bracket != NULL)
              {
              *open_square_bracket = '\0';
              }

            if (get_server_and_job_ids(s, id_list, server_name))
              return 1;

            /* now put it back */
            if (open_square_bracket != NULL)
              {
              *open_square_bracket = '[';
              }
                
            while (id_list.size() > dependency_list.size())
              dependency_list.push_back(dependency_list[0]);

            for (size_t j = 0; j < id_list.size(); j++)
              {
              size_t pos = id_list[j].find('.');

              // Just concatenate the .server_name piece
              if (pos != std::string::npos)
                {
                dependency_list[j] += id_list[j].substr(pos);
                }
              }
            }
          }
        }
      else    /* for others, job id */
        {
        at = strchr(s, (int)'@');

        if (get_server_and_job_ids(s, id_list, server_name))
          return 1;
          
        while (id_list.size() > dependency_list.size())
          dependency_list.push_back(dependency_list[0]);

        for (size_t j = 0; j < id_list.size(); j++)
          {
          dependency_list[j] += id_list[j];

          if (at)
            {
            dependency_list[j] += "@";
            dependency_list[j] += server_name;
            }
          }
        }
      }

    if (*c)
      {
      for (size_t j = 0; j < dependency_list.size(); j++)
        {
        dependency_list[j] += ":";
        }
      }
    }

  if (s == c)
    return 1;

  return(PBSE_NONE);
  } // END parse_depend_item()



/*
 *
 * parse_depend_list
 *
 * syntax:
 *
 * depend_list[,depend_list...]
 *
 * Arguments:
 *
 * list  List of colon delimited lists.
 *
 */

int parse_depend_list(

  char *list,
  std::vector<std::string> &dependency_list)

  {
  char *b = NULL;
  char *c = NULL;
  char *s = NULL;
  char *lc = NULL;
  int   comma = 0;
  int   rtn = 0;

  if (strlen(list) == 0) return (1);

  if ((lc = (char *)calloc(1, strlen(list) + 1)) == (char *)0)
    {
    fprintf(stderr, "Out of memory.\n");
    exit(1);
    }

  strcpy(lc, list);

  c = lc;

  while (*c != '\0')
    {
    /* Drop leading white space */
    while (isspace(*c)) c++;

    /* Find the next comma */
    s = c;

    while (*c != ',' && *c) c++;

    /* Drop any trailing blanks */
    comma = (*c == ',');

    *c = '\0';

    b = c - 1;

    while (isspace((int)*b)) *b-- = '\0';


    /* Parse the individual list item */
    rtn = parse_depend_item(s, dependency_list);

    if (rtn)
      {
      free(lc);
      return (rtn);
      }

    if (comma)
      {
      c++;
      for (size_t i = 0; i < dependency_list.size(); i++)
        {
        dependency_list[i] += ",";
        }
      }
    }

  free(lc);

  if (comma) return 1;

  return 0;
  }
