#ifndef GUMBO_INSERTION_MODE_H_
#define GUMBO_INSERTION_MODE_H_

// https://html.spec.whatwg.org/multipage/parsing.html#insertion-mode
// If new enum values are added, be sure to update the kTokenHandlers
// dispatch table in parser.c.
typedef enum {
  GUMBO_INSERTION_MODE_INITIAL,
  GUMBO_INSERTION_MODE_BEFORE_HTML,
  GUMBO_INSERTION_MODE_BEFORE_HEAD,
  GUMBO_INSERTION_MODE_IN_HEAD,
  GUMBO_INSERTION_MODE_IN_HEAD_NOSCRIPT,
  GUMBO_INSERTION_MODE_AFTER_HEAD,
  GUMBO_INSERTION_MODE_IN_BODY,
  GUMBO_INSERTION_MODE_TEXT,
  GUMBO_INSERTION_MODE_IN_TABLE,
  GUMBO_INSERTION_MODE_IN_TABLE_TEXT,
  GUMBO_INSERTION_MODE_IN_CAPTION,
  GUMBO_INSERTION_MODE_IN_COLUMN_GROUP,
  GUMBO_INSERTION_MODE_IN_TABLE_BODY,
  GUMBO_INSERTION_MODE_IN_ROW,
  GUMBO_INSERTION_MODE_IN_CELL,
  GUMBO_INSERTION_MODE_IN_SELECT,
  GUMBO_INSERTION_MODE_IN_SELECT_IN_TABLE,
  GUMBO_INSERTION_MODE_IN_TEMPLATE,
  GUMBO_INSERTION_MODE_AFTER_BODY,
  GUMBO_INSERTION_MODE_IN_FRAMESET,
  GUMBO_INSERTION_MODE_AFTER_FRAMESET,
  GUMBO_INSERTION_MODE_AFTER_AFTER_BODY,
  GUMBO_INSERTION_MODE_AFTER_AFTER_FRAMESET
} GumboInsertionMode;

#endif // GUMBO_INSERTION_MODE_H_
