/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.domain;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.internal.DateUtils;
import com.jgoodies.jdiskreport.domain.ScanConfigurations;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Properties;

public final class ScanConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_PATH = "path";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_FILE_INCLUSIONS = "file-inclusions";
    public static final String PROPERTY_FILE_EXCLUSIONS = "file-exclusions";
    public static final String PROPERTY_MIN_ACCESS_DATE = "min-access-date";
    public static final String PROPERTY_MAX_ACCESS_DATE = "max-access-date";
    public static final String PROPERTY_MIN_MODIFIED_DATE = "min-modified-date";
    public static final String PROPERTY_MAX_MODIFIED_DATE = "max-modified-date";
    private String path;
    private String name;
    private String fileInclusions;
    private String fileExclusions;
    private Date minAccessDate;
    private Date maxAccessDate;
    private Date minModifiedDate;
    private Date maxModifiedDate;

    public ScanConfiguration(String targetPath) {
        this.path = Preconditions.checkNotNull(targetPath, "The %s must not be null.", "target path");
        this.name = targetPath;
        this.fileInclusions = "";
        this.fileExclusions = ScanConfigurations.createDefaultExclusions();
        this.minAccessDate = null;
        this.maxAccessDate = null;
        this.minModifiedDate = null;
        this.maxModifiedDate = null;
    }

    public ScanConfiguration(Path target) {
        this(target == null ? null : target.toString());
    }

    public Path getPath() {
        return Paths.get(this.path, new String[0]);
    }

    public void setPath(Path newPath) {
        Preconditions.checkNotNull(newPath, "The %s must not be null.", "target");
        this.path = newPath.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        this.name = newValue;
    }

    public String getFileExclusions() {
        return this.fileExclusions;
    }

    public void setFileExclusions(String newValue) {
        this.fileExclusions = newValue;
    }

    public String getFileInclusions() {
        return this.fileInclusions;
    }

    public void setFileInclusions(String newValue) {
        this.fileInclusions = newValue;
    }

    public Date getMinAccessDate() {
        return this.minAccessDate;
    }

    public void setMinAccessDate(Date newValue) {
        this.minAccessDate = newValue;
    }

    public Date getMaxAccessDate() {
        return this.maxAccessDate;
    }

    public void setMaxAccessDate(Date newValue) {
        this.maxAccessDate = newValue;
    }

    public Date getMinModifiedDate() {
        return this.minModifiedDate;
    }

    public void setMinModifiedDate(Date newValue) {
        this.minModifiedDate = newValue;
    }

    public Date getMaxModifiedDate() {
        return this.maxModifiedDate;
    }

    public void setMaxModifiedDate(Date newValue) {
        this.maxModifiedDate = newValue;
    }

    public static ScanConfiguration from(Properties properties) {
        String path = properties.getProperty(PROPERTY_PATH);
        ScanConfiguration configuration = new ScanConfiguration(path);
        configuration.setName(properties.getProperty(PROPERTY_NAME));
        configuration.setFileInclusions(properties.getProperty(PROPERTY_FILE_INCLUSIONS));
        configuration.setFileExclusions(properties.getProperty(PROPERTY_FILE_EXCLUSIONS));
        configuration.setMinAccessDate(ScanConfiguration.decodeTime(properties.getProperty(PROPERTY_MIN_ACCESS_DATE)));
        configuration.setMaxAccessDate(ScanConfiguration.decodeTime(properties.getProperty(PROPERTY_MAX_ACCESS_DATE)));
        configuration.setMinModifiedDate(ScanConfiguration.decodeTime(properties.getProperty(PROPERTY_MIN_MODIFIED_DATE)));
        configuration.setMaxModifiedDate(ScanConfiguration.decodeTime(properties.getProperty(PROPERTY_MAX_MODIFIED_DATE)));
        return configuration;
    }

    public Properties asProperties() {
        Properties properties = new Properties();
        properties.setProperty(PROPERTY_PATH, this.getPath().toString());
        properties.setProperty(PROPERTY_NAME, this.getName());
        properties.setProperty(PROPERTY_FILE_INCLUSIONS, this.getFileInclusions());
        properties.setProperty(PROPERTY_FILE_EXCLUSIONS, this.getFileExclusions());
        properties.setProperty(PROPERTY_MIN_ACCESS_DATE, ScanConfiguration.encodeTime(this.getMinAccessDate()));
        properties.setProperty(PROPERTY_MAX_ACCESS_DATE, ScanConfiguration.encodeTime(this.getMaxAccessDate()));
        properties.setProperty(PROPERTY_MIN_MODIFIED_DATE, ScanConfiguration.encodeTime(this.getMinModifiedDate()));
        properties.setProperty(PROPERTY_MAX_MODIFIED_DATE, ScanConfiguration.encodeTime(this.getMaxModifiedDate()));
        return properties;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Scan Configuration: ");
        builder.append("\nPath=");
        builder.append(this.getPath());
        builder.append("\nName=");
        builder.append(this.getName());
        builder.append("\nfile-inclusions=");
        builder.append(Strings.isNotBlank(this.getFileInclusions()) ? this.getFileInclusions() : "none");
        builder.append("\nfile-exclusions=");
        builder.append(Strings.isNotBlank(this.getFileExclusions()) ? this.getFileExclusions() : "none");
        builder.append("\nMin access date=");
        builder.append(this.minAccessDate != null ? ScanConfiguration.formatDateTime(this.getMinAccessDate()) : "none");
        builder.append("\nMax access date=");
        builder.append(this.maxAccessDate != null ? ScanConfiguration.formatDateTime(this.getMaxAccessDate()) : "none");
        builder.append("\nMin modified date=");
        builder.append(this.minModifiedDate != null ? ScanConfiguration.formatDateTime(this.getMinModifiedDate()) : "none");
        builder.append("\nMax modified date=");
        builder.append(this.maxModifiedDate != null ? ScanConfiguration.formatDateTime(this.getMaxModifiedDate()) : "none");
        return builder.toString();
    }

    private static Date decodeTime(String time) {
        if (Strings.isBlank(time)) {
            return null;
        }
        try {
            LocalDate date = LocalDate.parse(time.trim());
            return DateUtils.toDate(date);
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }

    private static String encodeTime(Date time) {
        return DateFormat.getDateInstance().format(time);
    }

    private static String formatDateTime(Date time) {
        return DateFormat.getDateTimeInstance(1, 1).format(time);
    }
}

