/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tabs;

import com.jgoodies.common.internal.Collectors10;
import com.jgoodies.common.promise.Promise;
import com.jgoodies.fluent.tabs.Tab;
import com.jgoodies.fluent.tabs.TabModel;
import com.jgoodies.navigation.Page;
import com.jgoodies.navigation.internal.BackStack;
import com.jgoodies.navigation.internal.PagePersistencyUtils;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import javax.swing.event.HyperlinkEvent;

public class FrameTabModel<T extends Tab.DefaultFrameTab>
extends TabModel<T>
implements BackStack {
    private final Supplier<T> tabCreator;
    private final Supplier<Page> newTabPageCreator;
    private final Predicate<Page> newTabPageTest;
    private final PropertyChangeListener forwardPropertyChange = this::forwardPropertyChange;
    private static String PINNED_TABS_PREFS_PATH = "tabs/pinned";

    public FrameTabModel(Supplier<T> tabCreator, Supplier<Page> newTabPageCreator, Predicate<Page> newTabPageTest) {
        this.tabCreator = tabCreator;
        this.newTabPageCreator = newTabPageCreator;
        this.newTabPageTest = newTabPageTest;
        this.setNewTabHandler(this::addNewTab);
        this.initEventHandling();
    }

    public final void initialPage(Page page) {
        this.openInNewTab(page, null, null, true, true);
    }

    public final T addNewTab(EventObject evt) {
        return this.openInNewTab(this.newTabPageCreator.get(), null, this.getSelectedTabId(), true, true);
    }

    public final T addNewTabToTheRight(EventObject evt) {
        return this.openInNewTab(this.newTabPageCreator.get(), null, this.getSelectedTabId(), true, false);
    }

    public final T showOrOpen(Page page) {
        return this.showOrOpen(page, null);
    }

    public final T showOrOpen(Page page, Object params) {
        return this.showOrOpen(page, params, this.getSelectedTabId());
    }

    public final T showOrOpen(Page page, Object params, Object openerTabId) {
        for (Tab.DefaultFrameTab tab : this.getTabs()) {
            if (tab.getCurrentPage() != page) continue;
            this.setSelectedTab(tab);
            tab.refreshCurrentPage(params);
            return (T)tab;
        }
        return this.open(page, params, openerTabId);
    }

    public final T open(Page page) {
        return this.open(page, null);
    }

    public final T open(Page page, Object params) {
        return this.open(page, params, this.getSelectedTabId());
    }

    public final T open(Page page, Object params, Object openerTabId) {
        Tab.DefaultFrameTab selectedTab = (Tab.DefaultFrameTab)this.getSelectedTab();
        if (selectedTab != null && this.newTabPageTest.test(selectedTab.getCurrentPage())) {
            selectedTab.navigate(null, page, params);
            return null;
        }
        return this.openInNewTab(page, params, openerTabId, true, true);
    }

    public final T open(EventObject evt, Page page) {
        return this.open(evt, page, null);
    }

    public final T open(EventObject evt, Page page, Object params) {
        return this.open(evt, page, params, this.getSelectedTabId());
    }

    public final T open(EventObject evt, Page page, Object params, Object openerTabId) {
        boolean openInSelectedTab;
        Tab.DefaultFrameTab selectedTab = (Tab.DefaultFrameTab)this.getSelectedTab();
        boolean pinned = selectedTab != null && selectedTab.isPinned();
        boolean bl = openInSelectedTab = !this.isCtrlDown(evt) && !pinned;
        if (selectedTab != null && openInSelectedTab) {
            selectedTab.navigate(evt, page, params);
            return (T)((Tab.DefaultFrameTab)this.getSelectedTab());
        }
        boolean selectNewTab = this.isShiftDown(evt) || pinned && !this.isCtrlDown(evt);
        return this.openInNewTab(page, params, openerTabId, selectNewTab, false);
    }

    public final T openInNewTab(Page page) {
        return this.openInNewTab(page, null);
    }

    public final T openInNewTab(Page page, Object params) {
        return this.openInNewTab(page, params, false);
    }

    public final T openInNewTab(Page page, Object params, boolean selectNewTab) {
        return this.openInNewTab(page, params, this.getSelectedTabId(), selectNewTab, true);
    }

    @Override
    public final Page getCurrentPage() {
        return this.getSelectedTab() == null ? null : ((Tab.DefaultFrameTab)this.getSelectedTab()).getCurrentPage();
    }

    @Override
    public final Page getPreviousPage() {
        return ((Tab.DefaultFrameTab)this.getSelectedTab()).getPreviousPage();
    }

    @Override
    public final boolean canGoBack() {
        return this.getSelectedTab() != null && ((Tab.DefaultFrameTab)this.getSelectedTab()).canGoBack();
    }

    @Override
    public final Promise<Boolean> goBack(EventObject evt) {
        return ((Tab.DefaultFrameTab)this.getSelectedTab()).goBack(evt);
    }

    protected final Stream<Page> pages() {
        return this.getTabs().stream().flatMap(frameTab -> frameTab.getPages().stream());
    }

    protected final Stream<Page> currentPages() {
        return this.getTabs().stream().map(Tab.DefaultFrameTab::getCurrentPage);
    }

    public final List<Page> getPages() {
        return this.pages().collect(Collectors10.toUnmodifiableList());
    }

    public final List<Page> getCurrentPages() {
        return this.currentPages().collect(Collectors10.toUnmodifiableList());
    }

    public final List<Page> getCurrentPagesOfPinnedTabs() {
        return this.getTabs().stream().filter(Tab::isPinned).map(Tab.DefaultFrameTab::getCurrentPage).collect(Collectors10.toUnmodifiableList());
    }

    public void storePinnedTabs(Preferences userPrefs) {
        Preferences pinnedPrefs = userPrefs.node(PINNED_TABS_PREFS_PATH);
        List<Page> pinnedPages = this.getCurrentPagesOfPinnedTabs();
        pinnedPrefs.putInt("size", pinnedPages.size());
        int index = 0;
        for (Page page : pinnedPages) {
            Preferences node = pinnedPrefs.node("tab" + index++);
            PagePersistencyUtils.storeState(node, page);
        }
    }

    public Promise<Void> restorePinnedTabs(Preferences userPrefs, BiFunction<String, String, Promise<Boolean>> restoreFunction) {
        Preferences pinnedPrefs = userPrefs.node(PINNED_TABS_PREFS_PATH);
        int size = pinnedPrefs.getInt("size", 0);
        return this.restoreTabs(pinnedPrefs, 0, size, restoreFunction);
    }

    private Promise<Void> restoreTabs(Preferences pinnedPrefs, int index, int size, BiFunction<String, String, Promise<Boolean>> restoreFunction) {
        if (index == size) {
            return Promise.of(null);
        }
        Preferences node = pinnedPrefs.node("tab" + index);
        String storedName = PagePersistencyUtils.getStoredName(node, index);
        String storedParameter = PagePersistencyUtils.getStoredParameter(node, index);
        System.out.println("Reading: " + node.absolutePath());
        System.out.println("name=" + storedName + "; parameter=" + storedParameter);
        Promise<Boolean> restorePromise = restoreFunction.apply(storedName, storedParameter);
        return restorePromise.thenCompose(closedTab -> this.restoreTabs(pinnedPrefs, index + 1, size, restoreFunction));
    }

    public boolean hasStoredPinnedTabsBefore(Preferences userPrefs) {
        try {
            return userPrefs.nodeExists(PINNED_TABS_PREFS_PATH);
        }
        catch (BackingStoreException ex) {
            return false;
        }
    }

    private void initEventHandling() {
        this.addPropertyChangeListener("selectedView", this::onSelectedTabChanged);
    }

    private void onSelectedTabChanged(PropertyChangeEvent evt) {
        Tab.DefaultFrameTab oldTab = (Tab.DefaultFrameTab)evt.getOldValue();
        Tab.DefaultFrameTab newTab = (Tab.DefaultFrameTab)evt.getNewValue();
        if (oldTab != null) {
            oldTab.removePropertyChangeListener("canGoBack", this.forwardPropertyChange);
            oldTab.removePropertyChangeListener("currentPage", this.forwardPropertyChange);
        }
        if (newTab != null) {
            newTab.addPropertyChangeListener("canGoBack", this.forwardPropertyChange);
            newTab.addPropertyChangeListener("currentPage", this.forwardPropertyChange);
        }
        this.firePropertyChange("canGoBack", null, (Object)this.canGoBack());
        this.firePropertyChange("currentPage", null, this.getCurrentPage());
    }

    private void forwardPropertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    private T openInNewTab(Page page, Object params, Object openerTabId, boolean selectNewTab, boolean append) {
        Tab.DefaultFrameTab newTab = (Tab.DefaultFrameTab)this.tabCreator.get();
        newTab.setOpenerTabId(openerTabId);
        newTab.initialPage(page, params);
        if (append) {
            this.add(this.size(), newTab);
        } else {
            this.add(newTab);
        }
        if (selectNewTab) {
            this.setSelectedTab(newTab);
        }
        return (T)newTab;
    }

    private Object getSelectedTabId() {
        Tab.DefaultFrameTab tab = (Tab.DefaultFrameTab)this.getSelectedTab();
        return tab == null ? null : tab.getId();
    }

    private boolean isCtrlDown(EventObject evt) {
        int modifiers = this.getModifiers(evt);
        return (modifiers & 2) != 0;
    }

    private boolean isShiftDown(EventObject evt) {
        int modifiers = this.getModifiers(evt);
        return (modifiers & 1) != 0;
    }

    protected int getModifiers(EventObject evt) {
        if (evt instanceof ActionEvent) {
            return ((ActionEvent)evt).getModifiers();
        }
        if (evt instanceof InputEvent) {
            return ((InputEvent)evt).getModifiers();
        }
        if (evt instanceof HyperlinkEvent) {
            InputEvent iEvt = ((HyperlinkEvent)evt).getInputEvent();
            return iEvt != null ? iEvt.getModifiers() : 0;
        }
        return 0;
    }
}

