/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.wizard;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.util.IconUtils;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.core.internal.JSDLCoreStyleChecker;
import com.jgoodies.dialogs.core.pane.wizard.DefaultWizardPage;
import com.jgoodies.dialogs.core.pane.wizard.WizardPage;
import com.jgoodies.dialogs.core.pane.wizard.WizardPageModel;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public final class WizardPageBuilder {
    private final DefaultWizardPage<WizardPageModel> page = new DefaultWizardPage();

    public WizardPageBuilder model(WizardPageModel model) {
        this.page.setPageModel(model);
        return this;
    }

    public WizardPageBuilder mainInstructionIcon(Icon icon) {
        this.page.setMainInstructionIcon(icon);
        return this;
    }

    public WizardPageBuilder mainInstructionIcon(Icon icon, Insets cropInsets) {
        this.page.setMainInstructionIcon(IconUtils.crop(icon, cropInsets));
        return this;
    }

    public WizardPageBuilder mainInstructionText(String text, Object ... args) {
        this.page.setMainInstructionText(Strings.get(text, args));
        return this;
    }

    public WizardPageBuilder mainInstructionLabelsContent(boolean b) {
        this.page.setMainInstructionLabelsContent(b);
        return this;
    }

    public WizardPageBuilder content(JComponent c) {
        this.page.setPageContent(c);
        return this;
    }

    public WizardPageBuilder content(String plainOrHTMLText, Object ... args) {
        JTextComponent c = JGComponentFactory.getCurrent().createStaticText(Strings.get(plainOrHTMLText, args), new Object[0]);
        this.page.setPageContent(c);
        return this;
    }

    public WizardPageBuilder additionalCommandContent(JComponent c) {
        this.page.setAdditionalCommandContent(c);
        return this;
    }

    public WizardPageBuilder defaultFocusOwner(JComponent c) {
        this.page.setDefaultFocusOwner(c);
        return this;
    }

    public WizardPage build() {
        Preconditions.checkNotNull(this.page.getPageModel(), "The %s must not be null.", "page model");
        Preconditions.checkNotNull(this.page.getPageContent(), "The %s must not be null.", "page content");
        JSDLCoreStyleChecker.getInstance().checkWizardPageMainInstructionNotBlank(this.page.getMainInstructionText());
        return this.page;
    }
}

