/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.base;

import java.awt.Toolkit;
import java.util.logging.Logger;
import javax.swing.UIManager;

public final class SystemUtils {
    private static final String OS_NAME = SystemUtils.getSystemProperty("os.name");
    private static final String JAVA_VERSION = SystemUtils.getSystemProperty("java.version");
    public static final boolean IS_OS_LINUX = SystemUtils.startsWith(OS_NAME, "Linux") || SystemUtils.startsWith(OS_NAME, "LINUX");
    public static final boolean IS_OS_MAC = SystemUtils.startsWith(OS_NAME, "Mac OS");
    public static final boolean IS_OS_SOLARIS = SystemUtils.startsWith(OS_NAME, "Solaris");
    public static final boolean IS_OS_WINDOWS = SystemUtils.startsWith(OS_NAME, "Windows");
    public static final boolean IS_OS_WINDOWS_11 = SystemUtils.startsWith(OS_NAME, "Windows 11");
    public static final boolean IS_JAVA_8 = SystemUtils.startsWith(JAVA_VERSION, "1.8");
    public static final boolean IS_LAF_WINDOWS_XP_ENABLED = SystemUtils.isWindowsXPLafEnabled();

    public static boolean isLafAqua() {
        return UIManager.getLookAndFeel().getID().equals("Aqua");
    }

    private SystemUtils() {
    }

    private static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException ex) {
            Logger.getLogger(SystemUtils.class.getName()).warning("Can't access the System property " + key + ".");
            return "";
        }
    }

    private static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }

    private static boolean isWindowsXPLafEnabled() {
        return IS_OS_WINDOWS && Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")) && SystemUtils.getSystemProperty("swing.noxp") == null;
    }
}

