/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.application;

import com.jgoodies.application.ActionManager;
import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceManager;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.application.TaskMonitor;
import com.jgoodies.application.TaskService;
import com.jgoodies.common.base.Preconditions;
import java.util.prefs.Preferences;
import javax.swing.ActionMap;

public class DefaultApplicationContext {
    private final Application application;
    private final ResourceManager resourceManager;
    private final ActionManager actionManager;
    private final TaskService taskService;
    private final TaskMonitor taskMonitor;

    public DefaultApplicationContext(Application application, ActionManager actionManager, ResourceManager resourceManager, TaskService taskService) {
        this.application = Preconditions.checkNotNull(application, "The %s must not be null.", "application");
        this.resourceManager = Preconditions.checkNotNull(resourceManager, "The %s must not be null.", "resource manager");
        this.actionManager = Preconditions.checkNotNull(actionManager, "The %s must not be null.", "action manager");
        this.taskService = taskService != null ? taskService : new TaskService("default");
        this.taskMonitor = new TaskMonitor(this.taskService);
    }

    public final TaskService getTaskService() {
        return this.taskService;
    }

    public TaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    final Class<? extends Application> getApplicationClass() {
        return this.application.getClass();
    }

    private Application getApplication() {
        return this.application;
    }

    public final ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public final ResourceMap getResourceMap() {
        return this.getResourceManager().getResourceMap();
    }

    public final ResourceMap getResourceMap(Class<?> type) {
        return this.getResourceManager().getResourceMap(type);
    }

    public final ActionMap createActionMap(Object target) {
        return this.createActionMap(target, null);
    }

    public final ActionMap createActionMap(Object target, ResourceMap resourceMap) {
        Preconditions.checkNotNull(target, "The %s must not be null.", "target");
        return this.actionManager.createActionMap(target, resourceMap);
    }

    public Preferences getUserPreferences() {
        return Preferences.userRoot().node(this.getApplication().getApplicationPreferencesNodeName());
    }

    public Preferences getUserPreferences(Class<?> type) {
        return this.getUserPreferences().node(DefaultApplicationContext.preferencesNodeName(type));
    }

    public Preferences getSystemPreferences() {
        return Preferences.systemRoot().node(this.getApplication().getApplicationPreferencesNodeName());
    }

    public Preferences getSystemPreferences(Class<?> type) {
        return this.getSystemPreferences().node(DefaultApplicationContext.preferencesNodeName(type));
    }

    public static String preferencesNodeName(Class<?> type) {
        Preconditions.checkArgument(!type.isArray(), "Arrays have no associated preferences node name.");
        String className = type.getName();
        return "/" + className.replace('.', '/').toLowerCase();
    }
}

