/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.application;

import com.jgoodies.application.DefaultActionManager;
import com.jgoodies.application.DefaultApplicationContext;
import com.jgoodies.application.DefaultResourceManager;
import com.jgoodies.application.ExitListener;
import com.jgoodies.application.InputBlocker;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.application.Task;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.promise.Promise;
import com.jgoodies.common.promise.Promises;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.common.swing.internal.EDTBean;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public abstract class Application
extends EDTBean {
    public static final String PROPERTY_DEFAULT_INPUT_BLOCKER = "defaultInputBlocker";
    private static final Logger LOGGER = Logger.getLogger(Application.class.getName());
    private static Application application;
    private final DefaultApplicationContext context = this.createContext();
    private final List<ExitListener> exitListeners = new CopyOnWriteArrayList<ExitListener>();
    private InputBlocker defaultInputBlocker;
    private WindowListener applicationShutdownOnWindowClosingHandler;

    protected Application() {
    }

    public static ActionMap createActionMap(Object target) {
        return Application.getInstance().getContext().createActionMap(target);
    }

    public static ResourceMap getResourceMap() {
        return Application.getResourceMap(null);
    }

    public static ResourceMap getResourceMap(Class<?> type) {
        return Application.getInstance().getContext().getResourceMap(type);
    }

    public static void execute(EventObject e, Action action) {
        int modifiers;
        long when;
        Preconditions.checkNotNull(e, "The %s must not be null.", "event object");
        Preconditions.checkNotNull(action, "The %s must not be null.", "action");
        if (!action.isEnabled()) {
            return;
        }
        if (e instanceof InputEvent) {
            InputEvent ie = (InputEvent)e;
            when = ie.getWhen();
            modifiers = ie.getModifiers();
        } else {
            when = 0L;
            modifiers = 0;
        }
        ActionEvent ae = new ActionEvent(e.getSource(), 1001, "execute", when, modifiers);
        action.actionPerformed(ae);
    }

    public static void execute(EventObject e, Task<?, ?> task) {
        task.setEventObject(e);
        Application.execute(task);
    }

    public static void execute(Task<?, ?> task) {
        Application.getInstance().getContext().getTaskService().execute(task);
    }

    public static Application getInstance() {
        Preconditions.checkState(application != null, "The application must be launched before you can obtain the Application, ResourceMaps, and ActionMaps.");
        return application;
    }

    public static boolean hasInstance() {
        return application != null;
    }

    public final DefaultApplicationContext getContext() {
        return this.context;
    }

    protected DefaultApplicationContext createContext() {
        return new DefaultApplicationContext(this, new DefaultActionManager(), new DefaultResourceManager(this.getClass()), null);
    }

    public static synchronized void launch(Class<? extends Application> appClass, String ... args) {
        Runnable runnable = () -> {
            application = null;
            try {
                application = (Application)appClass.newInstance();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
                LOGGER.log(Level.SEVERE, "Can't instantiate " + appClass, e1);
                return;
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
                LOGGER.log(Level.SEVERE, "Illegal Access during launch of " + appClass, e2);
                return;
            }
            try {
                application.startup(args);
                Application application = application;
                application.getClass();
                application.new ReadyOnEmptyEventQueue().execute();
            }
            catch (Exception e3) {
                String message = "Failed to launch " + appClass;
                LOGGER.log(Level.SEVERE, message, e3);
                throw new Error(message, e3);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public static void launchTest() {
        Application.launchTest(new PlaceHolderApplication());
    }

    public static synchronized void launchTest(Application app) {
        application = app;
        app.startup(null);
    }

    protected abstract void startup(String[] var1);

    protected void ready() {
    }

    public Promise<Boolean> exit() {
        return this.exit(new EventObject(JOptionPane.getRootFrame()));
    }

    public Promise<Boolean> exit(EventObject evt) {
        return Application.applicationExiting(evt, this.exitListeners).thenApply(exitAllowed -> {
            if (exitAllowed.booleanValue()) {
                this.fireApplicationExited();
                try {
                    this.shutdown();
                }
                catch (Exception e) {
                    this.handleException(e, "Failed to shutdown the application.", Level.SEVERE);
                }
                finally {
                    this.end();
                }
            }
            return exitAllowed;
        });
    }

    protected void shutdown() {
    }

    protected void end() {
        System.exit(0);
    }

    public final void addExitListener(ExitListener listener) {
        Preconditions.checkNotNull(listener, "The %s must not be null.", "exit listener");
        this.exitListeners.add(listener);
    }

    public final void removeExitListener(ExitListener listener) {
        Preconditions.checkNotNull(listener, "The %s must not be null.", "exit listener");
        this.exitListeners.remove(listener);
    }

    protected final void fireApplicationExited() {
        for (ExitListener listener : this.exitListeners) {
            try {
                listener.applicationExited();
            }
            catch (Exception e) {
                this.handleException(e, "Failed to notify a listener that the application exited.", Level.WARNING);
            }
        }
    }

    public final InputBlocker getDefaultInputBlocker() {
        return this.defaultInputBlocker;
    }

    public final void setDefaultInputBlocker(InputBlocker newDefaultBlocker) {
        InputBlocker oldValue = this.getDefaultInputBlocker();
        this.defaultInputBlocker = newDefaultBlocker;
        this.firePropertyChange(PROPERTY_DEFAULT_INPUT_BLOCKER, oldValue, newDefaultBlocker);
    }

    public final WindowListener getApplicationExitOnWindowClosingHandler() {
        if (this.applicationShutdownOnWindowClosingHandler == null) {
            this.applicationShutdownOnWindowClosingHandler = Listeners.windowClosing(this::onWindowClosing);
        }
        return this.applicationShutdownOnWindowClosingHandler;
    }

    protected void handleException(Throwable t, String message, Level level) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        Logger logger = Logger.getLogger(this.getClass().getName());
        String msg = message != null ? message : "Failure";
        logger.log(level, msg, t);
    }

    protected String getApplicationPreferencesNodeName() {
        return DefaultApplicationContext.preferencesNodeName(this.getContext().getApplicationClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForEmptyEventQueue() {
        JPanel placeHolder = new JPanel();
        boolean queueEmpty = false;
        EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (!queueEmpty) {
            NotifyingEvent e = new NotifyingEvent(placeHolder);
            queue.postEvent(e);
            NotifyingEvent notifyingEvent = e;
            synchronized (notifyingEvent) {
                while (!e.isDispatched()) {
                    try {
                        e.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                queueEmpty = e.isEventQEmpty();
            }
        }
    }

    private static Promise<Boolean> applicationExiting(EventObject evt, List<ExitListener> exitListeners) {
        return Promises.allMatch(exitListeners, listener -> listener.applicationExiting(evt));
    }

    private void onWindowClosing(WindowEvent evt) {
        Application.getInstance().exit(evt);
    }

    private static final class NotifyingEvent
    extends PaintEvent
    implements ActiveEvent {
        private boolean dispatched = false;
        private boolean queueEmpty = false;

        NotifyingEvent(Component c) {
            super(c, 801, null);
        }

        synchronized boolean isDispatched() {
            return this.dispatched;
        }

        synchronized boolean isEventQEmpty() {
            return this.queueEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() {
            EventQueue q = Toolkit.getDefaultToolkit().getSystemEventQueue();
            NotifyingEvent notifyingEvent = this;
            synchronized (notifyingEvent) {
                this.queueEmpty = q.peekEvent() == null;
                this.dispatched = true;
                this.notifyAll();
            }
        }
    }

    private static final class PlaceHolderApplication
    extends Application {
        private PlaceHolderApplication() {
        }

        @Override
        protected void startup(String[] args) {
        }

        @Override
        protected void end() {
        }
    }

    private final class ReadyOnEmptyEventQueue
    extends SwingWorker<Void, Void> {
        private ReadyOnEmptyEventQueue() {
        }

        @Override
        protected Void doInBackground() {
            Application.waitForEmptyEventQueue();
            return null;
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (InterruptedException e) {
                Application.this.handleException(e, "Waiting for empty event queue interrupted.", Level.SEVERE);
            }
            catch (ExecutionException e) {
                Application.this.handleException(e.getCause(), "Error while waiting for an empty event queue.", Level.SEVERE);
            }
            Application.this.ready();
        }
    }
}

