/**************************************************************************
 **SA Network Connection Profiler [sancp] - A TCP/IP statistical/collection tool
 * ************************************************************************
 * * Copyright (C) 2003 John Curry <john.curry@metre.net>
 * *
 * * This program is distributed under the terms of version 1.0 of the
 * * Q Public License.  See LICENSE.QPL for further details.
 * *
 * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * *
 * ***********************************************************************/

#include <unistd.h>	// setuid(), setgid()
#include <pcap.h>	// libpcap

#define PROMISC 1
#define MAX_VAR 80
#define READ_TIMEOUT 500
#define ETHPROTO_IP  0x0008

// network order bytes 0x0806
#define ETHPROTO_ARP  0x0608

// network order bytes 0x8035
#define ETHPROTO_RARP  0x3580

#define ETHPROTO_8021Q  0x0081

//void Record_Raw_Pcap(u_char *,int);

//void Handle_Packet(u_char *,int);

void erase_idle();

void ProcessMyPacket(char *user, struct pcap_pkthdr * pkthdr, u_char * pkt);

void close_pcap_file(pcap_t *);

pcap_t * open_pcap_file(char *,char *);

pcap_t * open_pcap_live(char *,char *);

void start_pcap_loop(pcap_t *);

int apply_filter(pcap_t *ph, char *filename, int optimize, bpf_u_int32 netmask );
