---
myst:
  html_meta:
    keywords: LaTeX, FAQ
# sd_hide_title: true
---

# La FAQ LaTeX francophone !


:::::::{only} html
::::::{div} landing-title
:style: "padding: 0.1rem 0.5rem 0.6rem 0; background-image: linear-gradient(315deg, #86a4c6 0%, #98b2ce 74%); clip-path: polygon(0px 0px, 100% 0%, 100% 100%, 0% calc(100% - 1.5rem)); -webkit-clip-path: polygon(0px 0px, 100% 0%, 100% 100%, 0% calc(100% - 1.5rem));"

::::{grid}
:reverse:
:gutter: 2 3 3 3
:margin: 4 4 1 2

:::{grid-item}
:columns: 12 4 4 4


````{only} not latex
```{image} ./_static/logoFAQ-dark-theme.svg
:width: 200px
:class: sd-m-auto sd-animate-grow50-rot20 only-dark
```
```{image} ./_static/logoFAQ-dark-theme.svg
:width: 200px
:class: sd-m-auto sd-animate-grow50-rot20 only-light
```
````
````{only} latex
```{image} ./_static/logoFAQ-dark-theme.png
:width: 200px
````
:::

:::{grid-item}
:columns: 12 8 8 8
:child-align: justify
:class: sd-text-white sd-fs-3

Tout ce que vous avez toujours voulu savoir
sur TeX, LaTeX et outils associés !

```{button-ref} /7_cette_faq/fonctionnement/comment_lire_la_faq
:ref-type: doc
:outline:
:color: white
:class: sd-px-4 sd-fs-5

Commencez maintenant !
```

:::
::::

::::::
:::::::

```{toctree}
:glob: true
:hidden: true
:maxdepth: 1

*/start
```

```{raw} latex
% Voir \sphinxtableofcontentshook dans le préambule.
% Il vaut mieux garder les titres de sections ici en synchronisation
% avec ce qui est mis dans \sphinxtableofcontentshook mais ce n'est
% pas strictement nécessaire.
\begin{faqGUTnonprotectedfilecontents}[overwrite,nowarn]{\jobname-intro.latex}
```

:::{note}
La présente foire aux questions (FAQ), a pour but de permettre de répondre aux
questions sur LaTeX les plus fréquemment posées.
:::

:::{hint}
```{only} latex
Vous pouvez également [la trouver sous forme de site Web
statique](https://faq.gutenberg-asso.fr/)
(avec moteur de recherche intégré).
```
```{only} html
Vous pouvez également la trouver en deux versions PDF (un peu
moins à jour que la présente version en ligne et assez volumineuses), avec codes
LaTeX en modes respectivement :

1. [<i class="fa-solid fa-file-pdf"></i> clair](https://www.gutenberg-asso.fr/IMG/pdf/faqlatexgutenberg.pdf.pdf) ;
2. [<i class="fa-solid fa-file-pdf"></i> sombre](https://www.gutenberg-asso.fr/IMG/pdf/faqlatexgutenberg_sombre.pdf.pdf).
```
:::

## Les questions

Le contenu de cette FAQ est classé en grandes thématiques pour permettre
une meilleure navigation.

````{only} not latex
::::{grid} 1 2 2 3

:::{grid-item-card}
:link: 1_generalites/start.html
<i class="fa-solid fa-compass"></i> Généralités
^^^
Bases, documentation, histoire de TeX et LaTeX, notions de typographie, etc.
:::

:::{grid-item-card}
:link: 2_programmation/start.html
<i class="fa-solid fa-code"></i> Programmation
^^^
Compilation, encodage, message d’erreur, extensions, packages, classes,
commandes et environnements, syntaxe, etc.
:::

:::{grid-item-card}
:link: 3_composition/start.html
<i class="fa-solid fa-pen-to-square"></i> Composition de documents
^^^
Documents, flottants, illustrations, langues, tableaux, textes, annexes, etc.
:::


:::{grid-item-card}
:link: 4_domaines_specialises/start.html
<i class="fa-solid fa-flask"></i> Domaines spécialisés
^^^
Biologie, chimie, factures, thèses, posters, articles, lettres, CV, diaporama,
cuisine, électricité, enseignement, jeux (échecs, go, cartes...),
mathématiques, musique, physique, sciences humaines, etc.
:::

:::{grid-item-card}
:link: 5_fichiers/start.html
<i class="fa-solid fa-file"></i> Fichiers utilisés
^^^
Fontes, formats, PDF, PostScript, DVI, conversions, langage WEB, XML, TDS, etc.
:::

:::{grid-item-card}
:link: 6_distributions/start.html
<i class="fa-solid fa-gears"></i> Logiciels et distributions
^^^
CTAN, distributions, visualisateurs, éditeurs LaTeX, logiciels compagnons,
logiciels de conversion, etc.
:::

:::{grid-item-card}
:link: 7_cette_faq/start.html
<i class="fa-solid fa-circle-info"></i> Cette FAQ
^^^
Fonctionnement, description, historique, etc.
:::

:::{grid-item-card}
:link: 8_contribuer/start.html
<i class="fa-solid fa-handshake-simple"></i> Contribuer
^^^
Tout savoir pour contribuer à la présente FAQ.
:::

<div class="sd-col sd-d-flex-row docutils">
    <div class="sd-card sd-sphinx-override sd-w-100 sd-shadow-sm sd-card-hover
        docutils" id="random-page">
        <div class="sd-card-header docutils">
            <p class="sd-card-text">
                <i class="fa fa-dice"></i> Une page au hasard ?
            </p>
        </div>
        <div class="sd-card-body docutils">
            <p class="sd-card-text">Consultez et, le cas échéant, contribuez à une
                page au hasard
            </p>
        </div>
        <script id="random_page_js" card_link="sd-stretched-link reference
    external" link_text="" relative_path= "." src="./_static/js/random_page.js"></script>
    </div>
</div>

::::
````

````{only} latex
[Généralités](/1_generalites/start)
:  Bases, documentation, histoire de TeX et LaTeX, notions de typographie, etc.

[Programmation](/2_programmation/start)
:  Compilation, encodage, message d’erreur, extensions, packages, classes,
commandes et environnements, syntaxe, etc.

[Composition de documents](/3_composition/start)
:  Documents, flottants, illustrations, langues, tableaux, textes, annexes, etc.

[Domaines spécialisés](/4_domaines_specialises/start)
:   Biologie, chimie, factures, thèses, posters, articles, lettres, CV, diaporama,
cuisine, électricité, enseignement, jeux (échecs, go, cartes...),
mathématiques, musique, physique, sciences humaines, etc.

[Fichiers utilisés](/5_fichiers/start)
:  Fontes, formats, PDF, PostScript, DVI, conversions, langage WEB, XML, TDS, etc.

[Logiciels et distributions](/6_distributions/start)
:   CTAN, distributions, visualisateurs, éditeurs LaTeX, logiciels compagnons,
logiciels de conversion, etc.

[Cette FAQ](/7_cette_faq/start)
:  Fonctionnement, description, historique, etc.

[Contribuer](/8_contribuer/start)
:  Tout savoir pour contribuer à la présente FAQ.
````

Pour avoir un descriptif de la philosophie générale du contenu de la FAQ,
référez-vous à la page dédiée : [que contient cette FAQ ?](/7_cette_faq/fonctionnement/que_contient_cette_faq)

## Ressources

Besoin d'autres sources d'information ? Lisez [la bibliographie TeX/LaTeX du
site de l'association
GUTenberg](https://www.gutenberg-asso.fr/-Gerbe-de-liens-), ou [abonnez-vous
à la liste GUT](https://www.gutenberg-asso.fr/listes).

Vous pouvez également poser vos questions sur les sites
[TeXnique.fr](https://www.texnique.fr/osqa/) ou, en anglais,
[TeX.StackExchange](https://tex.stackexchange.com/) ainsi que
[LaTeX.org](https://latex.org/forum/), et revenir contribuer à cette FAQ avec
les réponses les plus pertinentes !

## Ce site

Ce site est en développement. Si vous rencontrez un problème, si vous avez des
questions ou des suggestions, [merci de contacter l'association
GUTenberg](mailto:faq@gutenberg-asso.fr), qui vous répondra.

L’[association GUTenberg](https://www.gutenberg-asso.fr/) est le groupe
francophone d'utilisateurs de TeX, LaTeX et logiciels compagnons. Elle publie la
présente FAQ (qui est mise à jour
[quotidiennement](https://gitlab.gutenberg-asso.fr/gutenberg/faq-gut/-/commits/main?ref_type=heads))
et, comme en atteste son site internet, propose de nombreuses activités et
publications en rapport avec ces logiciels.


## Participer

Cette FAQ est contributive. Elle rassemble le contenu de [trois précédentes
FAQ](/7_cette_faq/historique/sources_et_contributeurs).  Vous pouvez nous aider
à l'améliorer en :

- corrigeant les imperfections et éventuelles erreurs, certaines pages 
  [attendant des corrections](/8_contribuer/corrections/questions_a_reviser) ;
- mettant à jour des informations parfois datées ;
- ajoutant ou précisant des réponses aux questions ;
- créant de nouvelles pages pour partager votre expérience avec LaTeX.

La page [comment contribuer](/8_contribuer/methodes/comment_contribuer_a_la_faq) explique comment procéder.

```{raw} latex
\end{faqGUTnonprotectedfilecontents}
```
