/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.entityresolver;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.help.internal.HelpPlugin;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class LocalEntityResolver
implements EntityResolver {
    private LocalEntityResolver() {
    }

    public static InputSource resolve(String publicId, String systemId) throws IOException {
        InputStream stream;
        String dtdPath;
        Bundle helpBundle;
        URL dtdURL;
        int index = systemId.lastIndexOf("/");
        if (index >= 0 && (dtdURL = FileLocator.find((Bundle)(helpBundle = HelpPlugin.getDefault().getBundle()), (IPath)IPath.fromOSString((String)(dtdPath = "dtds/internal" + systemId.substring(index))), null)) != null && (stream = dtdURL.openStream()) != null) {
            InputSource is = new InputSource(stream);
            is.setSystemId(systemId);
            is.setPublicId(publicId);
            return is;
        }
        return new InputSource(new StringReader(""));
    }

    @Override
    public final InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return LocalEntityResolver.resolve(publicId, systemId);
    }

    private static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new LocalEntityResolver());
        return documentBuilder;
    }

    public static Document parse(InputSource is) throws SAXException, IOException, ParserConfigurationException {
        return LocalEntityResolver.createDocumentBuilder().parse(is);
    }

    public static Document parse(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        return LocalEntityResolver.createDocumentBuilder().parse(is);
    }

    public static Document parse(String content) throws SAXException, IOException, ParserConfigurationException {
        StringReader reader = new StringReader(content);
        return LocalEntityResolver.createDocumentBuilder().parse(new InputSource(reader));
    }

    public static Document newDocument() throws ParserConfigurationException {
        return LocalEntityResolver.createDocumentBuilder().newDocument();
    }
}

