/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.handles;

import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.graphics.Cursor;

public class NonResizableHandleKit {
    public static void addCornerHandles(GraphicalEditPart part, List<Handle> handles, DragTracker tracker, Cursor cursor) {
        handles.add(NonResizableHandleKit.createHandle(part, 20, tracker, cursor));
        handles.add(NonResizableHandleKit.createHandle(part, 12, tracker, cursor));
        handles.add(NonResizableHandleKit.createHandle(part, 9, tracker, cursor));
        handles.add(NonResizableHandleKit.createHandle(part, 17, tracker, cursor));
    }

    public static void addCornerHandles(GraphicalEditPart part, List<Handle> handles) {
        handles.add(NonResizableHandleKit.createHandle(part, 20));
        handles.add(NonResizableHandleKit.createHandle(part, 12));
        handles.add(NonResizableHandleKit.createHandle(part, 9));
        handles.add(NonResizableHandleKit.createHandle(part, 17));
    }

    public static void addHandle(GraphicalEditPart part, List<Handle> handles, int direction) {
        handles.add(NonResizableHandleKit.createHandle(part, direction));
    }

    public static void addHandle(GraphicalEditPart part, List<Handle> handles, int direction, DragTracker tracker, Cursor cursor) {
        handles.add(NonResizableHandleKit.createHandle(part, direction, tracker, cursor));
    }

    @Deprecated
    public static void addHandles(GraphicalEditPart part, List<Handle> handles) {
        NonResizableHandleKit.addMoveHandle(part, handles);
        NonResizableHandleKit.addCornerHandles(part, handles);
    }

    @Deprecated
    public static void addHandles(GraphicalEditPart part, List<Handle> handles, DragTracker tracker, Cursor cursor) {
        NonResizableHandleKit.addMoveHandle(part, handles, tracker, cursor);
        NonResizableHandleKit.addCornerHandles(part, handles, tracker, cursor);
    }

    public static void addMoveHandle(GraphicalEditPart f, List<Handle> handles) {
        handles.add(NonResizableHandleKit.moveHandle(f));
    }

    public static void addMoveHandle(GraphicalEditPart f, List<Handle> handles, DragTracker tracker, Cursor cursor) {
        handles.add(NonResizableHandleKit.moveHandle(f, tracker, cursor));
    }

    static Handle createHandle(GraphicalEditPart owner, int direction) {
        ResizeHandle handle = new ResizeHandle(owner, direction);
        handle.setCursor(Cursors.SIZEALL);
        handle.setDragTracker(new DragEditPartsTracker(owner));
        return handle;
    }

    static Handle createHandle(GraphicalEditPart owner, int direction, DragTracker tracker, Cursor cursor) {
        ResizeHandle handle = new ResizeHandle(owner, direction);
        handle.setCursor(cursor);
        handle.setDragTracker(tracker);
        return handle;
    }

    public static Handle moveHandle(GraphicalEditPart owner) {
        return new MoveHandle(owner);
    }

    public static Handle moveHandle(GraphicalEditPart owner, DragTracker tracker, Cursor cursor) {
        MoveHandle moveHandle = new MoveHandle(owner);
        moveHandle.setDragTracker(tracker);
        moveHandle.setCursor(cursor);
        return moveHandle;
    }

    private NonResizableHandleKit() {
        throw new UnsupportedOperationException("Helper class should not be instantiated!");
    }
}

