// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package v2alpha1

import (
	"context"
	"time"

	v2alpha1 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2alpha1"
	scheme "github.com/cilium/cilium/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CiliumBGPClusterConfigsGetter has a method to return a CiliumBGPClusterConfigInterface.
// A group's client should implement this interface.
type CiliumBGPClusterConfigsGetter interface {
	CiliumBGPClusterConfigs() CiliumBGPClusterConfigInterface
}

// CiliumBGPClusterConfigInterface has methods to work with CiliumBGPClusterConfig resources.
type CiliumBGPClusterConfigInterface interface {
	Create(ctx context.Context, ciliumBGPClusterConfig *v2alpha1.CiliumBGPClusterConfig, opts v1.CreateOptions) (*v2alpha1.CiliumBGPClusterConfig, error)
	Update(ctx context.Context, ciliumBGPClusterConfig *v2alpha1.CiliumBGPClusterConfig, opts v1.UpdateOptions) (*v2alpha1.CiliumBGPClusterConfig, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2alpha1.CiliumBGPClusterConfig, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2alpha1.CiliumBGPClusterConfigList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumBGPClusterConfig, err error)
	CiliumBGPClusterConfigExpansion
}

// ciliumBGPClusterConfigs implements CiliumBGPClusterConfigInterface
type ciliumBGPClusterConfigs struct {
	client rest.Interface
}

// newCiliumBGPClusterConfigs returns a CiliumBGPClusterConfigs
func newCiliumBGPClusterConfigs(c *CiliumV2alpha1Client) *ciliumBGPClusterConfigs {
	return &ciliumBGPClusterConfigs{
		client: c.RESTClient(),
	}
}

// Get takes name of the ciliumBGPClusterConfig, and returns the corresponding ciliumBGPClusterConfig object, and an error if there is any.
func (c *ciliumBGPClusterConfigs) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2alpha1.CiliumBGPClusterConfig, err error) {
	result = &v2alpha1.CiliumBGPClusterConfig{}
	err = c.client.Get().
		Resource("ciliumbgpclusterconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CiliumBGPClusterConfigs that match those selectors.
func (c *ciliumBGPClusterConfigs) List(ctx context.Context, opts v1.ListOptions) (result *v2alpha1.CiliumBGPClusterConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v2alpha1.CiliumBGPClusterConfigList{}
	err = c.client.Get().
		Resource("ciliumbgpclusterconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ciliumBGPClusterConfigs.
func (c *ciliumBGPClusterConfigs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("ciliumbgpclusterconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ciliumBGPClusterConfig and creates it.  Returns the server's representation of the ciliumBGPClusterConfig, and an error, if there is any.
func (c *ciliumBGPClusterConfigs) Create(ctx context.Context, ciliumBGPClusterConfig *v2alpha1.CiliumBGPClusterConfig, opts v1.CreateOptions) (result *v2alpha1.CiliumBGPClusterConfig, err error) {
	result = &v2alpha1.CiliumBGPClusterConfig{}
	err = c.client.Post().
		Resource("ciliumbgpclusterconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumBGPClusterConfig).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ciliumBGPClusterConfig and updates it. Returns the server's representation of the ciliumBGPClusterConfig, and an error, if there is any.
func (c *ciliumBGPClusterConfigs) Update(ctx context.Context, ciliumBGPClusterConfig *v2alpha1.CiliumBGPClusterConfig, opts v1.UpdateOptions) (result *v2alpha1.CiliumBGPClusterConfig, err error) {
	result = &v2alpha1.CiliumBGPClusterConfig{}
	err = c.client.Put().
		Resource("ciliumbgpclusterconfigs").
		Name(ciliumBGPClusterConfig.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumBGPClusterConfig).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ciliumBGPClusterConfig and deletes it. Returns an error if one occurs.
func (c *ciliumBGPClusterConfigs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("ciliumbgpclusterconfigs").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ciliumBGPClusterConfigs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("ciliumbgpclusterconfigs").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ciliumBGPClusterConfig.
func (c *ciliumBGPClusterConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumBGPClusterConfig, err error) {
	result = &v2alpha1.CiliumBGPClusterConfig{}
	err = c.client.Patch(pt).
		Resource("ciliumbgpclusterconfigs").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
