/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.nullanalysis.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

public final class Enums {
    @Nullable
    private static Enum<?>[] cache;

    private Enums() {
    }

    public static Collection<Integer> ordinals(Collection<? extends Enum<?>> enumSet) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Enum<?> e : enumSet) {
            result.add(e.ordinal());
        }
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> enumSetFromString(String s, Class<E> elementType) {
        int i = 0;
        if ((i = Enums.skipWhitespace(s, i)) == s.length()) {
            return EnumSet.noneOf(elementType);
        }
        if (s.charAt(i) != '[') {
            return EnumSet.of(Enums.valueOf(s, elementType));
        }
        if (s.charAt(i = Enums.skipWhitespace(s, i + 1)) == ']') {
            if ((i = Enums.skipWhitespace(s, i + 1)) < s.length()) {
                throw new IllegalArgumentException("Trailing garbage");
            }
            return EnumSet.noneOf(elementType);
        }
        EnumSet<E> result = EnumSet.noneOf(elementType);
        while (true) {
            int j = Enums.scanIdentifier(s, i);
            result.add(Enums.valueOf(s.substring(i, j), elementType));
            i = Enums.skipWhitespace(s, j);
            if (i == s.length()) {
                throw new IllegalArgumentException("Unexpected end-of-input");
            }
            char c = s.charAt(i);
            if (c == ']') {
                if ((i = Enums.skipWhitespace(s, i + 1)) < s.length()) {
                    throw new IllegalArgumentException("Trailing garbage");
                }
                return result;
            }
            if (c != ',') {
                throw new IllegalArgumentException("Unexpected character '" + c + "'");
            }
            i = Enums.skipWhitespace(s, i + 1);
        }
    }

    private static int scanIdentifier(String s, int index) {
        if (index == s.length()) {
            throw new IllegalArgumentException("Uxpected end-of-input");
        }
        if (!Character.isJavaIdentifierStart(s.charAt(index))) {
            throw new IllegalArgumentException("Identifier expected");
        }
        ++index;
        while (index < s.length() && Character.isJavaIdentifierPart(s.charAt(index))) {
            ++index;
        }
        return index;
    }

    private static int skipWhitespace(String s, int index) {
        while (index < s.length() && Character.isWhitespace(s.charAt(index))) {
            ++index;
        }
        return index;
    }

    public static <E extends Enum<E>> E valueOf(String name, Class<E> enumType) {
        for (Enum e : Enums.getEnumConstants(enumType)) {
            if (!name.equals(e.name())) continue;
            return (E)e;
        }
        throw new IllegalArgumentException(name);
    }

    private static <E extends Enum<E>> E[] getEnumConstants(Class<E> enumType) {
        Enum<?>[] cache = Enums.cache;
        if (cache != null && cache[0].getClass() == enumType) {
            Enum<?>[] result = cache;
            return result;
        }
        Enum[] result = (Enum[])enumType.getEnumConstants();
        if (result.length > 0) {
            Enums.cache = result;
        }
        return result;
    }
}

