/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.pattern;

import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Searcher<EX extends Throwable>
implements ConsumerWhichThrows<CharSequence, EX> {
    public static final int DEFAULT_LOOKBEHIND_LIMIT = 10;
    private final Pattern pattern;
    private final ConsumerWhichThrows<? super MatchResult, ? extends EX> matchHandler;
    private final int lookBehindLimit;
    StringBuilder buffer = new StringBuilder();
    int start;
    private int matchCount;
    private int offsetDelta;

    public Searcher(Pattern pattern, ConsumerWhichThrows<? super MatchResult, ? extends EX> matchHandler) {
        this(pattern, matchHandler, 10);
    }

    public Searcher(Pattern pattern, ConsumerWhichThrows<? super MatchResult, ? extends EX> matchHandler, int lookBehindLimit) {
        this.pattern = pattern;
        this.matchHandler = matchHandler;
        this.lookBehindLimit = lookBehindLimit;
    }

    @Override
    public void consume(CharSequence in) throws EX {
        this.buffer.append(in);
        final Matcher m = this.pattern.matcher(this.buffer);
        m.useTransparentBounds(true);
        m.useAnchoringBounds(false);
        MatchResult matchResult = new MatchResult(){

            @Override
            public int start(int group) {
                return m.start(group) + Searcher.this.offsetDelta;
            }

            @Override
            public int start() {
                return m.start() + Searcher.this.offsetDelta;
            }

            @Override
            public int groupCount() {
                return m.groupCount();
            }

            @Override
            public String group(int group) {
                return m.group(group);
            }

            @Override
            public String group() {
                return m.group();
            }

            @Override
            public int end(int group) {
                return m.end(group) + Searcher.this.offsetDelta;
            }

            @Override
            public int end() {
                return m.end() + Searcher.this.offsetDelta;
            }
        };
        while (true) {
            m.region(this.start, this.buffer.length());
            if (m.lookingAt()) {
                if (m.hitEnd()) break;
                this.matchHandler.consume(matchResult);
                ++this.matchCount;
                if (m.end() == m.start()) {
                    ++this.start;
                    continue;
                }
                this.start = m.end();
                continue;
            }
            if (m.hitEnd() || this.start == this.buffer.length()) break;
            ++this.start;
        }
        if (this.start > this.lookBehindLimit) {
            int delta = this.start - this.lookBehindLimit;
            this.buffer.delete(0, delta);
            this.offsetDelta += delta;
            this.start = this.lookBehindLimit;
        }
        if (this.buffer.capacity() > 10 * this.buffer.length()) {
            this.buffer.trimToSize();
        }
    }

    public int matchCount() {
        return this.matchCount;
    }
}

