/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.expression;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.NotNull;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.Scanner;
import de.unkrig.commons.text.parser.AbstractParser;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import de.unkrig.commons.text.scanner.ScannerUtil;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public abstract class Parser<T, EX extends Throwable>
extends AbstractParser<Scanner.TokenType> {
    private final List<String> singleImports = new ArrayList<String>();
    private final List<String> onDemandImports = new ArrayList<String>(Collections.singleton("java.lang"));
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private EnumSet<Extension> extensions = EnumSet.allOf(Extension.class);

    public Parser(ProducerWhichThrows<? extends AbstractScanner.Token<Scanner.TokenType>, ? extends ScanException> tokenProducer) {
        super(tokenProducer);
    }

    public Parser(Reader in) {
        this((ProducerWhichThrows<AbstractScanner.Token<Scanner.TokenType>, ScanException>)ScannerUtil.toDocumentScanner(Scanner.stringScanner(), in));
    }

    public Parser(String expression) {
        this((ProducerWhichThrows<AbstractScanner.Token<Scanner.TokenType>, ScanException>)Scanner.stringScanner().setInput(expression));
    }

    public String[] getSingleImports() {
        return this.singleImports.toArray(new String[this.singleImports.size()]);
    }

    public Parser<T, EX> addSingleImports(String ... singleImports) {
        for (String si : singleImports) {
            this.singleImports.add(si);
        }
        return this;
    }

    public String[] getOnDemandImports() {
        return this.onDemandImports.toArray(new String[this.onDemandImports.size()]);
    }

    public Parser<T, EX> addOnDemandImports(String ... onDemandImports) {
        for (String si : onDemandImports) {
            this.onDemandImports.add(si);
        }
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Parser<T, EX> setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public void setExtensions(Collection<Extension> extensions) {
        this.extensions = extensions.isEmpty() ? EnumSet.noneOf(Extension.class) : EnumSet.copyOf(extensions);
    }

    public void setExtensions(EnumSet<Extension> extensions) {
        this.extensions = EnumSet.copyOf(extensions);
    }

    public void enableExtension(Extension extension) {
        this.extensions.add(extension);
    }

    public void disableExtension(Extension extension) {
        this.extensions.remove((Object)extension);
    }

    public T parse() throws ParseException, EX {
        try {
            this.parseImports();
            T result = this.parseExpression().toValue();
            this.eoi();
            return result;
        }
        catch (ParseException pe) {
            throw ExceptionUtil.wrap("At " + this.scanner.toString(), pe);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.wrap("At " + this.scanner.toString(), re);
        }
        catch (Exception e) {
            Exception ee = e;
            throw ExceptionUtil.wrap("At " + this.scanner.toString(), ee);
        }
    }

    public T parsePart() throws ParseException, EX {
        try {
            this.parseImports();
            return this.parseExpression().toValue();
        }
        catch (ParseException pe) {
            throw ExceptionUtil.wrap("At " + this.scanner.toString(), pe);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.wrap("At " + this.scanner.toString(), re);
        }
        catch (Exception e) {
            Exception ee = e;
            throw ExceptionUtil.wrap("At " + this.scanner.toString(), ee);
        }
    }

    private static <T, E extends Throwable> Atom<T, E> value(final T t) {
        return new Atom<T, E>(){

            @Override
            @NotNull
            public T toValue() {
                return t;
            }

            @Override
            @Nullable
            public Class<?> toType() {
                return null;
            }

            @Override
            @Nullable
            public String toPackage() {
                return null;
            }
        };
    }

    private Atom<T, EX> type(final Class<?> type) {
        return new Atom<T, EX>(){

            @Override
            @NotNull
            public T toValue() throws Throwable, ParseException {
                if (Parser.this.extensions.contains((Object)Extension.NEW_CLASS_WITHOUT_KEYWORD) && Parser.this.extensions.contains((Object)Extension.NEW_CLASS_WITHOUT_PARENTHESES)) {
                    return Parser.this.newClass(type, Collections.emptyList());
                }
                throw new ParseException("'" + type.getName() + "' is a type, not a value");
            }

            @Override
            public Class<?> toType() {
                return type;
            }

            @Override
            @Nullable
            public String toPackage() {
                return null;
            }
        };
    }

    private void parseImports() throws ParseException {
        block4: while (this.peekRead("import")) {
            String qn = this.read(Scanner.TokenType.IDENTIFIER);
            while (true) {
                switch (this.read(";", ".")) {
                    case 0: {
                        this.singleImports.add(qn);
                        continue block4;
                    }
                    case 1: {
                        if (this.peekRead("*")) {
                            this.read(";");
                            this.onDemandImports.add(qn);
                            continue block4;
                        }
                        qn = qn + "." + this.read(Scanner.TokenType.IDENTIFIER);
                    }
                }
            }
        }
    }

    private Atom<T, EX> parseExpression() throws ParseException, EX {
        return this.parseConditional();
    }

    private Atom<T, EX> parseConditional() throws ParseException, EX {
        Atom<T, EX> lhs = this.parseLogicalOr();
        if (!this.peekRead("?")) {
            return lhs;
        }
        T mhs = this.parseLogicalOr().toValue();
        this.read(":");
        T rhs = this.parseConditional().toValue();
        return Parser.value(this.conditional(lhs.toValue(), mhs, rhs));
    }

    private Atom<T, EX> parseLogicalOr() throws ParseException, EX {
        Atom<T, Object> lhs = this.parseLogicalAnd();
        while (this.peekRead("||")) {
            lhs = Parser.value(this.binaryOperation(lhs.toValue(), BinaryOperator.LOGICAL_OR, this.parseLogicalAnd().toValue()));
        }
        return lhs;
    }

    private Atom<T, EX> parseLogicalAnd() throws ParseException, EX {
        Atom<T, Object> lhs = this.parseBitwiseOr();
        while (this.peekRead("&&")) {
            lhs = Parser.value(this.binaryOperation(lhs.toValue(), BinaryOperator.LOGICAL_AND, this.parseBitwiseOr().toValue()));
        }
        return lhs;
    }

    private Atom<T, EX> parseBitwiseOr() throws ParseException, EX {
        Atom<T, Object> lhs = this.parseBitwiseXor();
        while (this.peekRead("|")) {
            lhs = Parser.value(this.binaryOperation(lhs.toValue(), BinaryOperator.BITWISE_OR, this.parseBitwiseXor().toValue()));
        }
        return lhs;
    }

    private Atom<T, EX> parseBitwiseXor() throws ParseException, EX {
        Atom<T, Object> lhs = this.parseBitwiseAnd();
        while (this.peekRead("^")) {
            lhs = Parser.value(this.binaryOperation(lhs.toValue(), BinaryOperator.BITWISE_XOR, this.parseBitwiseAnd().toValue()));
        }
        return lhs;
    }

    private Atom<T, EX> parseBitwiseAnd() throws ParseException, EX {
        Atom<T, Object> lhs = this.parseRelational();
        while (this.peekRead("&")) {
            lhs = Parser.value(this.binaryOperation(lhs.toValue(), BinaryOperator.BITWISE_AND, this.parseRelational().toValue()));
        }
        return lhs;
    }

    private Atom<T, EX> parseRelational() throws ParseException, EX {
        Atom<T, Object> lhs = this.parseShift();
        while (true) {
            if (this.extensions.contains((Object)Extension.OPERATOR_GLOB) && this.peekRead("=*")) {
                lhs = Parser.value(this.binaryOperation(lhs.toValue(), BinaryOperator.GLOB, this.parseRelational().toValue()));
                continue;
            }
            if (this.extensions.contains((Object)Extension.OPERATOR_REGEX) && this.peekRead("=~")) {
                lhs = Parser.value(this.binaryOperation(lhs.toValue(), BinaryOperator.REGEX, this.parseRelational().toValue()));
                continue;
            }
            BinaryOperator operator = (BinaryOperator)this.peekReadEnum(new BinaryOperator[]{BinaryOperator.EQUAL, BinaryOperator.NOT_EQUAL, BinaryOperator.LESS, BinaryOperator.LESS_EQUAL, BinaryOperator.GREATER, BinaryOperator.GREATER_EQUAL});
            if (operator != null) {
                lhs = Parser.value(this.binaryOperation(lhs.toValue(), operator, this.parseRelational().toValue()));
                continue;
            }
            if (!this.peekRead("instanceof")) break;
            lhs = Parser.value(this.instanceoF(lhs.toValue(), this.parseReferenceType()));
        }
        return lhs;
    }

    private Atom<T, EX> parseShift() throws ParseException, EX {
        Atom<T, Object> lhs = this.parseAdditive();
        BinaryOperator op;
        while ((op = (BinaryOperator)this.peekReadEnum(new BinaryOperator[]{BinaryOperator.LEFT_SHIFT, BinaryOperator.RIGHT_SHIFT, BinaryOperator.RIGHT_USHIFT})) != null) {
            lhs = Parser.value(this.binaryOperation(lhs.toValue(), op, this.parseAdditive().toValue()));
        }
        return lhs;
    }

    private Atom<T, EX> parseAdditive() throws ParseException, EX {
        Atom<T, Object> mul = this.parseMultiplicative();
        BinaryOperator op;
        while ((op = (BinaryOperator)this.peekReadEnum(new BinaryOperator[]{BinaryOperator.PLUS, BinaryOperator.MINUS})) != null) {
            mul = Parser.value(this.binaryOperation(mul.toValue(), op, this.parseMultiplicative().toValue()));
        }
        return mul;
    }

    private Atom<T, EX> parseMultiplicative() throws ParseException, EX {
        Atom<T, Object> lhs = this.parseSelector();
        BinaryOperator op;
        while ((op = (BinaryOperator)this.peekReadEnum(new BinaryOperator[]{BinaryOperator.MULTIPLY, BinaryOperator.DIVIDE, BinaryOperator.MODULO})) != null) {
            lhs = Parser.value(this.binaryOperation(lhs.toValue(), op, this.parseSelector().toValue()));
        }
        return lhs;
    }

    private Class<?> parseReferenceType() throws ParseException {
        Class<?> result;
        if (this.peek(Scanner.TokenType.IDENTIFIER) != null) {
            result = this.parseClassOrInterfaceType();
        } else {
            result = this.parsePrimitiveType();
            this.read("[");
            this.read("]");
        }
        while (this.peekRead("[")) {
            this.read("]");
            result = Array.newInstance(result, 0).getClass();
        }
        return result;
    }

    private Class<?> parsePrimitiveType() throws ParseException {
        switch (this.read("boolean", "byte", "short", "int", "long", "char", "float", "double")) {
            case 0: {
                return Boolean.TYPE;
            }
            case 1: {
                return Byte.TYPE;
            }
            case 2: {
                return Short.TYPE;
            }
            case 3: {
                return Integer.TYPE;
            }
            case 4: {
                return Long.TYPE;
            }
            case 5: {
                return Character.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Double.TYPE;
            }
        }
        throw new IllegalStateException();
    }

    private Atom<T, EX> parseSelector() throws ParseException, EX {
        Class<?> clasS;
        List<T> arguments;
        Atom<T, Object> result = this.parsePrimary();
        if (this.extensions.contains((Object)Extension.NEW_CLASS_WITHOUT_KEYWORD) && (arguments = this.parseOptionalArguments()) != null && (clasS = result.toType()) != null) {
            result = Parser.value(this.newClass(clasS, arguments));
        }
        while (true) {
            if (this.peekRead(".")) {
                result = this.parseSelectorRest(result, this.read(Scanner.TokenType.IDENTIFIER));
                continue;
            }
            if (!this.peekRead("[")) break;
            Atom<T, EX> index = this.parseExpression();
            this.read("]");
            result = Parser.value(this.arrayAccess(result.toValue(), index.toValue()));
        }
        return result;
    }

    private Atom<T, EX> parseSelectorRest(final Atom<T, EX> target, final String identifier) throws ParseException, EX {
        Class<?> clasS;
        final List<T> arguments = this.parseOptionalArguments();
        if (arguments != null) {
            Class<?> clasS2;
            String packagE;
            if (this.extensions.contains((Object)Extension.NEW_CLASS_WITHOUT_KEYWORD) && (packagE = target.toPackage()) != null && (clasS2 = this.loadClass(packagE + '.' + identifier)) != null) {
                return new Atom<T, EX>(){

                    @Override
                    @NotNull
                    public T toValue() throws Throwable {
                        return Parser.this.newClass(clasS2, arguments);
                    }

                    @Override
                    public Class<?> toType() {
                        return clasS2;
                    }

                    @Override
                    @Nullable
                    public String toPackage() {
                        return null;
                    }
                };
            }
            Class<?> clasS3 = target.toType();
            if (clasS3 != null) {
                return Parser.value(this.staticMethodInvocation(clasS3, identifier, arguments));
            }
            return Parser.value(this.methodInvocation(target.toValue(), identifier, arguments));
        }
        String packagE = target.toPackage();
        if (packagE != null && (clasS = this.loadClass(packagE + '.' + identifier)) != null) {
            return this.type(clasS);
        }
        Class<?> type = target.toType();
        if (type != null) {
            Class<?> nestedType = this.loadClass(type.getName() + '$' + identifier);
            if (nestedType != null) {
                return this.type(nestedType);
            }
            return Parser.value(this.staticFieldReference(type, identifier));
        }
        return new Atom<T, EX>(){

            @Override
            @NotNull
            public T toValue() throws Throwable, ParseException {
                return Parser.this.fieldReference(target.toValue(), identifier);
            }

            @Override
            @Nullable
            public Class<?> toType() {
                return null;
            }

            @Override
            @Nullable
            public String toPackage() {
                String packagE = target.toPackage();
                return packagE == null ? null : packagE + '.' + identifier;
            }
        };
    }

    private Atom<T, EX> parsePrimary() throws ParseException, EX {
        if (this.peekRead("(")) {
            Atom<T, EX> result = this.parseExpression();
            this.read(")");
            if (this.peek(new Object[]{"~", "!", "(", Scanner.TokenType.IDENTIFIER, "this", "new", Scanner.TokenType.INTEGER_LITERAL, Scanner.TokenType.CHARACTER_LITERAL, Scanner.TokenType.STRING_LITERAL, Scanner.TokenType.FLOATING_POINT_LITERAL}) != -1) {
                Class<?> type = result.toType();
                if (type == null) {
                    throw new ParseException("'" + type + "' does not pose a type");
                }
                return Parser.value(this.cast(type, this.parsePrimary().toValue()));
            }
            return Parser.value(this.parenthesized(result.toValue()));
        }
        UnaryOperator operator = (UnaryOperator)this.peekReadEnum(new UnaryOperator[]{UnaryOperator.LOGICAL_COMPLEMENT, UnaryOperator.MINUS, UnaryOperator.BITWISE_COMPLEMENT});
        if (operator != null) {
            if (operator == UnaryOperator.MINUS && this.peek(Scanner.TokenType.INTEGER_LITERAL) != null) {
                try {
                    return Parser.value(this.literal(Scanner.decodeIntegerLiteral('-' + this.read().text)));
                }
                catch (ScanException se) {
                    throw ExceptionUtil.wrap(null, se, ParseException.class);
                }
            }
            return Parser.value(this.unaryOperation(operator, this.parseSelector().toValue()));
        }
        if (this.peek(Scanner.TokenType.CHARACTER_LITERAL) != null) {
            try {
                return Parser.value(this.literal(Scanner.decodeCharacterLiteral(this.read().text)));
            }
            catch (ScanException se) {
                throw ExceptionUtil.wrap(null, se, ParseException.class);
            }
        }
        if (this.peek(Scanner.TokenType.STRING_LITERAL) != null) {
            try {
                return Parser.value(this.literal(Scanner.decodeStringLiteral(this.read().text)));
            }
            catch (ScanException se) {
                throw ExceptionUtil.wrap(null, se, ParseException.class);
            }
        }
        if (this.peek(Scanner.TokenType.INTEGER_LITERAL) != null) {
            try {
                return Parser.value(this.literal(Scanner.decodeIntegerLiteral(this.read().text)));
            }
            catch (ScanException se) {
                throw ExceptionUtil.wrap(null, se, ParseException.class);
            }
        }
        if (this.peek(Scanner.TokenType.FLOATING_POINT_LITERAL) != null) {
            return Parser.value(this.literal(Scanner.decodeFloatingPointLiteral(this.read().text)));
        }
        if (this.peekRead("true")) {
            return Parser.value(this.literal(true));
        }
        if (this.peekRead("false")) {
            return Parser.value(this.literal(false));
        }
        if (this.peekRead("null")) {
            return Parser.value(this.literal(null));
        }
        if (this.peekRead("new")) {
            if (this.peek(Scanner.TokenType.IDENTIFIER) == null) {
                return Parser.value(this.parseNewArrayRest(this.parsePrimitiveType()));
            }
            Class<?> clasS = this.parseClassOrInterfaceType();
            if (this.peek("[")) {
                return Parser.value(this.parseNewArrayRest(clasS));
            }
            List<T> arguments = this.parseOptionalArguments();
            if (arguments == null) {
                if (this.extensions.contains((Object)Extension.NEW_CLASS_WITHOUT_PARENTHESES)) {
                    arguments = Collections.emptyList();
                } else {
                    throw new ParseException("Opening parenthesis expected");
                }
            }
            return Parser.value(this.newClass(clasS, arguments));
        }
        final String identifier = this.peekRead(Scanner.TokenType.IDENTIFIER);
        if (identifier != null) {
            Class<?> clasS = this.loadImportedClass(identifier);
            if (clasS != null) {
                return this.type(clasS);
            }
            return new Atom<T, EX>(){

                @Override
                @NotNull
                public T toValue() throws Throwable, ParseException {
                    return Parser.this.variableReference(identifier);
                }

                @Override
                @Nullable
                public Class<?> toType() {
                    return null;
                }

                @Override
                public String toPackage() {
                    return identifier;
                }
            };
        }
        throw new ParseException("Primary expected instead of '" + this.peek() + "'");
    }

    private T parseNewArrayRest(Class<?> clasS) throws ParseException, EX {
        ArrayList<T> dimensions = new ArrayList<T>();
        this.read("[");
        dimensions.add(this.parseExpression().toValue());
        this.read("]");
        while (this.peekRead("[")) {
            if (this.peekRead("]")) {
                clasS = Array.newInstance(clasS, 0).getClass();
                while (this.peekRead("[")) {
                    this.read("]");
                    clasS = Array.newInstance(clasS, 0).getClass();
                }
                break;
            }
            dimensions.add(this.parseExpression().toValue());
            this.read("]");
        }
        return (T)this.newArray(clasS, dimensions);
    }

    private Class<?> parseClassOrInterfaceType() throws ParseException {
        String identifier = this.read(Scanner.TokenType.IDENTIFIER);
        Class<?> importedClass = this.loadImportedClass(identifier);
        if (importedClass != null) {
            return importedClass;
        }
        String qualifiedClassName = identifier;
        Class<?> clasS;
        while ((clasS = this.loadClass(qualifiedClassName)) == null) {
            if (!this.peekRead(".")) {
                throw new ParseException("Cannot load \"" + qualifiedClassName + "\"");
            }
            qualifiedClassName = qualifiedClassName + '.' + this.read(Scanner.TokenType.IDENTIFIER);
        }
        return clasS;
    }

    @Nullable
    private List<T> parseOptionalArguments() throws ParseException, EX {
        if (!this.peekRead("(")) {
            return null;
        }
        if (this.peekRead(")")) {
            return Collections.emptyList();
        }
        ArrayList<T> arguments = new ArrayList<T>();
        do {
            arguments.add(this.parseExpression().toValue());
        } while (this.peekRead(","));
        this.read(")");
        return arguments;
    }

    protected abstract T conditional(T var1, T var2, T var3) throws EX;

    protected abstract T unaryOperation(UnaryOperator var1, T var2) throws EX;

    protected abstract T binaryOperation(T var1, BinaryOperator var2, T var3) throws EX;

    protected abstract T fieldReference(T var1, String var2) throws EX;

    protected abstract T staticFieldReference(Class<?> var1, String var2) throws EX;

    protected abstract T methodInvocation(T var1, String var2, List<T> var3) throws EX;

    protected abstract T staticMethodInvocation(Class<?> var1, String var2, List<T> var3) throws EX;

    protected abstract T variableReference(String var1) throws EX, ParseException;

    protected abstract T literal(@Nullable Object var1) throws EX;

    protected abstract T parenthesized(T var1) throws EX;

    protected abstract T instanceoF(T var1, Class<?> var2) throws EX;

    protected abstract T newClass(Class<?> var1, List<T> var2) throws EX;

    protected abstract T newArray(Class<?> var1, List<T> var2) throws EX;

    protected abstract T cast(Class<?> var1, T var2) throws EX, ParseException;

    protected abstract T arrayAccess(T var1, T var2) throws EX;

    @Nullable
    private Class<?> loadImportedClass(String simpleClassName) {
        Class<?> clasS;
        for (String si : this.singleImports) {
            if (!si.endsWith("." + simpleClassName) || (clasS = this.loadClass(si)) == null) continue;
            return clasS;
        }
        for (String iod : this.onDemandImports) {
            clasS = this.loadClass(iod + '.' + simpleClassName);
            if (clasS == null) continue;
            return clasS;
        }
        return null;
    }

    @Nullable
    private Class<?> loadClass(String qualifiedClassName) {
        try {
            return this.classLoader.loadClass(qualifiedClassName);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    static interface Atom<T, E extends Throwable> {
        public T toValue() throws E, ParseException;

        @Nullable
        public Class<?> toType();

        @Nullable
        public String toPackage();
    }

    public static enum Extension {
        NEW_CLASS_WITHOUT_KEYWORD,
        NEW_CLASS_WITHOUT_PARENTHESES,
        OPERATOR_GLOB,
        OPERATOR_REGEX;

    }

    public static enum BinaryOperator {
        EQUAL("=="),
        GLOB("=*"),
        REGEX("=~"),
        NOT_EQUAL("!="),
        LESS("<"),
        LESS_EQUAL("<="),
        GREATER(">"),
        GREATER_EQUAL(">="),
        PLUS("+"),
        MINUS("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        MODULO("%"),
        LOGICAL_OR("||"),
        LOGICAL_AND("&&"),
        BITWISE_OR("|"),
        BITWISE_XOR("^"),
        BITWISE_AND("&"),
        LEFT_SHIFT("<<"),
        RIGHT_SHIFT(">>"),
        RIGHT_USHIFT(">>>");

        private final String text;

        private BinaryOperator(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum UnaryOperator {
        MINUS("-"),
        LOGICAL_COMPLEMENT("!"),
        BITWISE_COMPLEMENT("~");

        private final String text;

        private UnaryOperator(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

