/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.expression;

import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Mappings;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.AbstractExpression;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.Expression;
import de.unkrig.commons.text.expression.ExpressionEvaluator;
import de.unkrig.commons.text.expression.Scanner;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import de.unkrig.commons.text.scanner.StringScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static Expression constantExpression(@Nullable Object value) {
        if (Boolean.TRUE.equals(value)) {
            return Expression.TRUE;
        }
        if (Boolean.FALSE.equals(value)) {
            return Expression.FALSE;
        }
        if (value == null) {
            return Expression.NULL;
        }
        return ExpressionUtil.constantExpression2(value);
    }

    static Expression constantExpression2(final @Nullable Object value) {
        return new AbstractExpression(){

            @Override
            @Nullable
            public Object evaluate(Mapping<String, ?> variables) {
                return value;
            }

            public String toString() {
                return value instanceof String ? "\"" + value + '\"' : (value instanceof Character ? "'" + value + '\'' : (value instanceof Long ? value + "L" : (value instanceof Float ? value + "F" : (value instanceof Double ? value + "D" : String.valueOf(value)))));
            }
        };
    }

    private static Expression concat(final List<Expression> expressions) {
        if (expressions.size() == 1) {
            return expressions.get(0);
        }
        return new AbstractExpression(){

            @Override
            public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                StringBuilder sb = new StringBuilder();
                for (Expression expression : expressions) {
                    sb.append(expression.evaluate(variables));
                }
                return sb.toString();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                for (Expression expression : expressions) {
                    sb.append('#').append(expression).append('#');
                }
                return sb.toString();
            }
        };
    }

    public static Expression expand(String s, String ... variableNames) throws ParseException {
        return ExpressionUtil.expand(s, new HashSet<String>(Arrays.asList(variableNames)));
    }

    public static Expression expand(String s, Set<String> variableNames) throws ParseException {
        return ExpressionUtil.expand(s, PredicateUtil.contains(variableNames));
    }

    public static Expression expand(String s, Predicate<? super String> isValidVariableName) throws ParseException {
        int idx = s.indexOf(35);
        if (idx == -1) {
            return ExpressionUtil.constantExpression(s);
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (idx != 0) {
            expressions.add(ExpressionUtil.constantExpression(s.substring(0, idx)));
        }
        while (true) {
            final String input = s.substring(idx + 1);
            final StringScanner<Scanner.TokenType> stringScanner = Scanner.stringScanner().setInput(input);
            Expression exp = new ExpressionEvaluator(isValidVariableName).parse((ProducerWhichThrows<? extends AbstractScanner.Token<Scanner.TokenType>, ? extends ScanException>)new ProducerWhichThrows<AbstractScanner.Token<Scanner.TokenType>, ScanException>(){

                @Override
                @Nullable
                public AbstractScanner.Token<Scanner.TokenType> produce() throws ScanException {
                    if (input.charAt(stringScanner.getOffset()) == '#') {
                        return null;
                    }
                    return stringScanner.produce();
                }

                @Override
                @Nullable
                public String toString() {
                    return stringScanner.toString();
                }
            });
            expressions.add(exp);
            if ((idx += 1 + stringScanner.getOffset() + 1) >= s.length()) break;
            int idx2 = s.indexOf(35, idx);
            if (idx2 == -1) {
                expressions.add(ExpressionUtil.constantExpression(s.substring(idx)));
                break;
            }
            expressions.add(ExpressionUtil.constantExpression(s.substring(idx, idx2)));
            idx = idx2;
        }
        return ExpressionUtil.concat(expressions);
    }

    public static String evaluateLeniently(Expression expression, Mapping<String, ?> variables) {
        try {
            return String.valueOf(expression.evaluate(variables));
        }
        catch (EvaluationException ee) {
            return "<!-- " + ee.getMessage() + " -->";
        }
        catch (Exception e) {
            return "<!-- Evaluating '" + expression + "': " + e + " -->";
        }
    }

    public static String evaluateLeniently(Expression expression, Object ... variableNamesAndValues) {
        return ExpressionUtil.evaluateLeniently(expression, Mappings.mapping(variableNamesAndValues));
    }

    @Nullable
    public static <T> T evaluateTo(Expression expression, Class<T> targetClass, Mapping<String, ?> variables) throws EvaluationException {
        return ExpressionEvaluator.to(expression.evaluate(variables), targetClass);
    }

    @Nullable
    public static <T> T evaluateTo(Expression expression, Class<T> targetClass, Object ... variableNamesAndValues) throws EvaluationException {
        return ExpressionEvaluator.to(expression.evaluate(variableNamesAndValues), targetClass);
    }

    @Nullable
    public static <T> T evaluateExpressionTo(@Nullable String[] onDemandImports, String input, Class<T> targetType, Mapping<String, ?> variables) throws ParseException, EvaluationException {
        ExpressionEvaluator ee = new ExpressionEvaluator(PredicateUtil.containsKey(variables));
        if (onDemandImports != null) {
            ee.addOnDemandImports(onDemandImports);
        }
        return ee.evaluateTo(input, targetType, variables);
    }

    public static <T> Predicate<T> toPredicate(final Expression expression, final String parameterName) {
        if (expression == Expression.TRUE) {
            return PredicateUtil.always();
        }
        if (expression == Expression.FALSE) {
            return PredicateUtil.never();
        }
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                Object result;
                try {
                    result = expression.evaluate(parameterName, subject);
                }
                catch (EvaluationException ee) {
                    throw new RuntimeException(ee);
                }
                return ExpressionEvaluator.toBoolean(result);
            }

            public String toString() {
                return expression.toString();
            }
        };
    }

    public static Expression fromPredicate(final Predicate<? super String> predicate, final String variableName) {
        return new AbstractExpression(){

            @Override
            @Nullable
            public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                Object variableValue = variables.get(variableName);
                if (variableValue == null) {
                    throw new EvaluationException("Variable '" + variableName + "' not set");
                }
                if (!(variableValue instanceof String)) {
                    throw new EvaluationException("Variable '" + variableName + "' has unexpected type '" + variableValue.getClass() + "'");
                }
                return predicate.evaluate((String)variableValue);
            }
        };
    }

    public static Expression logicalAnd(final Expression operand1, final Expression operand2) {
        if (operand1 == Expression.FALSE) {
            return Expression.FALSE;
        }
        if (operand1 == Expression.TRUE) {
            return operand2;
        }
        if (operand2 == Expression.TRUE) {
            return operand1;
        }
        return new AbstractExpression(){

            @Override
            @Nullable
            public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                return ExpressionEvaluator.toBoolean(operand1.evaluate(variables)) ? operand2.evaluate(variables) : Boolean.valueOf(false);
            }
        };
    }

    public static Expression logicalOr(final Expression operand1, final Expression operand2) {
        if (operand1 == Expression.TRUE) {
            return Expression.TRUE;
        }
        if (operand1 == Expression.FALSE) {
            return operand2;
        }
        if (operand2 == Expression.FALSE) {
            return operand1;
        }
        return new AbstractExpression(){

            @Override
            @Nullable
            public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                return ExpressionUtil.evaluateTo(operand1, Boolean.TYPE, variables) != false ? Boolean.valueOf(true) : operand2.evaluate(variables);
            }
        };
    }
}

