/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.ftp;

import de.unkrig.commons.io.LineUtil;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.net.ReverseProxy;
import de.unkrig.commons.net.ftp.DataConnectionProxy;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.logging.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FtpReverseProxy
implements RunnableWhichThrows<IOException> {
    private static final Logger LOGGER = Logger.getLogger(FtpReverseProxy.class.getName());
    private final ReverseProxy reverseProxy;
    static final Pattern REPLY = Pattern.compile("(\\d\\d\\d) (.*)");
    static final Pattern BRACKETED_REPLY = Pattern.compile("(\\d\\d\\d)-(.*)");
    static final Pattern REPLY_227 = Pattern.compile("227 .*\\((\\d+),(\\d+),(\\d+),(\\d+),(\\d+),(\\d+)\\).*");
    static final Pattern REPLY_229 = Pattern.compile("229 .*\\(\\|\\|\\|(\\d+)\\|\\).*");
    static final Pattern COMMAND_PORT = Pattern.compile("PORT (\\d+),(\\d+),(\\d+),(\\d+),(\\d+),(\\d+)", 2);
    static final Pattern COMMAND_EPRT = Pattern.compile("EPRT \\|([12])\\|([^\\|]+)\\|(\\d+)\\|", 2);

    public FtpReverseProxy(InetSocketAddress endpoint, int backlog, InetSocketAddress serverAddress, int serverConnectionTimeout) throws IOException {
        this.reverseProxy = new ReverseProxy(endpoint, backlog, serverAddress, Proxy.NO_PROXY, serverConnectionTimeout, new ReverseProxy.ProxyConnectionHandler(){

            @Override
            public void handleConnection(InputStream clientIn, OutputStream clientOut, InputStream serverIn, OutputStream serverOut, InetSocketAddress clientLocalSocketAddress, InetSocketAddress clientRemoteSocketAddress, InetSocketAddress serverLocalSocketAddress, InetSocketAddress serverRemoteSocketAddress, Stoppable stoppable) throws IOException {
                Connection client = FtpReverseProxy.connection(LineUtil.lineProducerISO8859_1(clientIn), ConsumerUtil.tee(LineUtil.lineConsumerISO8859_1(clientOut), ConsumerUtil.widen2(LogUtil.logConsumer(LOGGER, Level.FINE, "<<< "))));
                Connection server = FtpReverseProxy.connection(LineUtil.lineProducerISO8859_1(serverIn), ConsumerUtil.tee(LineUtil.lineConsumerISO8859_1(serverOut), ConsumerUtil.widen2(LogUtil.logConsumer(LOGGER, Level.FINE, ">>> "))));
                DataConnectionProxy dataConnectionProxy = new DataConnectionProxy();
                while (true) {
                    InetSocketAddress endpoint;
                    int port;
                    InetAddress address;
                    Matcher m;
                    String reply = this.readReply(server);
                    LOGGER.log(Level.FINER, "Reply ''{0}'' received", reply);
                    if (reply == null) {
                        LOGGER.fine("Connection closed by remote server");
                    } else {
                        m = REPLY_227.matcher(reply);
                        if (m.matches()) {
                            address = InetAddress.getByAddress(new byte[]{(byte)Integer.parseInt(m.group(1)), (byte)Integer.parseInt(m.group(2)), (byte)Integer.parseInt(m.group(3)), (byte)Integer.parseInt(m.group(4))});
                            port = (Integer.parseInt(m.group(5)) << 8) + Integer.parseInt(m.group(6));
                            endpoint = dataConnectionProxy.start(clientLocalSocketAddress.getAddress(), new InetSocketAddress(address, port));
                            reply = "227 Entering Passive Mode (" + FtpReverseProxy.commafy(endpoint) + ")";
                        } else {
                            m = REPLY_229.matcher(reply);
                            if (m.matches()) {
                                int port2 = Integer.parseInt(m.group(1));
                                InetSocketAddress endpoint2 = dataConnectionProxy.start(clientLocalSocketAddress.getAddress(), new InetSocketAddress(serverRemoteSocketAddress.getAddress(), port2));
                                reply = "229 Entering Extended Passive Mode (|||" + endpoint2.getPort() + "|)";
                            }
                        }
                        client.writeLine(reply);
                        if (reply.startsWith("1")) continue;
                    }
                    String command = client.readLine();
                    LOGGER.log(Level.FINER, "Command ''{0}'' received", command);
                    if (command == null) break;
                    m = COMMAND_PORT.matcher(command);
                    if (m.matches()) {
                        address = InetAddress.getByAddress(new byte[]{(byte)Integer.parseInt(m.group(1)), (byte)Integer.parseInt(m.group(2)), (byte)Integer.parseInt(m.group(3)), (byte)Integer.parseInt(m.group(4))});
                        port = (Integer.parseInt(m.group(5)) << 8) + Integer.parseInt(m.group(6));
                        endpoint = dataConnectionProxy.start(serverLocalSocketAddress.getAddress(), new InetSocketAddress(address, port));
                        command = "PORT " + FtpReverseProxy.commafy(endpoint);
                    } else {
                        m = COMMAND_EPRT.matcher(command);
                        if (m.matches()) {
                            String protocol = m.group(1);
                            InetAddress address2 = InetAddress.getByName(m.group(2));
                            int port3 = Integer.parseInt(m.group(3));
                            InetSocketAddress endpoint3 = dataConnectionProxy.start(serverLocalSocketAddress.getAddress(), new InetSocketAddress(address2, port3));
                            command = "1".equals(protocol) && Boolean.getBoolean(FtpReverseProxy.class.getName() + ".replaceEprtWithPort") ? "PORT " + FtpReverseProxy.commafy(endpoint3) : "EPRT |" + (endpoint3.getAddress().getAddress().length == 4 ? 1 : 2) + "|" + endpoint3.getAddress().getHostAddress() + "|" + endpoint3.getPort() + "|";
                        }
                    }
                    server.writeLine(command);
                }
            }

            @Nullable
            private String readReply(Connection server) throws IOException {
                String reply = server.readLine();
                if (reply == null) {
                    return null;
                }
                if (REPLY.matcher(reply).matches()) {
                    return reply;
                }
                if (BRACKETED_REPLY.matcher(reply).matches()) {
                    String s;
                    do {
                        if ((s = server.readLine()) == null) {
                            throw new IOException("Incomplete bracketed reply");
                        }
                        reply = reply + "\r\n" + s;
                    } while (!REPLY.matcher(s).matches());
                    return reply;
                }
                throw new IOException("Invalid reply '" + reply + "' received");
            }
        });
    }

    static String commafy(InetSocketAddress socketAddress) {
        byte[] address = socketAddress.getAddress().getAddress();
        return (0xFF & address[0]) + "," + (0xFF & address[1]) + "," + (0xFF & address[2]) + "," + (0xFF & address[3]) + "," + (0xFF & socketAddress.getPort() >> 8) + "," + (0xFF & socketAddress.getPort());
    }

    @Override
    public void run() throws IOException {
        this.reverseProxy.run();
    }

    static Connection connection(final ProducerWhichThrows<String, IOException> producer, final ConsumerWhichThrows<String, IOException> consumer) {
        return new Connection(){

            @Override
            @Nullable
            public String readLine() throws IOException {
                return (String)producer.produce();
            }

            @Override
            public void writeLine(String line) throws IOException {
                consumer.consume(line);
            }
        };
    }

    static interface Connection {
        @Nullable
        public String readLine() throws IOException;

        public void writeLine(String var1) throws IOException;
    }
}

