/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

@NotNullByDefault(value=false)
public class WriterOutputStream
extends OutputStream {
    private final Writer delegate;
    private final CharsetDecoder decoder;
    private final ByteBuffer in = ByteBuffer.allocate(128);
    private final CharBuffer out = CharBuffer.allocate(128);

    public WriterOutputStream(Writer delegate) {
        this(delegate, Charset.defaultCharset());
    }

    public WriterOutputStream(Writer delegate, String charsetName) {
        this(delegate, Charset.forName(charsetName));
    }

    public WriterOutputStream(Writer delegate, Charset charset) {
        this(delegate, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?"));
    }

    public WriterOutputStream(Writer delegate, CharsetDecoder decoder) {
        this.delegate = delegate;
        this.decoder = decoder;
    }

    @Override
    public void close() throws IOException {
        this.processInput(true);
        this.delegate.close();
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        while (len > 0) {
            int n = Math.min(len, this.in.remaining());
            this.in.put(buf, off, n);
            this.processInput(false);
            len -= n;
            off += n;
        }
        this.writeOutput();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    private void processInput(boolean endOfInput) throws IOException {
        CoderResult coderResult;
        this.in.flip();
        while (!(coderResult = this.decoder.decode(this.in, this.out, endOfInput)).isUnderflow()) {
            if (coderResult.isOverflow()) {
                this.writeOutput();
                continue;
            }
            throw new AssertionError(coderResult);
        }
        this.in.compact();
    }

    private void writeOutput() throws IOException {
        if (this.out.position() == 0) {
            return;
        }
        this.delegate.write(this.out.array(), 0, this.out.position());
        ((Buffer)this.out).rewind();
    }
}

