/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.antology.util.SwingUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SwingDialogTask
extends Task {
    @Nullable
    private Object message;
    private String title = "APACHE ANT";
    public static final String DEFAULT_TITLE = "APACHE ANT";
    private OptionType optionType = OptionType.OK_CANCEL;
    private MessageType messageType = MessageType.PLAIN;
    @Nullable
    private String property;
    private final List<Runnable> beforeShow = new ArrayList<Runnable>();
    private final List<Runnable> retrievers = new ArrayList<Runnable>();
    private final Map<String, ButtonGroup> buttonGroups = new HashMap<String, ButtonGroup>();
    @Nullable
    private List<Task> ifYesTasks;
    @Nullable
    private List<Task> ifNoTasks;
    @Nullable
    private List<Task> ifCancelTasks;
    @Nullable
    private List<Task> ifOkTasks;
    @Nullable
    private List<Task> ifClosedTasks;

    public void setTitle(String title) {
        this.title = title;
    }

    public void setOptionType(OptionType optionType) {
        this.optionType = optionType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public void setProperty(String propertyName) {
        this.property = propertyName;
    }

    public void addText(String text) {
        if ((text = text.trim()).isEmpty()) {
            return;
        }
        text = this.getProject().replaceProperties(text);
        this.addToMessage(text);
    }

    public void addConfiguredLabel(Label label) {
        label.adddTo(this);
    }

    @Deprecated
    public void addConfiguredText(TextField textField) {
        this.addConfiguredTextField(textField);
    }

    public void addConfiguredTextField(TextField textField) {
        textField.adddTo(this);
    }

    public void addConfiguredTextArea(TextArea textArea) {
        textArea.adddTo(this);
    }

    public void addConfiguredCheckbox(Checkbox checkbox) {
        checkbox.adddTo(this);
    }

    public void addConfiguredRadioButton(RadioButton radioButton) {
        radioButton.adddTo(this);
    }

    public void addConfiguredList(LisT list) {
        list.adddTo(this);
    }

    public void addConfiguredSeparator(Separator separator) {
        separator.adddTo(this);
    }

    public void addConfiguredIfYes(Element__Tasks subelement) {
        if (this.ifYesTasks != null) {
            throw new BuildException("At most one '<ifYes>' subelement must be added");
        }
        this.ifYesTasks = subelement.tasks;
    }

    public void addConfiguredIfNo(Element__Tasks subelement) {
        if (this.ifNoTasks != null) {
            throw new BuildException("At most one '<ifNo>' subelement must be added");
        }
        this.ifNoTasks = subelement.tasks;
    }

    public void addConfiguredIfCancel(Element__Tasks subelement) {
        if (this.ifCancelTasks != null) {
            throw new BuildException("At most one '<ifCancel>' subelement must be added");
        }
        this.ifCancelTasks = subelement.tasks;
    }

    public void addConfiguredIfOk(Element__Tasks subelement) {
        if (this.ifOkTasks != null) {
            throw new BuildException("At most one '<ifOk>' subelement must be added");
        }
        this.ifOkTasks = subelement.tasks;
    }

    public void addConfiguredIfClosed(Element__Tasks subelement) {
        if (this.ifClosedTasks != null) {
            throw new BuildException("At most one '<ifClosed>' subelement must be added");
        }
        this.ifClosedTasks = subelement.tasks;
    }

    private void addToMessage(Object message) {
        if (this.message == null) {
            this.message = message;
            return;
        }
        if (this.message instanceof Object[]) {
            Object[] oa = (Object[])this.message;
            Object[] tmp = new Object[oa.length + 1];
            System.arraycopy(oa, 0, tmp, 0, oa.length);
            tmp[oa.length] = message;
            this.message = tmp;
            return;
        }
        Object[] oa = new Object[]{this.message, message};
        this.message = oa;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        void var2_9;
        for (Runnable runnable : this.beforeShow) {
            runnable.run();
        }
        ShowDialogReturnType sdrv = ShowDialogReturnType.fromInt(JOptionPane.showOptionDialog(null, this.message, this.title, this.optionType.intValue(), this.messageType.intValue(), null, null, null));
        if (sdrv == ShowDialogReturnType.YES && (this.optionType == OptionType.DEFAULT || this.optionType == OptionType.OK_CANCEL)) {
            sdrv = ShowDialogReturnType.OK;
        }
        if (this.property != null) {
            this.getProject().setProperty(this.property, sdrv.toString());
        }
        for (Runnable r : this.retrievers) {
            r.run();
        }
        switch (sdrv) {
            case YES: {
                List<Task> list = this.ifYesTasks;
                break;
            }
            case NO: {
                if (this.ifYesTasks == null && this.ifNoTasks == null) {
                    throw new BuildException("NO");
                }
                List<Task> list = this.ifNoTasks;
                break;
            }
            case CANCEL: {
                if (this.ifCancelTasks == null) {
                    throw new BuildException("CANCEL");
                }
                List<Task> list = this.ifCancelTasks;
                break;
            }
            case OK: {
                List<Task> list = this.ifOkTasks;
                break;
            }
            case CLOSED: {
                if (this.ifClosedTasks == null) {
                    throw new BuildException("CLOSED");
                }
                List<Task> list = this.ifClosedTasks;
                break;
            }
            default: {
                throw new IllegalStateException(sdrv.toString());
            }
        }
        if (var2_9 != null) {
            for (Task task : var2_9) {
                task.execute();
            }
        }
    }

    private static String[] tokenize(@Nullable String s, @Nullable String delimiters) {
        if (s == null) {
            return new String[0];
        }
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, delimiters);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l.toArray(new String[l.size()]);
    }

    private static int[] tokenizeIntegers(@Nullable String s, @Nullable String delimiters) {
        if (s == null) {
            return new int[0];
        }
        ArrayList<Integer> l = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(s, delimiters);
        while (st.hasMoreTokens()) {
            int value;
            String token = st.nextToken();
            try {
                value = Integer.parseInt(token);
            }
            catch (NumberFormatException nfe) {
                throw new BuildException("'" + token + "' is not a valid integer");
            }
            l.add(value);
        }
        int[] result = new int[l.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)l.get(i);
        }
        return result;
    }

    private static int indexOf(Object[] array, @Nullable Object element) {
        for (int i = 0; i < array.length; ++i) {
            if (!SwingDialogTask.equal(array[i], element)) continue;
            return i;
        }
        return -1;
    }

    private static boolean equal(@Nullable Object o1, @Nullable Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static enum MessageType {
        ERROR(0),
        INFORMATION(1),
        WARNING(2),
        QUESTION(3),
        PLAIN(-1);

        private final int value;

        private MessageType(int value) {
            this.value = value;
        }

        int intValue() {
            return this.value;
        }
    }

    public static enum SelectionMode {
        SINGLE(0),
        SINGLE_INTERVAL(1),
        MULTIPLE_INTERVAL(2);

        private final int value;

        private SelectionMode(int value) {
            this.value = value;
        }

        int intValue() {
            return this.value;
        }
    }

    public static enum ShowDialogReturnType {
        YES(0),
        NO(1),
        CANCEL(2),
        OK(0),
        CLOSED(-1);

        private final int value;

        private ShowDialogReturnType(int value) {
            this.value = value;
        }

        private static ShowDialogReturnType fromInt(int value) {
            for (ShowDialogReturnType sdrt : ShowDialogReturnType.values()) {
                if (sdrt.intValue() != value) continue;
                return sdrt;
            }
            throw new IllegalArgumentException(Integer.toString(value));
        }

        int intValue() {
            return this.value;
        }
    }

    public static enum OptionType {
        DEFAULT(-1),
        YES_NO(0),
        YES_NO_CANCEL(1),
        OK_CANCEL(2);

        private final int value;

        private OptionType(int value) {
            this.value = value;
        }

        int intValue() {
            return this.value;
        }
    }

    public static class Element__Tasks {
        private final List<Task> tasks = new ArrayList<Task>();

        public void addConfigured(Task task) {
            this.tasks.add(task);
        }
    }

    public static class Separator
    implements SwingDialogTaskAddable {
        @Override
        public void adddTo(SwingDialogTask swingDialogTask) {
            swingDialogTask.addToMessage(new JSeparator());
        }
    }

    public static class LisT
    implements SwingDialogTaskAddable {
        @Nullable
        private SelectionMode selectionMode;
        @Nullable
        private String values;
        @Nullable
        private String defaultValues;
        @Nullable
        private String labels;
        @Nullable
        private String defaultIndices;
        private String delimiters = ",";
        @Nullable
        private String property;
        private boolean focus;
        private boolean enabled = true;
        private int visibleRowCount = -1;

        public void setSelectionMode(SelectionMode value) {
            this.selectionMode = value;
        }

        public void setProperty(String propertyName) {
            this.property = propertyName;
        }

        public void setValues(String values) {
            this.values = values;
        }

        public void setLabels(String labels) {
            this.labels = labels;
        }

        public void setDefaultValues(String values) {
            this.defaultValues = values;
        }

        public void setDefaultIndices(String indexes) {
            this.defaultIndices = indexes;
        }

        public void setDelimiters(String delimiters) {
            this.delimiters = delimiters;
        }

        public void setFocus(boolean value) {
            this.focus = value;
        }

        public void setEnabled(boolean value) {
            this.enabled = value;
        }

        public void setVisibleRowCount(int n) {
            this.visibleRowCount = n;
        }

        @Override
        public void adddTo(SwingDialogTask swingDialogTask) {
            int[] dis;
            Object[] values = SwingDialogTask.tokenize(this.values, this.delimiters);
            String[] labels = SwingDialogTask.tokenize(this.labels, this.delimiters);
            Object[] listData = new Object[values.length];
            for (int i = 0; i < listData.length; ++i) {
                listData[i] = i < labels.length ? labels[i] : values[i];
            }
            final JList<Object> jList = new JList<Object>(listData);
            jList.setBorder(new SoftBevelBorder(1));
            if (this.focus) {
                SwingUtil.focussify(jList);
            }
            jList.setEnabled(this.enabled);
            if (this.selectionMode != null) {
                jList.setSelectionMode(this.selectionMode.intValue());
            }
            if (this.defaultValues != null) {
                if (this.defaultIndices != null) {
                    throw new BuildException("Only one of 'defaultValues=...' and 'defaultIndices=...' must be used");
                }
                String[] defaultValues = SwingDialogTask.tokenize(this.defaultValues, this.delimiters);
                dis = new int[defaultValues.length];
                for (int i = 0; i < defaultValues.length; ++i) {
                    String defaultValue = defaultValues[i];
                    int idx = SwingDialogTask.indexOf(values, defaultValue);
                    if (idx == -1) {
                        throw new BuildException("Default value '" + defaultValue + "' is not a valid value");
                    }
                    dis[i] = idx;
                }
                swingDialogTask.beforeShow.add(new Runnable(){

                    @Override
                    public void run() {
                        LisT.select(jList, dis);
                    }
                });
            } else {
                dis = this.defaultIndices != null ? SwingDialogTask.tokenizeIntegers(this.defaultIndices, this.delimiters) : null;
            }
            if (dis != null) {
                swingDialogTask.beforeShow.add(new Runnable(){

                    @Override
                    public void run() {
                        LisT.select(jList, dis);
                    }
                });
            }
            swingDialogTask.retrievers.add(new Runnable((String[])values, swingDialogTask){
                final /* synthetic */ String[] val$values;
                final /* synthetic */ SwingDialogTask val$swingDialogTask;
                {
                    this.val$values = stringArray;
                    this.val$swingDialogTask = swingDialogTask;
                }

                @Override
                public void run() {
                    String s;
                    int[] selectedIndices = jList.getSelectedIndices();
                    if (selectedIndices.length == 0) {
                        s = null;
                    } else {
                        StringBuilder sb = new StringBuilder(this.val$values[selectedIndices[0]]);
                        for (int i = 1; i < selectedIndices.length; ++i) {
                            sb.append(LisT.this.delimiters.charAt(0)).append(this.val$values[selectedIndices[i]]);
                        }
                        s = sb.toString();
                    }
                    this.val$swingDialogTask.getProject().setProperty(LisT.this.property, s);
                }
            });
            if (this.visibleRowCount == -1) {
                swingDialogTask.addToMessage(jList);
            } else {
                jList.setVisibleRowCount(this.visibleRowCount);
                swingDialogTask.addToMessage(new JScrollPane(jList));
            }
        }

        private static void select(JList jList, int[] indices) {
            for (int index : indices) {
                if (index >= 0 && index < jList.getModel().getSize()) continue;
                throw new BuildException("Index '" + index + "' out of range");
            }
            jList.setSelectedIndices(indices);
        }
    }

    public static class RadioButton
    implements SwingDialogTaskAddable {
        @Nullable
        private String text;
        @Nullable
        private String value;
        @Nullable
        private String property;
        private boolean preselected;
        private boolean focus;
        private boolean enabled = true;

        public void setText(String text) {
            this.text = text;
        }

        public void addText(String text) {
            if ((text = text.trim()).isEmpty()) {
                return;
            }
            this.text = text;
        }

        public void setProperty(String propertyName) {
            this.property = propertyName;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setPreselected(boolean value) {
            this.preselected = value;
        }

        public void setFocus(boolean value) {
            this.focus = value;
        }

        public void setEnabled(boolean value) {
            this.enabled = value;
        }

        @Override
        public void adddTo(final SwingDialogTask swingDialogTask) {
            String property = this.property;
            assert (property != null);
            final JRadioButton jRadioButton = new JRadioButton();
            if (this.focus) {
                SwingUtil.focussify(jRadioButton);
            }
            jRadioButton.setEnabled(this.enabled);
            ButtonGroup bg = (ButtonGroup)swingDialogTask.buttonGroups.get(property);
            if (bg == null) {
                bg = new ButtonGroup();
                swingDialogTask.buttonGroups.put(property, bg);
            }
            bg.add(jRadioButton);
            swingDialogTask.beforeShow.add(new Runnable(){

                @Override
                public void run() {
                    jRadioButton.setText(swingDialogTask.getProject().replaceProperties(RadioButton.this.text));
                    jRadioButton.setSelected(RadioButton.this.preselected);
                }
            });
            swingDialogTask.retrievers.add(new Runnable(){

                @Override
                public void run() {
                    if (jRadioButton.isSelected()) {
                        swingDialogTask.getProject().setProperty(RadioButton.this.property, RadioButton.this.value != null ? RadioButton.this.value : RadioButton.this.text);
                    }
                }
            });
            swingDialogTask.addToMessage(jRadioButton);
        }
    }

    public static class Checkbox
    implements SwingDialogTaskAddable {
        @Nullable
        private String text;
        @Nullable
        private String property;
        private boolean preselected;
        private boolean focus;
        private boolean enabled = true;

        public void setText(String text) {
            this.text = text;
        }

        public void addText(String text) {
            if ((text = text.trim()).isEmpty()) {
                return;
            }
            this.text = text;
        }

        public void setProperty(String propertyName) {
            this.property = propertyName;
        }

        public void setPreselected(boolean value) {
            this.preselected = value;
        }

        public void setFocus(boolean value) {
            this.focus = value;
        }

        public void setEnabled(boolean value) {
            this.enabled = value;
        }

        @Override
        public void adddTo(final SwingDialogTask swingDialogTask) {
            final JCheckBox jCheckBox = new JCheckBox();
            if (this.focus) {
                SwingUtil.focussify(jCheckBox);
            }
            jCheckBox.setEnabled(this.enabled);
            swingDialogTask.beforeShow.add(new Runnable(){

                @Override
                public void run() {
                    jCheckBox.setText(swingDialogTask.getProject().replaceProperties(Checkbox.this.text));
                    jCheckBox.setSelected(Checkbox.this.preselected);
                }
            });
            swingDialogTask.retrievers.add(new Runnable(){

                @Override
                public void run() {
                    swingDialogTask.getProject().setProperty(Checkbox.this.property, Boolean.toString(jCheckBox.isSelected()));
                }
            });
            swingDialogTask.addToMessage(jCheckBox);
        }
    }

    public static class TextArea
    extends TextComponent {
        @Nullable
        private File file;
        private boolean append;
        @Nullable
        private File defaultFile;
        private int rows;
        private int columns;
        @Nullable
        private Charset encoding;

        public void setFile(File file) {
            this.file = file;
        }

        public void setAppend(boolean value) {
            this.append = value;
        }

        public void setDefaultFile(File defaultFile) {
            this.defaultFile = defaultFile;
        }

        public void setRows(int n) {
            this.rows = n;
        }

        public void setColumns(int n) {
            this.columns = n;
        }

        public void setEncoding(String charset) {
            this.encoding = Charset.forName(charset);
        }

        @Override
        public void adddTo(final SwingDialogTask swingDialogTask) {
            final JTextArea jTextArea = new JTextArea(this.rows, this.columns);
            jTextArea.setEnabled(this.enabled);
            if (this.focus) {
                SwingUtil.focussify(jTextArea);
            }
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            if (this.defaultValue != null) {
                if (this.defaultFile != null) {
                    throw new BuildException("'defaultValue=\"...\"' and 'defaultFile=\"...\"' are mutually exclusive");
                }
                swingDialogTask.beforeShow.add(new Runnable(){

                    @Override
                    public void run() {
                        jTextArea.setText(TextArea.this.defaultValue);
                    }
                });
            } else if (this.defaultFile != null) {
                swingDialogTask.beforeShow.add(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileInputStream is = new FileInputStream(TextArea.this.defaultFile);
                            try {
                                jTextArea.read(new InputStreamReader((InputStream)is, TextArea.this.encoding), null);
                                ((InputStream)is).close();
                            }
                            finally {
                                try {
                                    ((InputStream)is).close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (IOException ioe) {
                            throw ExceptionUtil.wrap("Reading default file '" + TextArea.this.defaultFile + "'", ioe, BuildException.class);
                        }
                    }
                });
            }
            swingDialogTask.retrievers.add(new Runnable(){

                @Override
                public void run() {
                    if (TextArea.this.property != null) {
                        swingDialogTask.getProject().setProperty(TextArea.this.property, jTextArea.getText());
                    }
                    if (TextArea.this.file != null) {
                        try {
                            FileOutputStream os = new FileOutputStream(TextArea.this.file, TextArea.this.append);
                            try {
                                jTextArea.write(new OutputStreamWriter((OutputStream)os, TextArea.this.encoding));
                                ((OutputStream)os).close();
                            }
                            finally {
                                try {
                                    ((OutputStream)os).close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (IOException ioe) {
                            throw ExceptionUtil.wrap("Writing  file '" + TextArea.this.file + "'", ioe, BuildException.class);
                        }
                    }
                }
            });
            swingDialogTask.addToMessage(jScrollPane);
        }
    }

    public static class TextField
    extends TextComponent {
        private boolean secure;
        @Nullable
        private String label;
        private int labelWidth;

        public void setSecure(boolean value) {
            this.secure = value;
        }

        public void setLabel(String text) {
            this.label = text;
        }

        public void setLabelWidth(int pixels) {
            this.labelWidth = pixels;
        }

        @Override
        public void adddTo(final SwingDialogTask swingDialogTask) {
            JComponent jComponent;
            final JTextField jTextField = this.secure ? new JPasswordField() : new JTextField();
            jTextField.setEnabled(this.enabled);
            if (this.focus) {
                SwingUtil.focussify(jTextField);
            }
            if (this.label != null) {
                BorderLayout bl = new BorderLayout();
                bl.setHgap(10);
                jComponent = new JPanel(bl);
                JLabel l = new JLabel(this.label);
                if (this.labelWidth != 0) {
                    l.setPreferredSize(new Dimension(this.labelWidth, 0));
                }
                jComponent.add((Component)l, "West");
                jComponent.add((Component)jTextField, "Center");
            } else {
                jComponent = jTextField;
            }
            swingDialogTask.beforeShow.add(new Runnable(){

                @Override
                public void run() {
                    jTextField.setText(TextField.this.defaultValue);
                }
            });
            swingDialogTask.retrievers.add(new Runnable(){

                @Override
                public void run() {
                    swingDialogTask.getProject().setProperty(TextField.this.property, jTextField.getText());
                }
            });
            swingDialogTask.addToMessage(jComponent);
        }
    }

    public static abstract class TextComponent
    implements SwingDialogTaskAddable {
        @Nullable
        String property;
        @Nullable
        String defaultValue;
        boolean focus;
        boolean enabled = true;

        public void setProperty(String propertyName) {
            this.property = propertyName;
        }

        public void setDefaultValue(String text) {
            this.defaultValue = text;
        }

        public void setFocus(boolean value) {
            this.focus = value;
        }

        public void setEnabled(boolean value) {
            this.enabled = value;
        }
    }

    public static class Label
    implements SwingDialogTaskAddable {
        @Nullable
        private String text;

        public void setText(String text) {
            this.text = text;
        }

        public void addText(String text) {
            if ((text = text.trim()).isEmpty()) {
                return;
            }
            this.text = text;
        }

        @Override
        public void adddTo(final SwingDialogTask swingDialogTask) {
            final JLabel jLabel = new JLabel();
            swingDialogTask.beforeShow.add(new Runnable(){

                @Override
                public void run() {
                    jLabel.setText(swingDialogTask.getProject().replaceProperties(Label.this.text));
                }
            });
            swingDialogTask.addToMessage(jLabel);
        }
    }

    public static interface SwingDialogTaskAddable {
        public void adddTo(SwingDialogTask var1);
    }
}

