/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.pattern;

import de.unkrig.commons.util.pattern.Glob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class IncludeExclude
extends Glob {
    private final List<ModeAndGlob> mags = new ArrayList<ModeAndGlob>();

    public void appendInclude(Glob include) {
        this.mags.add(new ModeAndGlob(Mode.INCLUDE, include));
    }

    public void prependInclude(Glob include) {
        this.mags.add(0, new ModeAndGlob(Mode.INCLUDE, include));
    }

    public void appendExclude(Glob exclude) {
        this.mags.add(new ModeAndGlob(Mode.EXCLUDE, exclude));
    }

    public void prependExclude(Glob exclude) {
        this.mags.add(0, new ModeAndGlob(Mode.EXCLUDE, exclude));
    }

    public boolean matches(String subject) {
        String subject2 = subject.endsWith("!") || subject.endsWith("/") ? subject.substring(0, subject.length() - 1) : subject;
        for (ModeAndGlob mag : this.mags) {
            if (!mag.glob.matches(mag.mode == Mode.INCLUDE ? subject : subject2)) continue;
            return mag.mode == Mode.INCLUDE;
        }
        return this.mags.isEmpty() || this.mags.get((int)(this.mags.size() - 1)).mode == Mode.EXCLUDE;
    }

    public String replace(String subject) {
        boolean hadInclude = false;
        block4: for (ModeAndGlob map : this.mags) {
            switch (map.mode) {
                case INCLUDE: {
                    String tmp = map.glob.replace(subject);
                    if (tmp == null) continue block4;
                    subject = tmp;
                    hadInclude = true;
                    break;
                }
                case EXCLUDE: {
                    if (!map.glob.matches(subject)) continue block4;
                    return hadInclude ? subject : null;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return hadInclude ? subject : null;
    }

    public String toString() {
        Iterator<ModeAndGlob> it = this.mags.iterator();
        if (!it.hasNext()) {
            return "(empty)";
        }
        StringBuilder sb = new StringBuilder();
        ModeAndGlob mag = it.next();
        if (mag.mode == Mode.EXCLUDE) {
            sb.append('~');
        }
        sb.append(mag.glob);
        while (it.hasNext()) {
            mag = it.next();
            sb.append(mag.mode == Mode.INCLUDE ? (char)',' : '~');
            sb.append(mag.glob);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        INCLUDE,
        EXCLUDE;

    }

    private static class ModeAndGlob {
        final Mode mode;
        final Glob glob;

        ModeAndGlob(Mode mode, Glob glob) {
            this.mode = mode;
            this.glob = glob;
        }
    }
}

