/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class FormatFormatter
extends Formatter {
    public static final String COMPACT_FORMAT = "%4$s %6$s::%7$s %8$s%9$s%n";
    public static final String SIMPLE_FORMAT = "%5$tF %5$tT.%5$tL %10$-20s %3$2d %8$s%9$s%n";
    public static final String DEFAULT_FORMAT = "%5$tF %5$tT.%5$tL %10$-20s %3$2d %8$s%9$s%n";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final String format;

    public FormatFormatter() {
        this(LogManager.getLogManager().getProperty(String.valueOf(FormatFormatter.class.getName()) + ".format"));
    }

    public FormatFormatter(String formatString) {
        this.format = "COMPACT".equals(formatString) ? COMPACT_FORMAT : ("SIMPLE".equals(formatString) ? "%5$tF %5$tT.%5$tL %10$-20s %3$2d %8$s%9$s%n" : (formatString != null ? formatString : "%5$tF %5$tT.%5$tL %10$-20s %3$2d %8$s%9$s%n"));
    }

    public String format(LogRecord record) {
        String thrownText;
        Throwable thrown = record.getThrown();
        if (thrown == null) {
            thrownText = "";
        } else {
            StringWriter sw = new StringWriter();
            sw.write(": ");
            sw.write(LINE_SEPARATOR);
            thrown.printStackTrace(new PrintWriter(sw));
            thrownText = sw.toString();
            if (thrownText.endsWith(LINE_SEPARATOR)) {
                thrownText = thrownText.substring(0, thrownText.length() - LINE_SEPARATOR.length());
            }
        }
        String sourceClassName = record.getSourceClassName();
        String simpleSourceClassName = sourceClassName.substring(sourceClassName.lastIndexOf(46) + 1);
        return String.format(this.format, record.getSequenceNumber(), record.getLoggerName(), record.getThreadID(), record.getLevel(), new Date(record.getMillis()), sourceClassName, record.getSourceMethodName(), MessageFormat.format(record.getMessage(), record.getParameters()), thrownText, simpleSourceClassName);
    }
}

