/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.tool.tcpmon;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.Stoppable;
import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.net.ReverseProxy;
import de.unkrig.commons.util.logging.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.logging.Level;

public class Main {
    public static void main(String[] args) throws IOException {
        int i = 0;
        Level logLevel = Level.FINE;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) break;
            ++i;
            if ("-log".equals(arg)) {
                logLevel = Level.parse(args[i++]);
                continue;
            }
            --i;
            break;
        }
        LogUtil.removeAllHandlersFromRootLogger();
        LogUtil.addConsoleHandlerToRootLogger();
        LogUtil.setRootLoggerLevel(logLevel);
        while (true) {
            int backlog = 0;
            InetAddress bindAddress = null;
            int serverConnectionTimeout = 0;
            while (i < args.length) {
                String arg = args[i];
                if (!arg.startsWith("-")) break;
                ++i;
                if ("-backlog".equals(arg)) {
                    backlog = Integer.parseInt(args[i++]);
                    continue;
                }
                if ("-bind-address".equals(arg)) {
                    bindAddress = InetAddress.getByName(args[i++]);
                    continue;
                }
                if ("-server-connection-timeout".equals(arg)) {
                    serverConnectionTimeout = Integer.parseInt(args[i++]);
                    continue;
                }
                System.err.println("Invalid command line option '" + arg + "'; try '-help'");
                System.exit(1);
            }
            if (i + 3 > args.length) {
                System.err.println("Local port, server host name and/or server port missing; try '-help'.");
                System.exit(1);
            }
            InetSocketAddress endpoint = new InetSocketAddress(bindAddress, Integer.parseInt(args[i++]));
            InetSocketAddress serverAddress = InetSocketAddress.createUnresolved(args[i++], Integer.parseInt(args[i++]));
            new ReverseProxy(endpoint, backlog, serverAddress, Proxy.NO_PROXY, serverConnectionTimeout, new ReverseProxy.ProxyConnectionHandler(){

                public void handleConnection(InputStream clientIn, OutputStream clientOut, InputStream serverIn, OutputStream serverOut, InetSocketAddress clientLocalSocketAddress, InetSocketAddress clientRemoteSocketAddress, InetSocketAddress serverLocalSocketAddress, InetSocketAddress serverRemoteSocketAddress, Stoppable stoppable) throws IOException {
                    ThreadUtil.parallel(IoUtil.copyRunnable(clientIn, serverOut), IoUtil.copyRunnable(serverIn, clientOut), stoppable);
                }
            });
        }
    }
}

