/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io.charstream;

import de.unkrig.commons.io.charstream.CharStream;
import de.unkrig.commons.io.charstream.UnexpectedCharacterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharSequenceCharStream
implements CharStream<RuntimeException> {
    private final CharSequence cs;
    int off;

    public CharSequenceCharStream(CharSequence cs) {
        if (cs == null) {
            throw new NullPointerException();
        }
        this.cs = cs;
    }

    @Override
    public int peek() {
        return this.off >= this.cs.length() ? -1 : (int)this.cs.charAt(this.off);
    }

    @Override
    public int peek(int distance) {
        int off = this.off + distance;
        return off >= this.cs.length() ? -1 : (int)this.cs.charAt(off);
    }

    @Override
    public boolean peek(char c) {
        return this.off < this.cs.length() && this.cs.charAt(this.off) == c;
    }

    @Override
    public int peek(String s) {
        if (this.off >= this.cs.length()) {
            return -1;
        }
        return s.indexOf(this.cs.charAt(this.off));
    }

    @Override
    public boolean peekNewline() {
        if (this.off >= this.cs.length()) {
            return false;
        }
        char c = this.cs.charAt(this.off);
        return c == '\r' || c == '\n';
    }

    @Override
    public char read() throws UnexpectedCharacterException {
        if (this.off >= this.cs.length()) {
            throw new UnexpectedCharacterException("Unexpected end-of-input");
        }
        return this.cs.charAt(this.off++);
    }

    @Override
    public void read(char c) throws UnexpectedCharacterException {
        char c2 = this.read();
        if (c2 != c) {
            throw new UnexpectedCharacterException("'" + c + "' expected instead of '" + c2 + "'");
        }
    }

    @Override
    public int read(String s) throws UnexpectedCharacterException {
        char c = this.read();
        int res = s.indexOf(c);
        if (res == -1) {
            throw new UnexpectedCharacterException("One of '" + s + "' expected instead of '" + c + "'");
        }
        return res;
    }

    @Override
    public void readNewline() throws UnexpectedCharacterException {
        if (this.read("\r\n") == 0) {
            this.peekRead('\n');
        }
    }

    @Override
    public int peekRead() {
        return this.off >= this.cs.length() ? -1 : (int)this.cs.charAt(this.off++);
    }

    @Override
    public boolean peekRead(char c) {
        if (this.off >= this.cs.length() || this.cs.charAt(this.off) != c) {
            return false;
        }
        ++this.off;
        return true;
    }

    @Override
    public int peekRead(String s) {
        if (this.off >= this.cs.length()) {
            return -1;
        }
        int idx = s.indexOf(this.cs.charAt(this.off));
        if (idx == -1) {
            return -1;
        }
        ++this.off;
        return idx;
    }

    @Override
    public boolean peekReadNewline() {
        if (this.peekRead("\r\n") == 0) {
            this.peekRead('\n');
            return true;
        }
        return false;
    }

    @Override
    public boolean isAtEoi() {
        return this.off >= this.cs.length();
    }

    @Override
    public void eoi() throws UnexpectedCharacterException {
        if (this.off < this.cs.length()) {
            throw new UnexpectedCharacterException("Unexpected trailing character '" + this.cs.charAt(this.off) + "'");
        }
    }

    public String toString() {
        if (this.off == 0) {
            return this.cs.toString();
        }
        return this.cs.subSequence(0, this.off) + "***" + this.cs.subSequence(this.off, this.cs.length());
    }
}

