/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ThreadUtils;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BackgroundInitializerTest
extends AbstractLangTest {
    private void checkInitialize(AbstractBackgroundInitializerTestImpl init) throws ConcurrentException {
        Integer result = ((CloseableCounter)init.get()).getInitializeCalls();
        Assertions.assertEquals((int)1, (int)result, (String)"Wrong result");
        Assertions.assertEquals((int)1, (int)init.getCloseableCounter().getInitializeCalls(), (String)"Wrong number of invocations");
        Assertions.assertNotNull((Object)init.getFuture(), (String)"No future");
    }

    protected AbstractBackgroundInitializerTestImpl getBackgroundInitializerTestImpl() {
        return new MethodBackgroundInitializerTestImpl();
    }

    protected AbstractBackgroundInitializerTestImpl getBackgroundInitializerTestImpl(ExecutorService exec) {
        return new MethodBackgroundInitializerTestImpl(exec);
    }

    @Test
    public void testGetActiveExecutorBeforeStart() {
        AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        Assertions.assertNull((Object)init.getActiveExecutor(), (String)"Got an executor");
    }

    @Test
    public void testGetActiveExecutorExternal() throws InterruptedException, ConcurrentException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl(exec);
            init.start();
            Assertions.assertSame((Object)exec, (Object)init.getActiveExecutor(), (String)"Wrong executor");
            this.checkInitialize(init);
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testGetActiveExecutorTemp() throws ConcurrentException {
        AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        init.start();
        Assertions.assertNotNull((Object)init.getActiveExecutor(), (String)"No active executor");
        this.checkInitialize(init);
    }

    @Test
    public void testGetBeforeStart() {
        AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        Assertions.assertThrows(IllegalStateException.class, () -> ((AbstractBackgroundInitializerTestImpl)init).get());
    }

    @Test
    public void testGetCheckedException() {
        Exception ex;
        AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        init.ex = ex = new Exception();
        init.start();
        ConcurrentException cex = (ConcurrentException)Assertions.assertThrows(ConcurrentException.class, () -> ((AbstractBackgroundInitializerTestImpl)init).get());
        Assertions.assertEquals((Object)ex, (Object)cex.getCause(), (String)"Exception not thrown");
    }

    @Test
    public void testGetInterruptedException() throws InterruptedException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        final AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl(exec);
        final CountDownLatch latch1 = new CountDownLatch(1);
        init.shouldSleep = true;
        init.start();
        final AtomicReference iex = new AtomicReference();
        Thread getThread = new Thread(){

            @Override
            public void run() {
                try {
                    init.get();
                }
                catch (ConcurrentException cex) {
                    if (cex.getCause() instanceof InterruptedException) {
                        iex.set((InterruptedException)cex.getCause());
                    }
                }
                finally {
                    Assertions.assertTrue((boolean)this.isInterrupted(), (String)"Thread not interrupted");
                    latch1.countDown();
                }
            }
        };
        getThread.start();
        getThread.interrupt();
        latch1.await();
        exec.shutdownNow();
        exec.awaitTermination(1L, TimeUnit.SECONDS);
        Assertions.assertNotNull(iex.get(), (String)"No interrupted exception");
    }

    @Test
    public void testGetRuntimeException() {
        AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        RuntimeException rex = new RuntimeException();
        init.ex = rex;
        init.start();
        Exception ex = (Exception)Assertions.assertThrows(Exception.class, () -> ((AbstractBackgroundInitializerTestImpl)init).get());
        Assertions.assertEquals((Object)rex, (Object)ex, (String)"Runtime exception not thrown");
    }

    @Test
    public void testInitialize() throws ConcurrentException {
        AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        init.start();
        this.checkInitialize(init);
    }

    @Test
    public void testInitializeTempExecutor() throws ConcurrentException {
        AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        Assertions.assertTrue((boolean)init.start(), (String)"Wrong result of start()");
        this.checkInitialize(init);
        Assertions.assertTrue((boolean)init.getActiveExecutor().isShutdown(), (String)"Executor not shutdown");
    }

    @Test
    public void testIsInitialized() throws ConcurrentException {
        AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        init.enableLatch();
        init.start();
        Assertions.assertTrue((boolean)init.isStarted(), (String)"Not started");
        Assertions.assertFalse((boolean)init.isInitialized(), (String)"Initialized before releasing latch");
        init.releaseLatch();
        init.get();
        Assertions.assertTrue((boolean)init.isInitialized(), (String)"Not initialized after releasing latch");
    }

    @Test
    public void testIsStartedAfterGet() throws ConcurrentException {
        AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        init.start();
        this.checkInitialize(init);
        Assertions.assertTrue((boolean)init.isStarted(), (String)"Not started");
    }

    @Test
    public void testIsStartedFalse() {
        AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        Assertions.assertFalse((boolean)init.isStarted(), (String)"Already started");
    }

    @Test
    public void testIsStartedTrue() {
        AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        init.start();
        Assertions.assertTrue((boolean)init.isStarted(), (String)"Not started");
    }

    @Test
    public void testSetExternalExecutor() throws ConcurrentException {
        ExecutorService exec = Executors.newCachedThreadPool();
        try {
            AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
            init.setExternalExecutor(exec);
            Assertions.assertEquals((Object)exec, (Object)init.getExternalExecutor(), (String)"Wrong executor service");
            Assertions.assertTrue((boolean)init.start(), (String)"Wrong result of start()");
            Assertions.assertSame((Object)exec, (Object)init.getActiveExecutor(), (String)"Wrong active executor");
            this.checkInitialize(init);
            Assertions.assertFalse((boolean)exec.isShutdown(), (String)"Executor was shutdown");
        }
        finally {
            exec.shutdown();
        }
    }

    @Test
    public void testSetExternalExecutorAfterStart() throws ConcurrentException, InterruptedException {
        AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        init.start();
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            Assertions.assertThrows(IllegalStateException.class, () -> init.setExternalExecutor(exec));
            init.get();
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testStartMultipleTimes() throws ConcurrentException {
        AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        Assertions.assertTrue((boolean)init.start(), (String)"Wrong result for start()");
        for (int i = 0; i < 10; ++i) {
            Assertions.assertFalse((boolean)init.start(), (String)"Could start again");
        }
        this.checkInitialize(init);
    }

    protected static class AbstractBackgroundInitializerTestImpl
    extends BackgroundInitializer<CloseableCounter> {
        Exception ex;
        boolean shouldSleep;
        final CountDownLatch latch = new CountDownLatch(1);
        boolean waitForLatch;
        CloseableCounter counter = new CloseableCounter();

        AbstractBackgroundInitializerTestImpl() {
        }

        AbstractBackgroundInitializerTestImpl(ExecutorService exec) {
            super(exec);
        }

        public void enableLatch() {
            this.waitForLatch = true;
        }

        public CloseableCounter getCloseableCounter() {
            return this.counter;
        }

        protected CloseableCounter initializeInternal() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
            if (this.shouldSleep) {
                ThreadUtils.sleep((Duration)Duration.ofMinutes(1L));
            }
            if (this.waitForLatch) {
                this.latch.await();
            }
            return this.counter.increment();
        }

        public void releaseLatch() {
            this.latch.countDown();
        }
    }

    protected static class CloseableCounter {
        AtomicInteger initializeCalls = new AtomicInteger();
        AtomicBoolean closed = new AtomicBoolean();

        protected CloseableCounter() {
        }

        public void close() {
            this.closed.set(true);
        }

        public int getInitializeCalls() {
            return this.initializeCalls.get();
        }

        public CloseableCounter increment() {
            this.initializeCalls.incrementAndGet();
            return this;
        }

        public boolean isClosed() {
            return this.closed.get();
        }
    }

    protected static class MethodBackgroundInitializerTestImpl
    extends AbstractBackgroundInitializerTestImpl {
        MethodBackgroundInitializerTestImpl() {
        }

        MethodBackgroundInitializerTestImpl(ExecutorService exec) {
            super(exec);
        }

        protected CloseableCounter initialize() throws Exception {
            return this.initializeInternal();
        }
    }
}

