/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializerTest;
import org.apache.commons.lang3.concurrent.AtomicInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AtomicInitializerNonObjectTest
extends AbstractConcurrentInitializerTest<Integer> {
    @Override
    protected ConcurrentInitializer<Integer> createInitializer() {
        return new AtomicInitializer<Integer>(){

            protected Integer initialize() {
                return new Integer(0);
            }
        };
    }

    @Test
    public void testGetThatReturnsNullFirstTime() throws ConcurrentException {
        AtomicInitializer<Integer> initializer = new AtomicInitializer<Integer>(){
            final AtomicInteger firstRun = new AtomicInteger(1);

            protected Integer initialize() {
                if (this.firstRun.getAndSet(0) == 1) {
                    return null;
                }
                return new Integer(0);
            }
        };
        Assertions.assertNull((Object)initializer.get());
        Assertions.assertNull((Object)initializer.get());
    }
}

