// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: contrib/envoy/extensions/filters/http/sxg/v3alpha/sxg.proto

package envoy_extensions_filters_http_sxg_v3alpha

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// Validate checks the field values on SXG with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *SXG) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetCertificate()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return SXGValidationError{
				field:  "Certificate",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetPrivateKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return SXGValidationError{
				field:  "PrivateKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetDuration()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return SXGValidationError{
				field:  "Duration",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for MiRecordSize

	if utf8.RuneCountInString(m.GetCborUrl()) < 1 {
		return SXGValidationError{
			field:  "CborUrl",
			reason: "value length must be at least 1 runes",
		}
	}

	if !strings.HasPrefix(m.GetCborUrl(), "/") {
		return SXGValidationError{
			field:  "CborUrl",
			reason: "value does not have prefix \"/\"",
		}
	}

	if utf8.RuneCountInString(m.GetValidityUrl()) < 1 {
		return SXGValidationError{
			field:  "ValidityUrl",
			reason: "value length must be at least 1 runes",
		}
	}

	if !strings.HasPrefix(m.GetValidityUrl(), "/") {
		return SXGValidationError{
			field:  "ValidityUrl",
			reason: "value does not have prefix \"/\"",
		}
	}

	if m.GetClientCanAcceptSxgHeader() != "" {

		if !_SXG_ClientCanAcceptSxgHeader_Pattern.MatchString(m.GetClientCanAcceptSxgHeader()) {
			return SXGValidationError{
				field:  "ClientCanAcceptSxgHeader",
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
		}

	}

	if m.GetShouldEncodeSxgHeader() != "" {

		if !_SXG_ShouldEncodeSxgHeader_Pattern.MatchString(m.GetShouldEncodeSxgHeader()) {
			return SXGValidationError{
				field:  "ShouldEncodeSxgHeader",
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
		}

	}

	for idx, item := range m.GetHeaderPrefixFilters() {
		_, _ = idx, item

		if !_SXG_HeaderPrefixFilters_Pattern.MatchString(item) {
			return SXGValidationError{
				field:  fmt.Sprintf("HeaderPrefixFilters[%v]", idx),
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
		}

	}

	return nil
}

// SXGValidationError is the validation error returned by SXG.Validate if the
// designated constraints aren't met.
type SXGValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SXGValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SXGValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SXGValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SXGValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SXGValidationError) ErrorName() string { return "SXGValidationError" }

// Error satisfies the builtin error interface
func (e SXGValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSXG.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SXGValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SXGValidationError{}

var _SXG_ClientCanAcceptSxgHeader_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _SXG_ShouldEncodeSxgHeader_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _SXG_HeaderPrefixFilters_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")
