// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/streetview/publish/v1/streetview_publish.proto

package publish

import (
	context "context"
	reflect "reflect"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

var File_google_streetview_publish_v1_streetview_publish_proto protoreflect.FileDescriptor

var file_google_streetview_publish_v1_streetview_publish_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76,
	0x69, 0x65, 0x77, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x73,
	0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d,
	0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2f, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x70, 0x63, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x32, 0xe4, 0x0a, 0x0a, 0x18, 0x53, 0x74, 0x72, 0x65,
	0x65, 0x74, 0x56, 0x69, 0x65, 0x77, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x70, 0x0a, 0x0b, 0x53, 0x74, 0x61, 0x72, 0x74, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x52, 0x65, 0x66, 0x22, 0x20, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1a, 0x22, 0x15, 0x2f, 0x76,
	0x31, 0x2f, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x3a, 0x01, 0x2a, 0x12, 0x7e, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x50, 0x68, 0x6f, 0x74, 0x6f, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x22, 0x18, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x12, 0x22, 0x09, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x3a,
	0x05, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x12, 0x7c, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x50, 0x68, 0x6f,
	0x74, 0x6f, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65,
	0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65,
	0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x22, 0x1c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x16, 0x12, 0x14,
	0x2f, 0x76, 0x31, 0x2f, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x2f, 0x7b, 0x70, 0x68, 0x6f, 0x74, 0x6f,
	0x5f, 0x69, 0x64, 0x7d, 0x12, 0x98, 0x01, 0x0a, 0x0e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65,
	0x74, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x50,
	0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77,
	0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x47, 0x65, 0x74, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x1b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x15, 0x12, 0x13, 0x2f, 0x76, 0x31, 0x2f,
	0x70, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x12,
	0x83, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69,
	0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76,
	0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x12, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x0c, 0x12, 0x0a, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x68, 0x6f, 0x74, 0x6f, 0x73, 0x12, 0x92, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x50, 0x68, 0x6f, 0x74, 0x6f, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x22, 0x2c, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x26, 0x1a, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x2f,
	0x7b, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x2e, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x5f, 0x69, 0x64, 0x2e,
	0x69, 0x64, 0x7d, 0x3a, 0x05, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x12, 0xa7, 0x01, 0x0a, 0x11, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73,
	0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74,
	0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x21, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x22, 0x16, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x68, 0x6f, 0x74, 0x6f, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x3a, 0x01, 0x2a, 0x12, 0x75, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68,
	0x6f, 0x74, 0x6f, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72,
	0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x1c, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x16, 0x2a, 0x14, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x68, 0x6f, 0x74, 0x6f,
	0x2f, 0x7b, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0xa7, 0x01, 0x0a, 0x11,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f,
	0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65,
	0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x6f, 0x74,
	0x6f, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x21, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x22, 0x16, 0x2f, 0x76, 0x31, 0x2f,
	0x70, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x3a, 0x01, 0x2a, 0x1a, 0x57, 0xca, 0x41, 0x20, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74,
	0x76, 0x69, 0x65, 0x77, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x31, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x74, 0x72,
	0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x42, 0x82,
	0x01, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65,
	0x6f, 0x2e, 0x75, 0x67, 0x63, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77,
	0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x53, 0x74, 0x72,
	0x65, 0x65, 0x74, 0x56, 0x69, 0x65, 0x77, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5a, 0x43,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77,
	0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2f, 0x76, 0x31, 0x3b, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var file_google_streetview_publish_v1_streetview_publish_proto_goTypes = []interface{}{
	(*empty.Empty)(nil),               // 0: google.protobuf.Empty
	(*CreatePhotoRequest)(nil),        // 1: google.streetview.publish.v1.CreatePhotoRequest
	(*GetPhotoRequest)(nil),           // 2: google.streetview.publish.v1.GetPhotoRequest
	(*BatchGetPhotosRequest)(nil),     // 3: google.streetview.publish.v1.BatchGetPhotosRequest
	(*ListPhotosRequest)(nil),         // 4: google.streetview.publish.v1.ListPhotosRequest
	(*UpdatePhotoRequest)(nil),        // 5: google.streetview.publish.v1.UpdatePhotoRequest
	(*BatchUpdatePhotosRequest)(nil),  // 6: google.streetview.publish.v1.BatchUpdatePhotosRequest
	(*DeletePhotoRequest)(nil),        // 7: google.streetview.publish.v1.DeletePhotoRequest
	(*BatchDeletePhotosRequest)(nil),  // 8: google.streetview.publish.v1.BatchDeletePhotosRequest
	(*UploadRef)(nil),                 // 9: google.streetview.publish.v1.UploadRef
	(*Photo)(nil),                     // 10: google.streetview.publish.v1.Photo
	(*BatchGetPhotosResponse)(nil),    // 11: google.streetview.publish.v1.BatchGetPhotosResponse
	(*ListPhotosResponse)(nil),        // 12: google.streetview.publish.v1.ListPhotosResponse
	(*BatchUpdatePhotosResponse)(nil), // 13: google.streetview.publish.v1.BatchUpdatePhotosResponse
	(*BatchDeletePhotosResponse)(nil), // 14: google.streetview.publish.v1.BatchDeletePhotosResponse
}
var file_google_streetview_publish_v1_streetview_publish_proto_depIdxs = []int32{
	0,  // 0: google.streetview.publish.v1.StreetViewPublishService.StartUpload:input_type -> google.protobuf.Empty
	1,  // 1: google.streetview.publish.v1.StreetViewPublishService.CreatePhoto:input_type -> google.streetview.publish.v1.CreatePhotoRequest
	2,  // 2: google.streetview.publish.v1.StreetViewPublishService.GetPhoto:input_type -> google.streetview.publish.v1.GetPhotoRequest
	3,  // 3: google.streetview.publish.v1.StreetViewPublishService.BatchGetPhotos:input_type -> google.streetview.publish.v1.BatchGetPhotosRequest
	4,  // 4: google.streetview.publish.v1.StreetViewPublishService.ListPhotos:input_type -> google.streetview.publish.v1.ListPhotosRequest
	5,  // 5: google.streetview.publish.v1.StreetViewPublishService.UpdatePhoto:input_type -> google.streetview.publish.v1.UpdatePhotoRequest
	6,  // 6: google.streetview.publish.v1.StreetViewPublishService.BatchUpdatePhotos:input_type -> google.streetview.publish.v1.BatchUpdatePhotosRequest
	7,  // 7: google.streetview.publish.v1.StreetViewPublishService.DeletePhoto:input_type -> google.streetview.publish.v1.DeletePhotoRequest
	8,  // 8: google.streetview.publish.v1.StreetViewPublishService.BatchDeletePhotos:input_type -> google.streetview.publish.v1.BatchDeletePhotosRequest
	9,  // 9: google.streetview.publish.v1.StreetViewPublishService.StartUpload:output_type -> google.streetview.publish.v1.UploadRef
	10, // 10: google.streetview.publish.v1.StreetViewPublishService.CreatePhoto:output_type -> google.streetview.publish.v1.Photo
	10, // 11: google.streetview.publish.v1.StreetViewPublishService.GetPhoto:output_type -> google.streetview.publish.v1.Photo
	11, // 12: google.streetview.publish.v1.StreetViewPublishService.BatchGetPhotos:output_type -> google.streetview.publish.v1.BatchGetPhotosResponse
	12, // 13: google.streetview.publish.v1.StreetViewPublishService.ListPhotos:output_type -> google.streetview.publish.v1.ListPhotosResponse
	10, // 14: google.streetview.publish.v1.StreetViewPublishService.UpdatePhoto:output_type -> google.streetview.publish.v1.Photo
	13, // 15: google.streetview.publish.v1.StreetViewPublishService.BatchUpdatePhotos:output_type -> google.streetview.publish.v1.BatchUpdatePhotosResponse
	0,  // 16: google.streetview.publish.v1.StreetViewPublishService.DeletePhoto:output_type -> google.protobuf.Empty
	14, // 17: google.streetview.publish.v1.StreetViewPublishService.BatchDeletePhotos:output_type -> google.streetview.publish.v1.BatchDeletePhotosResponse
	9,  // [9:18] is the sub-list for method output_type
	0,  // [0:9] is the sub-list for method input_type
	0,  // [0:0] is the sub-list for extension type_name
	0,  // [0:0] is the sub-list for extension extendee
	0,  // [0:0] is the sub-list for field type_name
}

func init() { file_google_streetview_publish_v1_streetview_publish_proto_init() }
func file_google_streetview_publish_v1_streetview_publish_proto_init() {
	if File_google_streetview_publish_v1_streetview_publish_proto != nil {
		return
	}
	file_google_streetview_publish_v1_resources_proto_init()
	file_google_streetview_publish_v1_rpcmessages_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_streetview_publish_v1_streetview_publish_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   0,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_streetview_publish_v1_streetview_publish_proto_goTypes,
		DependencyIndexes: file_google_streetview_publish_v1_streetview_publish_proto_depIdxs,
	}.Build()
	File_google_streetview_publish_v1_streetview_publish_proto = out.File
	file_google_streetview_publish_v1_streetview_publish_proto_rawDesc = nil
	file_google_streetview_publish_v1_streetview_publish_proto_goTypes = nil
	file_google_streetview_publish_v1_streetview_publish_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// StreetViewPublishServiceClient is the client API for StreetViewPublishService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StreetViewPublishServiceClient interface {
	// Creates an upload session to start uploading photo bytes. The method uses
	// the upload URL of the returned
	// [UploadRef][google.streetview.publish.v1.UploadRef] to upload the bytes for
	// the [Photo][google.streetview.publish.v1.Photo].
	//
	// In addition to the photo requirements shown in
	// https://support.google.com/maps/answer/7012050?hl=en&ref_topic=6275604,
	// the photo must meet the following requirements:
	//
	// * Photo Sphere XMP metadata must be included in the photo medadata. See
	// https://developers.google.com/streetview/spherical-metadata for the
	// required fields.
	// * The pixel size of the photo must meet the size requirements listed in
	// https://support.google.com/maps/answer/7012050?hl=en&ref_topic=6275604, and
	// the photo must be a full 360 horizontally.
	//
	// After the upload completes, the method uses
	// [UploadRef][google.streetview.publish.v1.UploadRef] with
	// [CreatePhoto][google.streetview.publish.v1.StreetViewPublishService.CreatePhoto]
	// to create the [Photo][google.streetview.publish.v1.Photo] object entry.
	StartUpload(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*UploadRef, error)
	// After the client finishes uploading the photo with the returned
	// [UploadRef][google.streetview.publish.v1.UploadRef],
	// [CreatePhoto][google.streetview.publish.v1.StreetViewPublishService.CreatePhoto]
	// publishes the uploaded [Photo][google.streetview.publish.v1.Photo] to
	// Street View on Google Maps.
	//
	// Currently, the only way to set heading, pitch, and roll in CreatePhoto is
	// through the [Photo Sphere XMP
	// metadata](https://developers.google.com/streetview/spherical-metadata) in
	// the photo bytes. CreatePhoto ignores the `pose.heading`, `pose.pitch`,
	// `pose.roll`, `pose.altitude`, and `pose.level` fields in Pose.
	//
	// This method returns the following error codes:
	//
	// * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] if
	// the request is malformed or if the uploaded photo is not a 360 photo.
	// * [google.rpc.Code.NOT_FOUND][google.rpc.Code.NOT_FOUND] if the upload
	// reference does not exist.
	// * [google.rpc.Code.RESOURCE_EXHAUSTED][google.rpc.Code.RESOURCE_EXHAUSTED]
	// if the account has reached the storage limit.
	CreatePhoto(ctx context.Context, in *CreatePhotoRequest, opts ...grpc.CallOption) (*Photo, error)
	// Gets the metadata of the specified
	// [Photo][google.streetview.publish.v1.Photo].
	//
	// This method returns the following error codes:
	//
	// * [google.rpc.Code.PERMISSION_DENIED][google.rpc.Code.PERMISSION_DENIED] if
	// the requesting user did not create the requested
	// [Photo][google.streetview.publish.v1.Photo].
	// * [google.rpc.Code.NOT_FOUND][google.rpc.Code.NOT_FOUND] if the requested
	// [Photo][google.streetview.publish.v1.Photo] does not exist.
	// * [google.rpc.Code.UNAVAILABLE][google.rpc.Code.UNAVAILABLE] if the
	// requested [Photo][google.streetview.publish.v1.Photo] is still being
	// indexed.
	GetPhoto(ctx context.Context, in *GetPhotoRequest, opts ...grpc.CallOption) (*Photo, error)
	// Gets the metadata of the specified
	// [Photo][google.streetview.publish.v1.Photo] batch.
	//
	// Note that if
	// [BatchGetPhotos][google.streetview.publish.v1.StreetViewPublishService.BatchGetPhotos]
	// fails, either critical fields are missing or there is an authentication
	// error. Even if
	// [BatchGetPhotos][google.streetview.publish.v1.StreetViewPublishService.BatchGetPhotos]
	// succeeds, individual photos in the batch may have failures.
	// These failures are specified in each
	// [PhotoResponse.status][google.streetview.publish.v1.PhotoResponse.status]
	// in
	// [BatchGetPhotosResponse.results][google.streetview.publish.v1.BatchGetPhotosResponse.results].
	// See
	// [GetPhoto][google.streetview.publish.v1.StreetViewPublishService.GetPhoto]
	// for specific failures that can occur per photo.
	BatchGetPhotos(ctx context.Context, in *BatchGetPhotosRequest, opts ...grpc.CallOption) (*BatchGetPhotosResponse, error)
	// Lists all the [Photos][google.streetview.publish.v1.Photo] that belong to
	// the user.
	//
	// <aside class="note"><b>Note:</b> Recently created photos that are still
	// being indexed are not returned in the response.</aside>
	ListPhotos(ctx context.Context, in *ListPhotosRequest, opts ...grpc.CallOption) (*ListPhotosResponse, error)
	// Updates the metadata of a [Photo][google.streetview.publish.v1.Photo], such
	// as pose, place association, connections, etc. Changing the pixels of a
	// photo is not supported.
	//
	// Only the fields specified in the
	// [updateMask][google.streetview.publish.v1.UpdatePhotoRequest.update_mask]
	// field are used. If `updateMask` is not present, the update applies to all
	// fields.
	//
	// This method returns the following error codes:
	//
	// * [google.rpc.Code.PERMISSION_DENIED][google.rpc.Code.PERMISSION_DENIED] if
	// the requesting user did not create the requested photo.
	// * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] if
	// the request is malformed.
	// * [google.rpc.Code.NOT_FOUND][google.rpc.Code.NOT_FOUND] if the requested
	// photo does not exist.
	// * [google.rpc.Code.UNAVAILABLE][google.rpc.Code.UNAVAILABLE] if the
	// requested [Photo][google.streetview.publish.v1.Photo] is still being
	// indexed.
	UpdatePhoto(ctx context.Context, in *UpdatePhotoRequest, opts ...grpc.CallOption) (*Photo, error)
	// Updates the metadata of [Photos][google.streetview.publish.v1.Photo], such
	// as pose, place association, connections, etc. Changing the pixels of photos
	// is not supported.
	//
	// Note that if
	// [BatchUpdatePhotos][google.streetview.publish.v1.StreetViewPublishService.BatchUpdatePhotos]
	// fails, either critical fields are missing or there is an authentication
	// error. Even if
	// [BatchUpdatePhotos][google.streetview.publish.v1.StreetViewPublishService.BatchUpdatePhotos]
	// succeeds, individual photos in the batch may have failures.
	// These failures are specified in each
	// [PhotoResponse.status][google.streetview.publish.v1.PhotoResponse.status]
	// in
	// [BatchUpdatePhotosResponse.results][google.streetview.publish.v1.BatchUpdatePhotosResponse.results].
	// See
	// [UpdatePhoto][google.streetview.publish.v1.StreetViewPublishService.UpdatePhoto]
	// for specific failures that can occur per photo.
	//
	// Only the fields specified in
	// [updateMask][google.streetview.publish.v1.UpdatePhotoRequest.update_mask]
	// field are used. If `updateMask` is not present, the update applies to all
	// fields.
	//
	// The number of
	// [UpdatePhotoRequest][google.streetview.publish.v1.UpdatePhotoRequest]
	// messages in a
	// [BatchUpdatePhotosRequest][google.streetview.publish.v1.BatchUpdatePhotosRequest]
	// must not exceed 20.
	//
	// <aside class="note"><b>Note:</b> To update
	// [Pose.altitude][google.streetview.publish.v1.Pose.altitude],
	// [Pose.latLngPair][google.streetview.publish.v1.Pose.lat_lng_pair] has to be
	// filled as well. Otherwise, the request will fail.</aside>
	BatchUpdatePhotos(ctx context.Context, in *BatchUpdatePhotosRequest, opts ...grpc.CallOption) (*BatchUpdatePhotosResponse, error)
	// Deletes a [Photo][google.streetview.publish.v1.Photo] and its metadata.
	//
	// This method returns the following error codes:
	//
	// * [google.rpc.Code.PERMISSION_DENIED][google.rpc.Code.PERMISSION_DENIED] if
	// the requesting user did not create the requested photo.
	// * [google.rpc.Code.NOT_FOUND][google.rpc.Code.NOT_FOUND] if the photo ID
	// does not exist.
	DeletePhoto(ctx context.Context, in *DeletePhotoRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Deletes a list of [Photos][google.streetview.publish.v1.Photo] and their
	// metadata.
	//
	// Note that if
	// [BatchDeletePhotos][google.streetview.publish.v1.StreetViewPublishService.BatchDeletePhotos]
	// fails, either critical fields are missing or there was an authentication
	// error. Even if
	// [BatchDeletePhotos][google.streetview.publish.v1.StreetViewPublishService.BatchDeletePhotos]
	// succeeds, individual photos in the batch may have failures.
	// These failures are specified in each
	// [PhotoResponse.status][google.streetview.publish.v1.PhotoResponse.status]
	// in
	// [BatchDeletePhotosResponse.results][google.streetview.publish.v1.BatchDeletePhotosResponse.status].
	// See
	// [DeletePhoto][google.streetview.publish.v1.StreetViewPublishService.DeletePhoto]
	// for specific failures that can occur per photo.
	BatchDeletePhotos(ctx context.Context, in *BatchDeletePhotosRequest, opts ...grpc.CallOption) (*BatchDeletePhotosResponse, error)
}

type streetViewPublishServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewStreetViewPublishServiceClient(cc grpc.ClientConnInterface) StreetViewPublishServiceClient {
	return &streetViewPublishServiceClient{cc}
}

func (c *streetViewPublishServiceClient) StartUpload(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*UploadRef, error) {
	out := new(UploadRef)
	err := c.cc.Invoke(ctx, "/google.streetview.publish.v1.StreetViewPublishService/StartUpload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streetViewPublishServiceClient) CreatePhoto(ctx context.Context, in *CreatePhotoRequest, opts ...grpc.CallOption) (*Photo, error) {
	out := new(Photo)
	err := c.cc.Invoke(ctx, "/google.streetview.publish.v1.StreetViewPublishService/CreatePhoto", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streetViewPublishServiceClient) GetPhoto(ctx context.Context, in *GetPhotoRequest, opts ...grpc.CallOption) (*Photo, error) {
	out := new(Photo)
	err := c.cc.Invoke(ctx, "/google.streetview.publish.v1.StreetViewPublishService/GetPhoto", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streetViewPublishServiceClient) BatchGetPhotos(ctx context.Context, in *BatchGetPhotosRequest, opts ...grpc.CallOption) (*BatchGetPhotosResponse, error) {
	out := new(BatchGetPhotosResponse)
	err := c.cc.Invoke(ctx, "/google.streetview.publish.v1.StreetViewPublishService/BatchGetPhotos", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streetViewPublishServiceClient) ListPhotos(ctx context.Context, in *ListPhotosRequest, opts ...grpc.CallOption) (*ListPhotosResponse, error) {
	out := new(ListPhotosResponse)
	err := c.cc.Invoke(ctx, "/google.streetview.publish.v1.StreetViewPublishService/ListPhotos", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streetViewPublishServiceClient) UpdatePhoto(ctx context.Context, in *UpdatePhotoRequest, opts ...grpc.CallOption) (*Photo, error) {
	out := new(Photo)
	err := c.cc.Invoke(ctx, "/google.streetview.publish.v1.StreetViewPublishService/UpdatePhoto", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streetViewPublishServiceClient) BatchUpdatePhotos(ctx context.Context, in *BatchUpdatePhotosRequest, opts ...grpc.CallOption) (*BatchUpdatePhotosResponse, error) {
	out := new(BatchUpdatePhotosResponse)
	err := c.cc.Invoke(ctx, "/google.streetview.publish.v1.StreetViewPublishService/BatchUpdatePhotos", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streetViewPublishServiceClient) DeletePhoto(ctx context.Context, in *DeletePhotoRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.streetview.publish.v1.StreetViewPublishService/DeletePhoto", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streetViewPublishServiceClient) BatchDeletePhotos(ctx context.Context, in *BatchDeletePhotosRequest, opts ...grpc.CallOption) (*BatchDeletePhotosResponse, error) {
	out := new(BatchDeletePhotosResponse)
	err := c.cc.Invoke(ctx, "/google.streetview.publish.v1.StreetViewPublishService/BatchDeletePhotos", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StreetViewPublishServiceServer is the server API for StreetViewPublishService service.
type StreetViewPublishServiceServer interface {
	// Creates an upload session to start uploading photo bytes. The method uses
	// the upload URL of the returned
	// [UploadRef][google.streetview.publish.v1.UploadRef] to upload the bytes for
	// the [Photo][google.streetview.publish.v1.Photo].
	//
	// In addition to the photo requirements shown in
	// https://support.google.com/maps/answer/7012050?hl=en&ref_topic=6275604,
	// the photo must meet the following requirements:
	//
	// * Photo Sphere XMP metadata must be included in the photo medadata. See
	// https://developers.google.com/streetview/spherical-metadata for the
	// required fields.
	// * The pixel size of the photo must meet the size requirements listed in
	// https://support.google.com/maps/answer/7012050?hl=en&ref_topic=6275604, and
	// the photo must be a full 360 horizontally.
	//
	// After the upload completes, the method uses
	// [UploadRef][google.streetview.publish.v1.UploadRef] with
	// [CreatePhoto][google.streetview.publish.v1.StreetViewPublishService.CreatePhoto]
	// to create the [Photo][google.streetview.publish.v1.Photo] object entry.
	StartUpload(context.Context, *empty.Empty) (*UploadRef, error)
	// After the client finishes uploading the photo with the returned
	// [UploadRef][google.streetview.publish.v1.UploadRef],
	// [CreatePhoto][google.streetview.publish.v1.StreetViewPublishService.CreatePhoto]
	// publishes the uploaded [Photo][google.streetview.publish.v1.Photo] to
	// Street View on Google Maps.
	//
	// Currently, the only way to set heading, pitch, and roll in CreatePhoto is
	// through the [Photo Sphere XMP
	// metadata](https://developers.google.com/streetview/spherical-metadata) in
	// the photo bytes. CreatePhoto ignores the `pose.heading`, `pose.pitch`,
	// `pose.roll`, `pose.altitude`, and `pose.level` fields in Pose.
	//
	// This method returns the following error codes:
	//
	// * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] if
	// the request is malformed or if the uploaded photo is not a 360 photo.
	// * [google.rpc.Code.NOT_FOUND][google.rpc.Code.NOT_FOUND] if the upload
	// reference does not exist.
	// * [google.rpc.Code.RESOURCE_EXHAUSTED][google.rpc.Code.RESOURCE_EXHAUSTED]
	// if the account has reached the storage limit.
	CreatePhoto(context.Context, *CreatePhotoRequest) (*Photo, error)
	// Gets the metadata of the specified
	// [Photo][google.streetview.publish.v1.Photo].
	//
	// This method returns the following error codes:
	//
	// * [google.rpc.Code.PERMISSION_DENIED][google.rpc.Code.PERMISSION_DENIED] if
	// the requesting user did not create the requested
	// [Photo][google.streetview.publish.v1.Photo].
	// * [google.rpc.Code.NOT_FOUND][google.rpc.Code.NOT_FOUND] if the requested
	// [Photo][google.streetview.publish.v1.Photo] does not exist.
	// * [google.rpc.Code.UNAVAILABLE][google.rpc.Code.UNAVAILABLE] if the
	// requested [Photo][google.streetview.publish.v1.Photo] is still being
	// indexed.
	GetPhoto(context.Context, *GetPhotoRequest) (*Photo, error)
	// Gets the metadata of the specified
	// [Photo][google.streetview.publish.v1.Photo] batch.
	//
	// Note that if
	// [BatchGetPhotos][google.streetview.publish.v1.StreetViewPublishService.BatchGetPhotos]
	// fails, either critical fields are missing or there is an authentication
	// error. Even if
	// [BatchGetPhotos][google.streetview.publish.v1.StreetViewPublishService.BatchGetPhotos]
	// succeeds, individual photos in the batch may have failures.
	// These failures are specified in each
	// [PhotoResponse.status][google.streetview.publish.v1.PhotoResponse.status]
	// in
	// [BatchGetPhotosResponse.results][google.streetview.publish.v1.BatchGetPhotosResponse.results].
	// See
	// [GetPhoto][google.streetview.publish.v1.StreetViewPublishService.GetPhoto]
	// for specific failures that can occur per photo.
	BatchGetPhotos(context.Context, *BatchGetPhotosRequest) (*BatchGetPhotosResponse, error)
	// Lists all the [Photos][google.streetview.publish.v1.Photo] that belong to
	// the user.
	//
	// <aside class="note"><b>Note:</b> Recently created photos that are still
	// being indexed are not returned in the response.</aside>
	ListPhotos(context.Context, *ListPhotosRequest) (*ListPhotosResponse, error)
	// Updates the metadata of a [Photo][google.streetview.publish.v1.Photo], such
	// as pose, place association, connections, etc. Changing the pixels of a
	// photo is not supported.
	//
	// Only the fields specified in the
	// [updateMask][google.streetview.publish.v1.UpdatePhotoRequest.update_mask]
	// field are used. If `updateMask` is not present, the update applies to all
	// fields.
	//
	// This method returns the following error codes:
	//
	// * [google.rpc.Code.PERMISSION_DENIED][google.rpc.Code.PERMISSION_DENIED] if
	// the requesting user did not create the requested photo.
	// * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] if
	// the request is malformed.
	// * [google.rpc.Code.NOT_FOUND][google.rpc.Code.NOT_FOUND] if the requested
	// photo does not exist.
	// * [google.rpc.Code.UNAVAILABLE][google.rpc.Code.UNAVAILABLE] if the
	// requested [Photo][google.streetview.publish.v1.Photo] is still being
	// indexed.
	UpdatePhoto(context.Context, *UpdatePhotoRequest) (*Photo, error)
	// Updates the metadata of [Photos][google.streetview.publish.v1.Photo], such
	// as pose, place association, connections, etc. Changing the pixels of photos
	// is not supported.
	//
	// Note that if
	// [BatchUpdatePhotos][google.streetview.publish.v1.StreetViewPublishService.BatchUpdatePhotos]
	// fails, either critical fields are missing or there is an authentication
	// error. Even if
	// [BatchUpdatePhotos][google.streetview.publish.v1.StreetViewPublishService.BatchUpdatePhotos]
	// succeeds, individual photos in the batch may have failures.
	// These failures are specified in each
	// [PhotoResponse.status][google.streetview.publish.v1.PhotoResponse.status]
	// in
	// [BatchUpdatePhotosResponse.results][google.streetview.publish.v1.BatchUpdatePhotosResponse.results].
	// See
	// [UpdatePhoto][google.streetview.publish.v1.StreetViewPublishService.UpdatePhoto]
	// for specific failures that can occur per photo.
	//
	// Only the fields specified in
	// [updateMask][google.streetview.publish.v1.UpdatePhotoRequest.update_mask]
	// field are used. If `updateMask` is not present, the update applies to all
	// fields.
	//
	// The number of
	// [UpdatePhotoRequest][google.streetview.publish.v1.UpdatePhotoRequest]
	// messages in a
	// [BatchUpdatePhotosRequest][google.streetview.publish.v1.BatchUpdatePhotosRequest]
	// must not exceed 20.
	//
	// <aside class="note"><b>Note:</b> To update
	// [Pose.altitude][google.streetview.publish.v1.Pose.altitude],
	// [Pose.latLngPair][google.streetview.publish.v1.Pose.lat_lng_pair] has to be
	// filled as well. Otherwise, the request will fail.</aside>
	BatchUpdatePhotos(context.Context, *BatchUpdatePhotosRequest) (*BatchUpdatePhotosResponse, error)
	// Deletes a [Photo][google.streetview.publish.v1.Photo] and its metadata.
	//
	// This method returns the following error codes:
	//
	// * [google.rpc.Code.PERMISSION_DENIED][google.rpc.Code.PERMISSION_DENIED] if
	// the requesting user did not create the requested photo.
	// * [google.rpc.Code.NOT_FOUND][google.rpc.Code.NOT_FOUND] if the photo ID
	// does not exist.
	DeletePhoto(context.Context, *DeletePhotoRequest) (*empty.Empty, error)
	// Deletes a list of [Photos][google.streetview.publish.v1.Photo] and their
	// metadata.
	//
	// Note that if
	// [BatchDeletePhotos][google.streetview.publish.v1.StreetViewPublishService.BatchDeletePhotos]
	// fails, either critical fields are missing or there was an authentication
	// error. Even if
	// [BatchDeletePhotos][google.streetview.publish.v1.StreetViewPublishService.BatchDeletePhotos]
	// succeeds, individual photos in the batch may have failures.
	// These failures are specified in each
	// [PhotoResponse.status][google.streetview.publish.v1.PhotoResponse.status]
	// in
	// [BatchDeletePhotosResponse.results][google.streetview.publish.v1.BatchDeletePhotosResponse.status].
	// See
	// [DeletePhoto][google.streetview.publish.v1.StreetViewPublishService.DeletePhoto]
	// for specific failures that can occur per photo.
	BatchDeletePhotos(context.Context, *BatchDeletePhotosRequest) (*BatchDeletePhotosResponse, error)
}

// UnimplementedStreetViewPublishServiceServer can be embedded to have forward compatible implementations.
type UnimplementedStreetViewPublishServiceServer struct {
}

func (*UnimplementedStreetViewPublishServiceServer) StartUpload(context.Context, *empty.Empty) (*UploadRef, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartUpload not implemented")
}
func (*UnimplementedStreetViewPublishServiceServer) CreatePhoto(context.Context, *CreatePhotoRequest) (*Photo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePhoto not implemented")
}
func (*UnimplementedStreetViewPublishServiceServer) GetPhoto(context.Context, *GetPhotoRequest) (*Photo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPhoto not implemented")
}
func (*UnimplementedStreetViewPublishServiceServer) BatchGetPhotos(context.Context, *BatchGetPhotosRequest) (*BatchGetPhotosResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetPhotos not implemented")
}
func (*UnimplementedStreetViewPublishServiceServer) ListPhotos(context.Context, *ListPhotosRequest) (*ListPhotosResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPhotos not implemented")
}
func (*UnimplementedStreetViewPublishServiceServer) UpdatePhoto(context.Context, *UpdatePhotoRequest) (*Photo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePhoto not implemented")
}
func (*UnimplementedStreetViewPublishServiceServer) BatchUpdatePhotos(context.Context, *BatchUpdatePhotosRequest) (*BatchUpdatePhotosResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdatePhotos not implemented")
}
func (*UnimplementedStreetViewPublishServiceServer) DeletePhoto(context.Context, *DeletePhotoRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePhoto not implemented")
}
func (*UnimplementedStreetViewPublishServiceServer) BatchDeletePhotos(context.Context, *BatchDeletePhotosRequest) (*BatchDeletePhotosResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeletePhotos not implemented")
}

func RegisterStreetViewPublishServiceServer(s *grpc.Server, srv StreetViewPublishServiceServer) {
	s.RegisterService(&_StreetViewPublishService_serviceDesc, srv)
}

func _StreetViewPublishService_StartUpload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreetViewPublishServiceServer).StartUpload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.streetview.publish.v1.StreetViewPublishService/StartUpload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreetViewPublishServiceServer).StartUpload(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreetViewPublishService_CreatePhoto_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePhotoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreetViewPublishServiceServer).CreatePhoto(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.streetview.publish.v1.StreetViewPublishService/CreatePhoto",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreetViewPublishServiceServer).CreatePhoto(ctx, req.(*CreatePhotoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreetViewPublishService_GetPhoto_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPhotoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreetViewPublishServiceServer).GetPhoto(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.streetview.publish.v1.StreetViewPublishService/GetPhoto",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreetViewPublishServiceServer).GetPhoto(ctx, req.(*GetPhotoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreetViewPublishService_BatchGetPhotos_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetPhotosRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreetViewPublishServiceServer).BatchGetPhotos(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.streetview.publish.v1.StreetViewPublishService/BatchGetPhotos",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreetViewPublishServiceServer).BatchGetPhotos(ctx, req.(*BatchGetPhotosRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreetViewPublishService_ListPhotos_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPhotosRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreetViewPublishServiceServer).ListPhotos(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.streetview.publish.v1.StreetViewPublishService/ListPhotos",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreetViewPublishServiceServer).ListPhotos(ctx, req.(*ListPhotosRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreetViewPublishService_UpdatePhoto_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePhotoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreetViewPublishServiceServer).UpdatePhoto(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.streetview.publish.v1.StreetViewPublishService/UpdatePhoto",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreetViewPublishServiceServer).UpdatePhoto(ctx, req.(*UpdatePhotoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreetViewPublishService_BatchUpdatePhotos_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdatePhotosRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreetViewPublishServiceServer).BatchUpdatePhotos(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.streetview.publish.v1.StreetViewPublishService/BatchUpdatePhotos",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreetViewPublishServiceServer).BatchUpdatePhotos(ctx, req.(*BatchUpdatePhotosRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreetViewPublishService_DeletePhoto_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePhotoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreetViewPublishServiceServer).DeletePhoto(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.streetview.publish.v1.StreetViewPublishService/DeletePhoto",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreetViewPublishServiceServer).DeletePhoto(ctx, req.(*DeletePhotoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreetViewPublishService_BatchDeletePhotos_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeletePhotosRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreetViewPublishServiceServer).BatchDeletePhotos(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.streetview.publish.v1.StreetViewPublishService/BatchDeletePhotos",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreetViewPublishServiceServer).BatchDeletePhotos(ctx, req.(*BatchDeletePhotosRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _StreetViewPublishService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.streetview.publish.v1.StreetViewPublishService",
	HandlerType: (*StreetViewPublishServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "StartUpload",
			Handler:    _StreetViewPublishService_StartUpload_Handler,
		},
		{
			MethodName: "CreatePhoto",
			Handler:    _StreetViewPublishService_CreatePhoto_Handler,
		},
		{
			MethodName: "GetPhoto",
			Handler:    _StreetViewPublishService_GetPhoto_Handler,
		},
		{
			MethodName: "BatchGetPhotos",
			Handler:    _StreetViewPublishService_BatchGetPhotos_Handler,
		},
		{
			MethodName: "ListPhotos",
			Handler:    _StreetViewPublishService_ListPhotos_Handler,
		},
		{
			MethodName: "UpdatePhoto",
			Handler:    _StreetViewPublishService_UpdatePhoto_Handler,
		},
		{
			MethodName: "BatchUpdatePhotos",
			Handler:    _StreetViewPublishService_BatchUpdatePhotos_Handler,
		},
		{
			MethodName: "DeletePhoto",
			Handler:    _StreetViewPublishService_DeletePhoto_Handler,
		},
		{
			MethodName: "BatchDeletePhotos",
			Handler:    _StreetViewPublishService_BatchDeletePhotos_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/streetview/publish/v1/streetview_publish.proto",
}
