/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.reader;

import com.sun.msv.datatype.xsd.AnyURIType;
import com.sun.msv.datatype.xsd.ConcreteType;
import com.sun.msv.datatype.xsd.DurationType;
import com.sun.msv.datatype.xsd.GDayType;
import com.sun.msv.datatype.xsd.GMonthDayType;
import com.sun.msv.datatype.xsd.GMonthType;
import com.sun.msv.datatype.xsd.GYearMonthType;
import com.sun.msv.datatype.xsd.GYearType;
import com.sun.msv.datatype.xsd.NormalizedStringType;
import com.sun.msv.datatype.xsd.NumberType;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.grammar.IDContextProvider;
import com.sun.msv.grammar.ReferenceContainer;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.reader.ExpressionState;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.State;
import com.sun.msv.util.StartTagInfo;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.relaxng.datatype.Datatype;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class GrammarReader
extends XMLFilterImpl
implements IDContextProvider {
    public Locator locator;
    public final GrammarReaderController controller;
    public final SAXParserFactory parserFactory;
    public final ExpressionPool pool;
    public static final PrefixResolver basePrefixResolver = new PrefixResolver(){

        public String resolve(String string) {
            if (string.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            return null;
        }
    };
    public PrefixResolver prefixResolver = basePrefixResolver;
    private InclusionContext pendingIncludes;
    private Stack includeStack = new Stack();
    public final BackwardReferenceMap backwardReference = new BackwardReferenceMap();
    private final Map declaredLocations = new HashMap();
    protected final Vector backPatchJobs = new Vector();
    public boolean hadError = false;
    public static final String ERR_MALPLACED_ELEMENT = "GrammarReader.MalplacedElement";
    public static final String ERR_IO_EXCEPTION = "GrammarReader.IOException";
    public static final String ERR_SAX_EXCEPTION = "GrammarReader.SAXException";
    public static final String ERR_XMLPARSERFACTORY_EXCEPTION = "GrammarReader.XMLParserFactoryException";
    public static final String ERR_CHARACTERS = "GrammarReader.Characters";
    public static final String ERR_DISALLOWED_ATTRIBUTE = "GrammarReader.DisallowedAttribute";
    public static final String ERR_MISSING_ATTRIBUTE = "GrammarReader.MissingAttribute";
    public static final String ERR_BAD_ATTRIBUTE_VALUE = "GrammarReader.BadAttributeValue";
    public static final String ERR_MISSING_ATTRIBUTE_2 = "GrammarReader.MissingAttribute.2";
    public static final String ERR_CONFLICTING_ATTRIBUTES = "GrammarReader.ConflictingAttribute";
    public static final String ERR_RECURSIVE_INCLUDE = "GrammarReader.RecursiveInclude";
    public static final String ERR_FRAGMENT_IDENTIFIER = "GrammarReader.FragmentIdentifier";
    public static final String ERR_UNDEFINED_DATATYPE = "GrammarReader.UndefinedDataType";
    public static final String ERR_DATATYPE_ALREADY_DEFINED = "GrammarReader.DataTypeAlreadyDefined";
    public static final String ERR_MISSING_CHILD_EXPRESSION = "GrammarReader.Abstract.MissingChildExpression";
    public static final String ERR_MORE_THAN_ONE_CHILD_EXPRESSION = "GrammarReader.Abstract.MoreThanOneChildExpression";
    public static final String ERR_MORE_THAN_ONE_CHILD_TYPE = "GrammarReader.Abstract.MoreThanOneChildType";
    public static final String ERR_MISSING_CHILD_TYPE = "GrammarReader.Abstract.MissingChildType";
    public static final String ERR_ILLEGAL_FINAL_VALUE = "GrammarReader.IllegalFinalValue";
    public static final String ERR_RUNAWAY_EXPRESSION = "GrammarReader.Abstract.RunAwayExpression";
    public static final String ERR_MISSING_TOPLEVEL = "GrammarReader.Abstract.MissingTopLevel";
    public static final String WRN_MAYBE_WRONG_NAMESPACE = "GrammarReader.Warning.MaybeWrongNamespace";
    public static final String WRN_DEPRECATED_TYPENAME = "GrammarReader.Warning.DeprecatedTypeName";
    public static final String ERR_BAD_TYPE = "GrammarReader.BadType";
    public static final String ERR_RECURSIVE_DATATYPE = "GrammarReader.RecursiveDatatypeDefinition";

    protected static SAXParserFactory createParserFactory() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        return sAXParserFactory;
    }

    protected GrammarReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, ExpressionPool expressionPool, State state) {
        this.controller = grammarReaderController;
        this.parserFactory = sAXParserFactory;
        if (!sAXParserFactory.isNamespaceAware()) {
            throw new IllegalArgumentException("parser factory must be namespace-aware");
        }
        this.pool = expressionPool;
        this.pushState(state, null, null);
    }

    public abstract Grammar getResultAsGrammar();

    protected abstract boolean isGrammarElement(StartTagInfo var1);

    public void startPrefixMapping(String string, String string2) throws SAXException {
        PrefixResolver prefixResolver = this.prefixResolver;
        this.prefixResolver = new ChainPrefixResolver(string, string2);
        super.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.prefixResolver = ((ChainPrefixResolver)this.prefixResolver).previous;
        super.endPrefixMapping(string);
    }

    public String[] splitQName(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            String string2 = this.prefixResolver.resolve("");
            if (string2 == null) {
                string2 = "";
            }
            return new String[]{string2, string, string};
        }
        String string3 = this.prefixResolver.resolve(string.substring(0, n));
        if (string3 == null) {
            return null;
        }
        return new String[]{string3, string.substring(n + 1), string};
    }

    protected Expression interceptExpression(ExpressionState expressionState, Expression expression) {
        return expression;
    }

    public abstract Datatype resolveDataType(String var1);

    public Datatype getBackwardCompatibleType(String string) {
        ConcreteType concreteType = null;
        if (string.equals("uriReference")) {
            concreteType = AnyURIType.theInstance;
        } else if (string.equals("number")) {
            concreteType = NumberType.theInstance;
        } else if (string.equals("timeDuration")) {
            concreteType = DurationType.theInstance;
        } else if (string.equals("CDATA")) {
            concreteType = NormalizedStringType.theInstance;
        } else if (string.equals("year")) {
            concreteType = GYearType.theInstance;
        } else if (string.equals("yearMonth")) {
            concreteType = GYearMonthType.theInstance;
        } else if (string.equals("month")) {
            concreteType = GMonthType.theInstance;
        } else if (string.equals("monthDay")) {
            concreteType = GMonthDayType.theInstance;
        } else if (string.equals("day")) {
            concreteType = GDayType.theInstance;
        }
        if (concreteType != null) {
            this.reportWarning(WRN_DEPRECATED_TYPENAME, string, concreteType.displayName());
        }
        return concreteType;
    }

    private void pushInclusionContext() {
        this.pendingIncludes = new InclusionContext(this.prefixResolver, this.locator, this.locator.getSystemId(), this.pendingIncludes);
        this.prefixResolver = basePrefixResolver;
        this.locator = null;
    }

    private void popInclusionContext() {
        this.prefixResolver = this.pendingIncludes.prefixResolver;
        this.locator = this.pendingIncludes.locator;
        this.pendingIncludes = this.pendingIncludes.previousContext;
    }

    public final InputSource resolveLocation(State state, String string) {
        string = this.combineURL(state.getBaseURI(), string);
        try {
            InputSource inputSource = this.controller.resolveEntity(null, string);
            if (inputSource == null) {
                return new InputSource(string);
            }
            return inputSource;
        }
        catch (IOException iOException) {
            this.reportError(iOException, ERR_IO_EXCEPTION);
            return null;
        }
        catch (SAXException sAXException) {
            this.reportError(sAXException, ERR_SAX_EXCEPTION);
            return null;
        }
    }

    public final String combineURL(String string, String string2) {
        try {
            return new URL(new URL(string), string2).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return string2;
        }
    }

    public void switchSource(State state, String string, State state2) {
        InputSource inputSource;
        if (string.indexOf(35) >= 0) {
            this.reportError(ERR_FRAGMENT_IDENTIFIER, (Object)string);
        }
        if ((inputSource = this.resolveLocation(state, string)) == null) {
            return;
        }
        string = inputSource.getSystemId();
        InclusionContext inclusionContext = this.pendingIncludes;
        while (inclusionContext != null) {
            if (inclusionContext.systemId.equals(string)) {
                String string2 = "";
                InclusionContext inclusionContext2 = this.pendingIncludes;
                while (inclusionContext2 != inclusionContext) {
                    string2 = inclusionContext2.systemId + " > " + string2;
                    inclusionContext2 = inclusionContext2.previousContext;
                }
                string2 = string + " > " + string2 + string;
                this.reportError(ERR_RECURSIVE_INCLUDE, (Object)string2);
                return;
            }
            inclusionContext = inclusionContext.previousContext;
        }
        this.pushInclusionContext();
        State state3 = this.getCurrentState();
        try {
            this.pushState(state2, null, null);
            this._parse(inputSource, state3.location);
            Object var9_9 = null;
            super.setContentHandler(state3);
            this.popInclusionContext();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            super.setContentHandler(state3);
            this.popInclusionContext();
            throw throwable;
        }
    }

    public final void parse(String string) {
        this._parse(string, null);
    }

    public final void parse(InputSource inputSource) {
        this._parse(inputSource, null);
    }

    private void _parse(Object object, Locator locator) {
        try {
            XMLReader xMLReader = this.parserFactory.newSAXParser().getXMLReader();
            xMLReader.setContentHandler(this);
            if (object instanceof InputSource) {
                xMLReader.parse((InputSource)object);
            }
            if (object instanceof String) {
                xMLReader.parse((String)object);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.reportError(ERR_XMLPARSERFACTORY_EXCEPTION, new Object[]{parserConfigurationException.getMessage()}, parserConfigurationException, new Locator[]{locator});
        }
        catch (IOException iOException) {
            this.reportError(ERR_IO_EXCEPTION, new Object[]{iOException.getMessage()}, iOException, new Locator[]{locator});
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof RuntimeException) {
                throw (RuntimeException)sAXException.getException();
            }
            this.reportError(ERR_SAX_EXCEPTION, new Object[]{sAXException.getMessage()}, sAXException, new Locator[]{locator});
        }
    }

    public void setDeclaredLocationOf(Object object) {
        this.declaredLocations.put(object, new LocatorImpl(this.locator));
    }

    public Locator getDeclaredLocationOf(Object object) {
        return (Locator)this.declaredLocations.get(object);
    }

    public void detectUndefinedOnes(ReferenceContainer referenceContainer, String string) {
        Iterator iterator = referenceContainer.iterator();
        while (iterator.hasNext()) {
            ReferenceExp referenceExp = (ReferenceExp)iterator.next();
            if (referenceExp.isDefined()) continue;
            this.reportError(this.backwardReference.getReferer(referenceExp), string, new Object[]{referenceExp.name});
            referenceExp.exp = Expression.nullSet;
        }
    }

    public void pushState(State state, State state2, StartTagInfo startTagInfo) {
        super.setContentHandler(state);
        state.init(this, state2, startTagInfo);
    }

    public void popState() {
        State state = this.getCurrentState();
        if (state.parentState != null) {
            super.setContentHandler(state.parentState);
        } else {
            super.setContentHandler(new DefaultHandler());
        }
    }

    public final State getCurrentState() {
        return (State)super.getContentHandler();
    }

    public abstract State createExpressionChildState(State var1, StartTagInfo var2);

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    public String resolveNamespacePrefix(String string) {
        return this.prefixResolver.resolve(string);
    }

    public boolean isUnparsedEntity(String string) {
        return true;
    }

    public boolean isNotation(String string) {
        return true;
    }

    public String getBaseUri() {
        return this.getCurrentState().getBaseURI();
    }

    public void onID(Datatype datatype, String string) {
    }

    public void addBackPatchJob(BackPatch backPatch) {
        this.backPatchJobs.add(backPatch);
    }

    public final void reportError(String string) {
        this.reportError(string, null, null, null);
    }

    public final void reportError(String string, Object object) {
        this.reportError(string, new Object[]{object}, null, null);
    }

    public final void reportError(String string, Object object, Object object2) {
        this.reportError(string, new Object[]{object, object2}, null, null);
    }

    public final void reportError(String string, Object object, Object object2, Object object3) {
        this.reportError(string, new Object[]{object, object2, object3}, null, null);
    }

    public final void reportError(Exception exception, String string) {
        this.reportError(string, null, exception, null);
    }

    public final void reportError(Exception exception, String string, Object object) {
        this.reportError(string, new Object[]{object}, exception, null);
    }

    public final void reportError(Locator[] locatorArray, String string, Object[] objectArray) {
        this.reportError(string, objectArray, null, locatorArray);
    }

    public final void reportWarning(String string) {
        this.reportWarning(string, null, null);
    }

    public final void reportWarning(String string, Object object) {
        this.reportWarning(string, new Object[]{object}, null);
    }

    public final void reportWarning(String string, Object object, Object object2) {
        this.reportWarning(string, new Object[]{object, object2}, null);
    }

    private Locator[] prepareLocation(Locator[] locatorArray) {
        if (locatorArray != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < locatorArray.length) {
                if (locatorArray[n2] != null) {
                    ++n;
                }
                ++n2;
            }
            if (locatorArray.length == n) {
                return locatorArray;
            }
            Locator[] locatorArray2 = new Locator[n];
            n = 0;
            int n3 = 0;
            while (n3 < locatorArray.length) {
                if (locatorArray[n3] != null) {
                    locatorArray2[n++] = locatorArray[n3];
                }
                ++n3;
            }
            return locatorArray2;
        }
        if (this.locator != null) {
            return new Locator[]{this.locator};
        }
        return new Locator[0];
    }

    public final void reportError(String string, Object[] objectArray, Exception exception, Locator[] locatorArray) {
        this.hadError = true;
        this.controller.error(this.prepareLocation(locatorArray), this.localizeMessage(string, objectArray), exception);
    }

    public final void reportWarning(String string, Object[] objectArray, Locator[] locatorArray) {
        this.controller.warning(this.prepareLocation(locatorArray), this.localizeMessage(string, objectArray));
    }

    protected abstract String localizeMessage(String var1, Object[] var2);

    public static interface BackPatch {
        public void patch();

        public State getOwnerState();
    }

    public class BackwardReferenceMap {
        private final Map impl = new HashMap();

        public void memorizeLink(Object object) {
            ArrayList arrayList;
            if (this.impl.containsKey(object)) {
                arrayList = (ArrayList)this.impl.get(object);
            } else {
                arrayList = new ArrayList();
                this.impl.put(object, arrayList);
            }
            arrayList.add(new LocatorImpl(GrammarReader.this.locator));
        }

        public Locator[] getReferer(Object object) {
            if (this.impl.containsKey(object)) {
                ArrayList arrayList = (ArrayList)this.impl.get(object);
                Locator[] locatorArray = new Locator[arrayList.size()];
                arrayList.toArray(locatorArray);
                return locatorArray;
            }
            return null;
        }
    }

    private class InclusionContext {
        final PrefixResolver prefixResolver;
        final Locator locator;
        final String systemId;
        final InclusionContext previousContext;

        InclusionContext(PrefixResolver prefixResolver, Locator locator, String string, InclusionContext inclusionContext) {
            this.prefixResolver = prefixResolver;
            this.locator = locator;
            this.systemId = string;
            this.previousContext = inclusionContext;
        }
    }

    public class ChainPrefixResolver
    implements PrefixResolver {
        public final PrefixResolver previous;
        public final String prefix;
        public final String uri;

        public ChainPrefixResolver(String string, String string2) {
            this.prefix = string;
            this.uri = string2;
            this.previous = GrammarReader.this.prefixResolver;
        }

        public String resolve(String string) {
            if (string.equals(this.prefix)) {
                return this.uri;
            }
            return this.previous.resolve(string);
        }
    }

    public static interface PrefixResolver {
        public String resolve(String var1);
    }
}

