/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.BinaryBaseType;
import com.sun.msv.datatype.xsd.BinaryValueType;
import org.relaxng.datatype.ValidationContext;

public class HexBinaryType
extends BinaryBaseType {
    public static final HexBinaryType theInstance = new HexBinaryType();

    private HexBinaryType() {
        super("hexBinary");
    }

    private static int hexToBin(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    public Object _createValue(String string, ValidationContext validationContext) {
        int n = string.length();
        if (n % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        while (n2 < n) {
            int n3 = HexBinaryType.hexToBin(string.charAt(n2));
            int n4 = HexBinaryType.hexToBin(string.charAt(n2 + 1));
            if (n3 == -1 || n4 == -1) {
                return null;
            }
            byArray[n2 / 2] = (byte)(n3 * 16 + n4);
            n2 += 2;
        }
        return new BinaryValueType(byArray);
    }

    protected boolean checkFormat(String string, ValidationContext validationContext) {
        int n = string.length();
        if (n % 2 != 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (HexBinaryType.hexToBin(string.charAt(n2)) == -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String serializeJavaObject(Object object, SerializationContext serializationContext) {
        if (!(object instanceof byte[])) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = (byte[])object;
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(this.encode(byArray[n] >> 4));
            stringBuffer.append(this.encode(byArray[n] & 0xF));
            ++n;
        }
        return stringBuffer.toString();
    }

    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (!(object instanceof BinaryValueType)) {
            throw new IllegalArgumentException();
        }
        return this.serializeJavaObject(((BinaryValueType)object).rawData, serializationContext);
    }

    public char encode(int n) {
        if ((n &= 0xF) < 10) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }
}

